/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.palantir.conjure.java.api.errors.ImmutableErrorType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ErrorType {
    private static final String UPPER_CAMEL_CASE = "(([A-Z][a-z0-9]+)+)";
    private static final Pattern ERROR_NAME_PATTERN = Pattern.compile(String.format("%s:%s", "(([A-Z][a-z0-9]+)+)", "(([A-Z][a-z0-9]+)+)"));
    public static final ErrorType UNAUTHORIZED = ErrorType.createInternal(Code.UNAUTHORIZED, "Default:Unauthorized");
    public static final ErrorType PERMISSION_DENIED = ErrorType.createInternal(Code.PERMISSION_DENIED, "Default:PermissionDenied");
    public static final ErrorType INVALID_ARGUMENT = ErrorType.createInternal(Code.INVALID_ARGUMENT, "Default:InvalidArgument");
    public static final ErrorType REQUEST_ENTITY_TOO_LARGE = ErrorType.createInternal(Code.REQUEST_ENTITY_TOO_LARGE, "Default:RequestEntityTooLarge");
    public static final ErrorType NOT_FOUND = ErrorType.createInternal(Code.NOT_FOUND, "Default:NotFound");
    public static final ErrorType CONFLICT = ErrorType.createInternal(Code.CONFLICT, "Default:Conflict");
    public static final ErrorType FAILED_PRECONDITION = ErrorType.createInternal(Code.FAILED_PRECONDITION, "Default:FailedPrecondition");
    public static final ErrorType INTERNAL = ErrorType.createInternal(Code.INTERNAL, "Default:Internal");
    public static final ErrorType TIMEOUT = ErrorType.createInternal(Code.TIMEOUT, "Default:Timeout");

    public abstract Code code();

    public abstract String name();

    public abstract int httpErrorCode();

    @Value.Check
    final void check() {
        if (!ERROR_NAME_PATTERN.matcher(this.name()).matches()) {
            throw new IllegalArgumentException("ErrorType names must be of the form 'UpperCamelNamespace:UpperCamelName': " + this.name());
        }
    }

    public static ErrorType create(Code code, String name) {
        return ErrorType.createAndCheckNamespaceIsNotDefault(code, name);
    }

    private static ErrorType createAndCheckNamespaceIsNotDefault(Code code, String name) {
        ErrorType error = ErrorType.createInternal(code, name);
        Matcher matcher = ERROR_NAME_PATTERN.matcher(name);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Expected ERROR_NAME_PATTERN to match, this is a bug: " + name);
        }
        String namespace = matcher.group(1);
        if (namespace.equals("Default")) {
            throw new IllegalArgumentException("Namespace must not be 'Default' in ErrorType name: " + name);
        }
        return error;
    }

    private static ErrorType createInternal(Code code, String name) {
        return ImmutableErrorType.builder().code(code).name(name).httpErrorCode(code.httpErrorCode).build();
    }

    public static enum Code {
        UNAUTHORIZED(401),
        PERMISSION_DENIED(403),
        INVALID_ARGUMENT(400),
        NOT_FOUND(404),
        CONFLICT(409),
        REQUEST_ENTITY_TOO_LARGE(413),
        FAILED_PRECONDITION(500),
        INTERNAL(500),
        TIMEOUT(500),
        CUSTOM_CLIENT(400),
        CUSTOM_SERVER(500);

        private final Integer httpErrorCode;

        private Code(Integer httpErrorCode) {
            this.httpErrorCode = httpErrorCode;
        }
    }
}

