/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.sep.util.zookeeper;

import com.ngdata.sep.util.zookeeper.ZooKeeperItf;
import com.ngdata.sep.util.zookeeper.ZooKeeperOperation;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class ZooKeeperImpl
implements ZooKeeperItf {
    protected ZooKeeper delegate;
    protected Set<Watcher> additionalDefaultWatchers = Collections.newSetFromMap(new IdentityHashMap());
    protected boolean connected = false;
    protected volatile boolean stop = false;
    protected final Object connectedMonitor = new Object();
    protected Thread zkEventThread;
    private Log log = LogFactory.getLog(this.getClass());

    protected ZooKeeperImpl() {
    }

    protected void setDelegate(ZooKeeper delegate) {
        this.delegate = delegate;
    }

    public ZooKeeperImpl(String connectString, int sessionTimeout) throws IOException {
        this.delegate = new ZooKeeper(connectString, sessionTimeout, (Watcher)new MyWatcher());
    }

    @Override
    public void addDefaultWatcher(Watcher watcher) {
        this.additionalDefaultWatchers.add(watcher);
    }

    @Override
    public void removeDefaultWatcher(Watcher watcher) {
        this.additionalDefaultWatchers.remove(watcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.stop = true;
        Object object = this.connectedMonitor;
        synchronized (object) {
            this.connectedMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForConnection() throws InterruptedException {
        if (this.isCurrentThreadEventThread()) {
            throw new RuntimeException("waitForConnection should not be called from within the ZooKeeper event thread.");
        }
        Object object = this.connectedMonitor;
        synchronized (object) {
            while (!this.connected && !this.stop) {
                this.connectedMonitor.wait();
            }
        }
        if (this.stop) {
            throw new InterruptedException("This ZooKeeper handle is shutting down.");
        }
    }

    @Override
    public boolean isCurrentThreadEventThread() {
        return this.zkEventThread != null && this.zkEventThread == Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setConnectedState(WatchedEvent event) {
        if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
            Object object = this.connectedMonitor;
            synchronized (object) {
                if (!this.connected) {
                    this.connected = true;
                    this.connectedMonitor.notifyAll();
                }
            }
        }
        if (event.getState() == Watcher.Event.KeeperState.Disconnected || event.getState() == Watcher.Event.KeeperState.Expired) {
            Object object = this.connectedMonitor;
            synchronized (object) {
                if (this.connected) {
                    this.connected = false;
                    this.connectedMonitor.notifyAll();
                }
            }
        }
    }

    @Override
    public <T> T retryOperation(ZooKeeperOperation<T> operation) throws InterruptedException, KeeperException {
        if (this.isCurrentThreadEventThread()) {
            throw new RuntimeException("retryOperation should not be called from within the ZooKeeper event thread.");
        }
        int tryCount = 0;
        while (true) {
            ++tryCount;
            try {
                return operation.execute();
            }
            catch (KeeperException.ConnectionLossException connectionLossException) {
                if (tryCount > 3) {
                    this.log.warn((Object)("ZooKeeper operation attempt " + tryCount + " failed due to connection loss."));
                }
                this.waitForConnection();
                continue;
            }
            break;
        }
    }

    @Override
    public long getSessionId() {
        return this.delegate.getSessionId();
    }

    @Override
    public byte[] getSessionPasswd() {
        return this.delegate.getSessionPasswd();
    }

    @Override
    public int getSessionTimeout() {
        return this.delegate.getSessionTimeout();
    }

    @Override
    public void addAuthInfo(String scheme, byte[] auth) {
        this.delegate.addAuthInfo(scheme, auth);
    }

    @Override
    public void register(Watcher watcher) {
        this.delegate.register(watcher);
    }

    @Override
    public void close() {
        try {
            this.delegate.close();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws KeeperException, InterruptedException {
        return this.delegate.create(path, data, acl, createMode);
    }

    @Override
    public void create(String path, byte[] data, List<ACL> acl, CreateMode createMode, AsyncCallback.StringCallback cb, Object ctx) {
        this.delegate.create(path, data, acl, createMode, cb, ctx);
    }

    @Override
    public void delete(String path, int version) throws InterruptedException, KeeperException {
        this.delegate.delete(path, version);
    }

    @Override
    public void delete(String path, int version, AsyncCallback.VoidCallback cb, Object ctx) {
        this.delegate.delete(path, version, cb, ctx);
    }

    @Override
    public Stat exists(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this.delegate.exists(path, watcher);
    }

    @Override
    public Stat exists(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.delegate.exists(path, watch);
    }

    @Override
    public void exists(String path, Watcher watcher, AsyncCallback.StatCallback cb, Object ctx) {
        this.delegate.exists(path, watcher, cb, ctx);
    }

    @Override
    public void exists(String path, boolean watch, AsyncCallback.StatCallback cb, Object ctx) {
        this.delegate.exists(path, watch, cb, ctx);
    }

    @Override
    public byte[] getData(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        return this.delegate.getData(path, watcher, stat);
    }

    @Override
    public byte[] getData(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        return this.delegate.getData(path, watch, stat);
    }

    @Override
    public void getData(String path, Watcher watcher, AsyncCallback.DataCallback cb, Object ctx) {
        this.delegate.getData(path, watcher, cb, ctx);
    }

    @Override
    public void getData(String path, boolean watch, AsyncCallback.DataCallback cb, Object ctx) {
        this.delegate.getData(path, watch, cb, ctx);
    }

    @Override
    public Stat setData(String path, byte[] data, int version) throws KeeperException, InterruptedException {
        return this.delegate.setData(path, data, version);
    }

    @Override
    public void setData(String path, byte[] data, int version, AsyncCallback.StatCallback cb, Object ctx) {
        this.delegate.setData(path, data, version, cb, ctx);
    }

    @Override
    public List<ACL> getACL(String path, Stat stat) throws KeeperException, InterruptedException {
        return this.delegate.getACL(path, stat);
    }

    @Override
    public void getACL(String path, Stat stat, AsyncCallback.ACLCallback cb, Object ctx) {
        this.delegate.getACL(path, stat, cb, ctx);
    }

    @Override
    public Stat setACL(String path, List<ACL> acl, int version) throws KeeperException, InterruptedException {
        return this.delegate.setACL(path, acl, version);
    }

    @Override
    public void setACL(String path, List<ACL> acl, int version, AsyncCallback.StatCallback cb, Object ctx) {
        this.delegate.setACL(path, acl, version, cb, ctx);
    }

    @Override
    public List<String> getChildren(String path, Watcher watcher) throws KeeperException, InterruptedException {
        return this.delegate.getChildren(path, watcher);
    }

    @Override
    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        return this.delegate.getChildren(path, watch);
    }

    @Override
    public void getChildren(String path, Watcher watcher, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.delegate.getChildren(path, watcher, cb, ctx);
    }

    @Override
    public void getChildren(String path, boolean watch, AsyncCallback.ChildrenCallback cb, Object ctx) {
        this.delegate.getChildren(path, watch, cb, ctx);
    }

    @Override
    public List<String> getChildren(String path, Watcher watcher, Stat stat) throws KeeperException, InterruptedException {
        return this.delegate.getChildren(path, watcher, stat);
    }

    @Override
    public List<String> getChildren(String path, boolean watch, Stat stat) throws KeeperException, InterruptedException {
        return this.delegate.getChildren(path, watch, stat);
    }

    @Override
    public void getChildren(String path, Watcher watcher, AsyncCallback.Children2Callback cb, Object ctx) {
        this.delegate.getChildren(path, watcher, cb, ctx);
    }

    @Override
    public void getChildren(String path, boolean watch, AsyncCallback.Children2Callback cb, Object ctx) {
        this.delegate.getChildren(path, watch, cb, ctx);
    }

    @Override
    public void sync(String path, AsyncCallback.VoidCallback cb, Object ctx) {
        this.delegate.sync(path, cb, ctx);
    }

    @Override
    public ZooKeeper.States getState() {
        return this.delegate.getState();
    }

    public class MyWatcher
    implements Watcher {
        private boolean printConnectMsg = false;

        public void process(WatchedEvent event) {
            ZooKeeperImpl.this.zkEventThread = Thread.currentThread();
            if (event.getState() == Watcher.Event.KeeperState.Disconnected) {
                System.err.println("ZooKeeper disconnected at " + new Date());
                this.printConnectMsg = true;
            } else if (event.getState() == Watcher.Event.KeeperState.Expired) {
                System.err.println("ZooKeeper session expired at " + new Date());
                this.printConnectMsg = true;
            } else if (event.getState() == Watcher.Event.KeeperState.SyncConnected && this.printConnectMsg) {
                System.out.println("ZooKeeper connected at " + new Date());
            }
            ZooKeeperImpl.this.setConnectedState(event);
            for (Watcher watcher : ZooKeeperImpl.this.additionalDefaultWatchers) {
                watcher.process(event);
            }
        }
    }
}

