/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.sep.util.zookeeper;

import com.ngdata.sep.util.zookeeper.ZkConnectException;
import com.ngdata.sep.util.zookeeper.ZooKeeperImpl;
import com.ngdata.sep.util.zookeeper.ZooKeeperItf;
import com.ngdata.sep.util.zookeeper.ZooKeeperOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZkUtil {
    public static ZooKeeperItf connect(String connectString, int sessionTimeout) throws ZkConnectException {
        ZooKeeperImpl zooKeeper;
        try {
            zooKeeper = new ZooKeeperImpl(connectString, sessionTimeout);
        }
        catch (IOException e) {
            throw new ZkConnectException("Failed to connect with Zookeeper @ '" + connectString + "'", e);
        }
        long waitUntil = System.currentTimeMillis() + (long)sessionTimeout;
        boolean connected = ZooKeeper.States.CONNECTED.equals((Object)zooKeeper.getState());
        while (!connected && waitUntil > System.currentTimeMillis()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                connected = ZooKeeper.States.CONNECTED.equals((Object)zooKeeper.getState());
                break;
            }
            connected = ZooKeeper.States.CONNECTED.equals((Object)zooKeeper.getState());
        }
        if (!connected) {
            System.out.println("Failed to connect to Zookeeper within timeout: Dumping stack: ");
            Thread.dumpStack();
            zooKeeper.close();
            throw new ZkConnectException("Failed to connect with Zookeeper @ '" + connectString + "' within timeout " + sessionTimeout);
        }
        return zooKeeper;
    }

    public static void createPath(ZooKeeperItf zk, String path) throws InterruptedException, KeeperException {
        ZkUtil.createPath(zk, path, null);
    }

    public static void createPath(final ZooKeeperItf zk, final String path, final byte[] data) throws InterruptedException, KeeperException {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path should start with a slash.");
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("Path should not end on a slash.");
        }
        String[] parts = path.substring(1).split("/");
        final StringBuilder subPath = new StringBuilder();
        boolean created = false;
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            subPath.append("/").append(part);
            final byte[] newData = (byte[])(i == parts.length - 1 ? data : null);
            created = zk.retryOperation(new ZooKeeperOperation<Boolean>(){

                @Override
                public Boolean execute() throws KeeperException, InterruptedException {
                    if (zk.exists(subPath.toString(), false) == null) {
                        try {
                            zk.create(subPath.toString(), newData, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                            return true;
                        }
                        catch (KeeperException.NodeExistsException e) {
                            return false;
                        }
                    }
                    return false;
                }
            });
        }
        if (!created) {
            zk.retryOperation(new ZooKeeperOperation<Boolean>(){

                @Override
                public Boolean execute() throws KeeperException, InterruptedException {
                    byte[] currentData = zk.getData(path, false, new Stat());
                    if (!Arrays.equals(currentData, data)) {
                        zk.setData(path, data, -1);
                    }
                    return null;
                }
            });
        }
    }

    public static void update(final ZooKeeperItf zk, final String path, final byte[] data, final int version) throws InterruptedException, KeeperException {
        zk.retryOperation(new ZooKeeperOperation<Boolean>(){

            @Override
            public Boolean execute() throws KeeperException, InterruptedException {
                zk.setData(path, data, version);
                return null;
            }
        });
    }

    public static void deleteNode(final ZooKeeperItf zk, final String path) throws InterruptedException, KeeperException {
        zk.retryOperation(new ZooKeeperOperation<Boolean>(){

            @Override
            public Boolean execute() throws KeeperException, InterruptedException {
                Stat stat = zk.exists(path, false);
                if (stat != null) {
                    try {
                        zk.delete(path, stat.getVersion());
                    }
                    catch (KeeperException.NoNodeException noNodeException) {
                        // empty catch block
                    }
                }
                return true;
            }
        });
    }

    public static byte[] getData(final ZooKeeperItf zk, final String path, final Watcher watcher, final Stat stat) throws InterruptedException, KeeperException {
        final ArrayList data = new ArrayList(1);
        zk.retryOperation(new ZooKeeperOperation<Boolean>(){

            @Override
            public Boolean execute() throws KeeperException, InterruptedException {
                data.add(zk.getData(path, watcher, stat));
                return null;
            }
        });
        return (byte[])data.get(0);
    }
}

