/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.sep.util.concurrent;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WaitPolicy
implements RejectedExecutionHandler {
    private final long _time;
    private final TimeUnit _timeUnit;

    public WaitPolicy() {
        this(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    public WaitPolicy(long time, TimeUnit timeUnit) {
        this._time = time < 0L ? Long.MAX_VALUE : time;
        this._timeUnit = timeUnit;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        try {
            if (e.isShutdown() || !e.getQueue().offer(r, this._time, this._timeUnit)) {
                throw new RejectedExecutionException();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RejectedExecutionException(ie);
        }
    }
}

