/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.sep.impl;

import com.ngdata.sep.SepModel;
import com.ngdata.sep.util.io.Closer;
import com.ngdata.sep.util.zookeeper.ZkUtil;
import com.ngdata.sep.util.zookeeper.ZooKeeperItf;
import java.io.Closeable;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.KeeperException;

public class SepModelImpl
implements SepModel {
    public static final char INTERNAL_HYPHEN_REPLACEMENT = '\u1400';
    private final ZooKeeperItf zk;
    private final Configuration hbaseConf;
    private final String baseZkPath;
    private final String zkQuorumString;
    private final int zkClientPort;
    private Log log = LogFactory.getLog(this.getClass());

    public SepModelImpl(ZooKeeperItf zk, Configuration hbaseConf) {
        this.zkQuorumString = hbaseConf.get("hbase.zookeeper.quorum");
        if (this.zkQuorumString == null) {
            throw new IllegalStateException("hbase.zookeeper.quorum not supplied in configuration");
        }
        if (this.zkQuorumString.contains(":")) {
            throw new IllegalStateException("hbase.zookeeper.quorum should not include port number, got " + this.zkQuorumString);
        }
        try {
            this.zkClientPort = Integer.parseInt(hbaseConf.get("hbase.zookeeper.property.clientPort"));
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("Non-numeric zookeeper client port", e);
        }
        this.zk = zk;
        this.hbaseConf = hbaseConf;
        this.baseZkPath = hbaseConf.get("hbasesep.zookeeper.znode.parent", "/ngdata/sep/hbase-slave");
    }

    public void addSubscription(String name) throws InterruptedException, KeeperException, IOException {
        if (!this.addSubscriptionSilent(name)) {
            throw new IllegalStateException("There is already a subscription for name '" + name + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubscriptionSilent(String name) throws InterruptedException, KeeperException, IOException {
        ReplicationAdmin replicationAdmin = new ReplicationAdmin(this.hbaseConf);
        try {
            String internalName = SepModelImpl.toInternalSubscriptionName(name);
            if (replicationAdmin.listPeerConfigs().containsKey(internalName)) {
                boolean bl = false;
                return bl;
            }
            String basePath = this.baseZkPath + "/" + internalName;
            UUID uuid = UUID.nameUUIDFromBytes(Bytes.toBytes((String)internalName));
            ZkUtil.createPath(this.zk, basePath + "/hbaseid", Bytes.toBytes((String)uuid.toString()));
            ZkUtil.createPath(this.zk, basePath + "/rs");
            try {
                ReplicationPeerConfig peerConfig = new ReplicationPeerConfig();
                peerConfig.setClusterKey(this.zkQuorumString + ":" + this.zkClientPort + ":" + basePath);
                replicationAdmin.addPeer(internalName, peerConfig);
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().equals("Cannot add existing peer")) {
                    boolean bl = false;
                    Closer.close((Closeable)replicationAdmin);
                    return bl;
                }
                throw e;
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    throw (InterruptedException)e;
                }
                if (e instanceof KeeperException) {
                    throw (KeeperException)e;
                }
                throw new IOException(e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Closer.close((Closeable)replicationAdmin);
        }
    }

    public void removeSubscription(String name) throws IOException {
        if (!this.removeSubscriptionSilent(name)) {
            throw new IllegalStateException("No subscription named '" + name + "'.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSubscriptionSilent(String name) throws IOException {
        ReplicationAdmin replicationAdmin = new ReplicationAdmin(this.hbaseConf);
        String internalName = SepModelImpl.toInternalSubscriptionName(name);
        if (!replicationAdmin.listPeerConfigs().containsKey(internalName)) {
            this.log.error((Object)("Requested to remove a subscription which does not exist, skipping silently: '" + name + "'"));
            boolean bl = false;
            return bl;
        }
        try {
            replicationAdmin.removePeer(internalName);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().equals("Cannot remove inexisting peer")) {
                boolean bl = false;
                Closer.close((Closeable)replicationAdmin);
                return bl;
            }
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        String basePath = this.baseZkPath + "/" + internalName;
        try {
            ZkUtil.deleteNode(this.zk, basePath + "/hbaseid");
            for (String child : this.zk.getChildren(basePath + "/rs", false)) {
                ZkUtil.deleteNode(this.zk, basePath + "/rs/" + child);
            }
            ZkUtil.deleteNode(this.zk, basePath + "/rs");
            ZkUtil.deleteNode(this.zk, basePath);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ie);
        }
        catch (KeeperException ke) {
            this.log.error((Object)("Cleanup in zookeeper failed on " + basePath), (Throwable)ke);
        }
        boolean bl = true;
        return bl;
        finally {
            Closer.close((Closeable)replicationAdmin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscription(String name) throws IOException {
        ReplicationAdmin replicationAdmin = new ReplicationAdmin(this.hbaseConf);
        try {
            String internalName = SepModelImpl.toInternalSubscriptionName(name);
            boolean bl = replicationAdmin.listPeerConfigs().containsKey(internalName);
            return bl;
        }
        finally {
            Closer.close((Closeable)replicationAdmin);
        }
    }

    static String toInternalSubscriptionName(String subscriptionName) {
        if (subscriptionName.indexOf(5120, 0) != -1) {
            throw new IllegalArgumentException("Subscription name cannot contain character \\U1400");
        }
        return subscriptionName.replace('-', '\u1400');
    }

    static String toExternalSubscriptionName(String subscriptionName) {
        return subscriptionName.replace('\u1400', '-');
    }
}

