/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.sep.impl;

import javax.management.ObjectName;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsDynamicMBeanBase;
import org.apache.hadoop.metrics.util.MetricsLongValue;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class SepMetrics
implements Updater {
    private final String recordName;
    private final MetricsRegistry metricsRegistry;
    private final MetricsRecord metricsRecord;
    private final MetricsContext context;
    private final SepMetricsMXBean mbean;
    private final MetricsTimeVaryingRate sepProcessingRate;
    private final MetricsLongValue lastTimestampInputProcessed;

    public SepMetrics(String recordName) {
        this.recordName = recordName;
        this.metricsRegistry = new MetricsRegistry();
        this.sepProcessingRate = new MetricsTimeVaryingRate("sepProcessed", this.metricsRegistry);
        this.lastTimestampInputProcessed = new MetricsLongValue("lastSepTimestamp", this.metricsRegistry);
        this.context = MetricsUtil.getContext((String)"repository");
        this.metricsRecord = MetricsUtil.createRecord((MetricsContext)this.context, (String)recordName);
        this.context.registerUpdater((Updater)this);
        this.mbean = new SepMetricsMXBean(this.metricsRegistry);
    }

    public void shutdown() {
        this.context.unregisterUpdater((Updater)this);
        this.mbean.shutdown();
    }

    public void reportFilteredSepOperation(long duration) {
        this.sepProcessingRate.inc(duration);
    }

    public void reportSepTimestamp(long writeTimestamp) {
        this.lastTimestampInputProcessed.set(writeTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpdates(MetricsContext unused) {
        SepMetrics sepMetrics = this;
        synchronized (sepMetrics) {
            for (MetricsBase m : this.metricsRegistry.getMetricsList()) {
                m.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }

    public class SepMetricsMXBean
    extends MetricsDynamicMBeanBase {
        private final ObjectName mbeanName;

        public SepMetricsMXBean(MetricsRegistry registry) {
            super(registry, "HBase Side-Effect Processor Metrics");
            this.mbeanName = MBeanUtil.registerMBean((String)"SEP", (String)SepMetrics.this.recordName, (Object)((Object)this));
        }

        public void shutdown() {
            if (this.mbeanName != null) {
                MBeanUtil.unregisterMBean((ObjectName)this.mbeanName);
            }
        }
    }
}

