/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.sep.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.ngdata.sep.EventListener;
import com.ngdata.sep.SepEvent;
import com.ngdata.sep.impl.SepMetrics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SepEventExecutor {
    private Log log = LogFactory.getLog(this.getClass());
    private EventListener eventListener;
    private int numThreads;
    private int batchSize;
    private SepMetrics sepMetrics;
    private List<ThreadPoolExecutor> executors;
    private Multimap<Integer, SepEvent> eventBuffers;
    private List<Future<?>> futures;
    private HashFunction hashFunction = Hashing.murmur3_32();
    private boolean stopped = false;

    public SepEventExecutor(EventListener eventListener, List<ThreadPoolExecutor> executors, int batchSize, SepMetrics sepMetrics) {
        this.eventListener = eventListener;
        this.executors = executors;
        this.numThreads = executors.size();
        this.batchSize = batchSize;
        this.sepMetrics = sepMetrics;
        this.eventBuffers = ArrayListMultimap.create((int)this.numThreads, (int)batchSize);
        this.futures = Lists.newArrayList();
    }

    public void scheduleSepEvent(SepEvent sepEvent) {
        if (this.stopped) {
            throw new IllegalStateException("This executor is stopped");
        }
        int partition = (this.hashFunction.hashBytes(sepEvent.getRow()).asInt() & Integer.MAX_VALUE) % this.numThreads;
        List eventBuffer = (List)this.eventBuffers.get((Object)partition);
        eventBuffer.add(sepEvent);
        if (eventBuffer.size() == this.batchSize) {
            this.scheduleEventBatch(partition, Lists.newArrayList((Iterable)eventBuffer));
            this.eventBuffers.removeAll((Object)partition);
        }
    }

    private void scheduleEventBatch(int partition, final List<SepEvent> events) {
        Future<?> future = this.executors.get(partition).submit(new Runnable(){

            @Override
            public void run() {
                try {
                    long before = System.currentTimeMillis();
                    SepEventExecutor.this.log.debug((Object)"Delivering message to listener");
                    SepEventExecutor.this.eventListener.processEvents(events);
                    SepEventExecutor.this.sepMetrics.reportFilteredSepOperation(System.currentTimeMillis() - before);
                }
                catch (RuntimeException e) {
                    SepEventExecutor.this.log.error((Object)"Error while processing event", (Throwable)e);
                    throw e;
                }
            }
        });
        this.futures.add(future);
    }

    public List<Future<?>> flush() {
        Iterator iterator = this.eventBuffers.keySet().iterator();
        while (iterator.hasNext()) {
            int partition = (Integer)iterator.next();
            List buffer = (List)this.eventBuffers.get((Object)partition);
            if (buffer.isEmpty()) continue;
            this.scheduleEventBatch(partition, Lists.newArrayList((Iterable)buffer));
        }
        this.eventBuffers.clear();
        ArrayList flushedFutures = Lists.newArrayList(this.futures);
        return flushedFutures;
    }
}

