/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.sep.impl;

import com.google.common.base.Preconditions;
import com.ngdata.sep.PayloadExtractor;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;

public class BasePayloadExtractor
implements PayloadExtractor {
    private final byte[] tableName;
    private final byte[] columnFamily;
    private final byte[] columnQualifier;

    public BasePayloadExtractor(byte[] tableName, byte[] columnFamily, byte[] columnQualifier) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName cannot be null");
        Preconditions.checkNotNull((Object)columnFamily, (Object)"columnFamily cannot be null");
        Preconditions.checkNotNull((Object)columnQualifier, (Object)"columnQualifier cannot be null");
        this.tableName = tableName;
        this.columnFamily = columnFamily;
        this.columnQualifier = columnQualifier;
    }

    public byte[] extractPayload(byte[] tableName, KeyValue keyValue) {
        if (Bytes.equals((byte[])this.tableName, (byte[])tableName) && CellUtil.matchingColumn((Cell)keyValue, (byte[])this.columnFamily, (byte[])this.columnQualifier)) {
            return CellUtil.cloneValue((Cell)keyValue);
        }
        return null;
    }
}

