/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.hbaseindexer.util.zookeeper;

import com.ngdata.hbaseindexer.util.zookeeper.ZkLockException;
import com.ngdata.sep.util.zookeeper.ZooKeeperItf;
import com.ngdata.sep.util.zookeeper.ZooKeeperOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class ZkLock {
    private ZkLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String lock(final ZooKeeperItf zk, final String lockPath) throws ZkLockException {
        if (zk.isCurrentThreadEventThread()) {
            throw new RuntimeException("ZkLock should not be used from within the ZooKeeper event thread.");
        }
        try {
            final long threadId = Thread.currentThread().getId();
            zk.retryOperation((ZooKeeperOperation)new ZooKeeperOperation<String>(){

                public String execute() throws KeeperException, InterruptedException {
                    return zk.create(lockPath + "/lock-" + threadId + "-", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
                }
            });
            while (true) {
                Object condition;
                MyWatcher watcher;
                List<ZkLockNode> children = ZkLock.parseChildren((List)zk.retryOperation((ZooKeeperOperation)new ZooKeeperOperation<List<String>>(){

                    public List<String> execute() throws KeeperException, InterruptedException {
                        return zk.getChildren(lockPath, null);
                    }
                }));
                ZkLockNode myLockNode = null;
                String myLockName = null;
                String myLockPath = null;
                for (ZkLockNode child : children) {
                    String childPath;
                    Stat stat;
                    if (child.getThreadId() != threadId || (stat = (Stat)zk.retryOperation((ZooKeeperOperation)new ZooKeeperOperation<Stat>(childPath = lockPath + "/" + child.getName()){
                        final /* synthetic */ String val$childPath;
                        {
                            this.val$childPath = string;
                        }

                        public Stat execute() throws KeeperException, InterruptedException {
                            return zk.exists(this.val$childPath, false);
                        }
                    })) == null || stat.getEphemeralOwner() != zk.getSessionId()) continue;
                    if (myLockName != null) {
                        zk.retryOperation((ZooKeeperOperation)new ZooKeeperOperation<Object>(){

                            public Object execute() throws KeeperException, InterruptedException {
                                try {
                                    zk.delete(childPath, -1);
                                }
                                catch (KeeperException.NoNodeException noNodeException) {
                                    // empty catch block
                                }
                                return null;
                            }
                        });
                        continue;
                    }
                    myLockNode = child;
                    myLockName = child.getName();
                    myLockPath = childPath;
                }
                if (myLockName == null) {
                    throw new ZkLockException("Unexpected problem: did not find our lock node.");
                }
                TreeSet<ZkLockNode> sortedChildren = new TreeSet<ZkLockNode>(children);
                SortedSet<Object> lowerThanMe = sortedChildren.headSet(myLockNode);
                if (lowerThanMe.isEmpty()) {
                    return myLockPath;
                }
                final String pathToWatch = lockPath + "/" + ((ZkLockNode)lowerThanMe.last()).name;
                Stat stat = (Stat)zk.retryOperation((ZooKeeperOperation)new ZooKeeperOperation<Stat>(watcher = new MyWatcher(pathToWatch, condition = new Object())){
                    final /* synthetic */ MyWatcher val$watcher;
                    {
                        this.val$watcher = myWatcher;
                    }

                    public Stat execute() throws KeeperException, InterruptedException {
                        return zk.exists(pathToWatch, (Watcher)this.val$watcher);
                    }
                });
                if (stat == null) {
                    LogFactory.getLog(ZkLock.class).warn((Object)("Next lower lock node does not exist: " + pathToWatch));
                    continue;
                }
                Object object = condition;
                synchronized (object) {
                    while (!watcher.gotNotified) {
                        condition.wait();
                    }
                }
            }
        }
        catch (Throwable t) {
            throw new ZkLockException("Error obtaining lock, path: " + lockPath, t);
        }
    }

    public static void unlock(ZooKeeperItf zk, String lockId) throws ZkLockException {
        ZkLock.unlock(zk, lockId, false);
    }

    public static void unlock(final ZooKeeperItf zk, final String lockId, boolean ignoreMissing) throws ZkLockException {
        if (zk.isCurrentThreadEventThread()) {
            throw new RuntimeException("ZkLock should not be used from within the ZooKeeper event thread.");
        }
        try {
            zk.retryOperation((ZooKeeperOperation)new ZooKeeperOperation<Object>(){

                public Object execute() throws KeeperException, InterruptedException {
                    zk.delete(lockId, -1);
                    return null;
                }
            });
        }
        catch (KeeperException.NoNodeException e) {
            if (!ignoreMissing) {
                throw new ZkLockException("Error releasing lock: the lock does not exist. Path: " + lockId, e);
            }
        }
        catch (Throwable t) {
            throw new ZkLockException("Error releasing lock, path: " + lockId, t);
        }
    }

    public static boolean ownsLock(final ZooKeeperItf zk, String lockId) throws ZkLockException {
        if (zk.isCurrentThreadEventThread()) {
            throw new RuntimeException("ZkLock should not be used from within the ZooKeeper event thread.");
        }
        try {
            int lastSlashPos = lockId.lastIndexOf(47);
            final String lockPath = lockId.substring(0, lastSlashPos);
            String lockName = lockId.substring(lastSlashPos + 1);
            List children = (List)zk.retryOperation((ZooKeeperOperation)new ZooKeeperOperation<List<String>>(){

                public List<String> execute() throws KeeperException, InterruptedException {
                    return zk.getChildren(lockPath, null);
                }
            });
            if (children.isEmpty()) {
                return false;
            }
            TreeSet sortedChildren = new TreeSet(children);
            return ((String)sortedChildren.first()).equals(lockName);
        }
        catch (Throwable t) {
            throw new ZkLockException("Error checking lock, path: " + lockId, t);
        }
    }

    private static List<ZkLockNode> parseChildren(List<String> children) {
        ArrayList<ZkLockNode> result = new ArrayList<ZkLockNode>(children.size());
        for (String child : children) {
            result.add(new ZkLockNode(child));
        }
        return result;
    }

    private static class ZkLockNode
    implements Comparable<ZkLockNode> {
        private long threadId;
        private int seqNr;
        private String name;

        public ZkLockNode(String name) {
            this.name = name;
            int dash1Pos = name.indexOf(45);
            int dash2Pos = name.indexOf(45, dash1Pos + 1);
            this.threadId = Long.parseLong(name.substring(dash1Pos + 1, dash2Pos));
            this.seqNr = Integer.parseInt(name.substring(dash2Pos + 1));
        }

        public long getThreadId() {
            return this.threadId;
        }

        public int getSeqNr() {
            return this.seqNr;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(ZkLockNode o) {
            return this.seqNr - o.seqNr;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ZkLockNode other = (ZkLockNode)obj;
            return other.threadId == this.threadId && other.seqNr == this.seqNr;
        }

        public int hashCode() {
            int result = (int)(this.threadId ^ this.threadId >>> 32);
            result = 31 * result + this.seqNr;
            return result;
        }
    }

    private static class MyWatcher
    implements Watcher {
        private String path;
        private final Object condition;
        private volatile boolean gotNotified;

        public MyWatcher(String path, Object condition) {
            this.path = path;
            this.condition = condition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (this.path.equals(event.getPath())) {
                Object object = this.condition;
                synchronized (object) {
                    this.gotNotified = true;
                    this.condition.notifyAll();
                }
            }
        }
    }
}

