/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.hbaseindexer.util.zookeeper;

import com.ngdata.sep.util.zookeeper.ZooKeeperImpl;
import java.io.IOException;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class StateWatchingZooKeeper
extends ZooKeeperImpl {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private int requestedSessionTimeout;
    private int sessionTimeout;
    private volatile boolean ready;
    private volatile boolean stopping;
    private volatile boolean connected;
    private boolean firstConnect = true;
    private Thread stateWatcherThread;
    private Runnable endProcessHook;

    public StateWatchingZooKeeper(String connectString, int sessionTimeout) throws IOException {
        this(connectString, sessionTimeout, sessionTimeout);
    }

    public StateWatchingZooKeeper(String connectString, int sessionTimeout, int startupTimeOut) throws IOException {
        this.requestedSessionTimeout = sessionTimeout;
        this.sessionTimeout = sessionTimeout;
        ZooKeeper zk = new ZooKeeper(connectString, sessionTimeout, (Watcher)new MyWatcher());
        this.setDelegate(zk);
        this.ready = true;
        long waitUntil = System.currentTimeMillis() + (long)startupTimeOut;
        int count = 0;
        while (zk.getState() != ZooKeeper.States.CONNECTED && waitUntil > System.currentTimeMillis()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (++count != 30) continue;
            this.log.info((Object)"Waiting for ZooKeeper connection to be established");
            count = 0;
        }
        if (zk.getState() != ZooKeeper.States.CONNECTED) {
            this.stopping = true;
            try {
                zk.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new IOException("Failed to connect with Zookeeper within timeout " + startupTimeOut + ", connection string: " + connectString);
        }
        this.log.info((Object)("ZooKeeper session ID is 0x" + Long.toHexString(zk.getSessionId())));
    }

    @PreDestroy
    public void shutdown() {
        super.shutdown();
        this.stopping = true;
        if (this.stateWatcherThread != null) {
            this.stateWatcherThread.interrupt();
        }
        this.close();
    }

    public void setEndProcessHook(Runnable endProcessHook) {
        this.endProcessHook = endProcessHook;
    }

    private void endProcess(String message) {
        if (this.stopping) {
            return;
        }
        if (this.endProcessHook != null) {
            this.endProcessHook.run();
        }
        super.shutdown();
        this.log.error((Object)message);
        System.err.println(message);
        System.exit(1);
    }

    private class StateWatcher
    implements Runnable {
        private long startNotConnected;

        private StateWatcher() {
        }

        @Override
        public void run() {
            this.startNotConnected = System.currentTimeMillis();
            while (!StateWatchingZooKeeper.this.connected) {
                int margin = StateWatchingZooKeeper.this.sessionTimeout * 2;
                if (this.startNotConnected + (long)margin < System.currentTimeMillis()) {
                    StateWatchingZooKeeper.this.endProcess("ZooKeeper connection lost for longer than " + margin + " ms. Session will already be expired by server so shutting down.");
                    return;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            return;
        }
    }

    private class MyWatcher
    implements Watcher {
        private MyWatcher() {
        }

        public void process(WatchedEvent event) {
            if (StateWatchingZooKeeper.this.stopping) {
                return;
            }
            StateWatchingZooKeeper.this.zkEventThread = Thread.currentThread();
            try {
                if (event.getState() == Watcher.Event.KeeperState.Expired) {
                    StateWatchingZooKeeper.this.endProcess("ZooKeeper session expired, shutting down.");
                } else if (event.getState() == Watcher.Event.KeeperState.Disconnected) {
                    StateWatchingZooKeeper.this.log.warn((Object)"Disconnected from ZooKeeper");
                    StateWatchingZooKeeper.this.connected = false;
                    this.waitForZk();
                    if (StateWatchingZooKeeper.this.stateWatcherThread != null) {
                        StateWatchingZooKeeper.this.stateWatcherThread.interrupt();
                    }
                    StateWatchingZooKeeper.this.stateWatcherThread = new Thread((Runnable)new StateWatcher(), "HBaseIndexerZkStateWatcher");
                    StateWatchingZooKeeper.this.stateWatcherThread.start();
                } else if (event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    int negotiatedSessionTimeout;
                    if (StateWatchingZooKeeper.this.firstConnect) {
                        StateWatchingZooKeeper.this.firstConnect = false;
                    } else {
                        StateWatchingZooKeeper.this.log.warn((Object)"Connected to ZooKeeper");
                    }
                    StateWatchingZooKeeper.this.connected = true;
                    this.waitForZk();
                    if (StateWatchingZooKeeper.this.stateWatcherThread != null) {
                        StateWatchingZooKeeper.this.stateWatcherThread.interrupt();
                        StateWatchingZooKeeper.this.stateWatcherThread = null;
                    }
                    StateWatchingZooKeeper.this.sessionTimeout = (negotiatedSessionTimeout = StateWatchingZooKeeper.this.getSessionTimeout()) > 0 ? negotiatedSessionTimeout : StateWatchingZooKeeper.this.requestedSessionTimeout;
                    if (negotiatedSessionTimeout == 0) {
                        StateWatchingZooKeeper.this.log.info((Object)("The negotiated ZooKeeper session timeout is " + negotiatedSessionTimeout + ", whichindicates that the connection has been lost again."));
                    } else if (StateWatchingZooKeeper.this.sessionTimeout != StateWatchingZooKeeper.this.requestedSessionTimeout) {
                        StateWatchingZooKeeper.this.log.info((Object)("The negotiated ZooKeeper session timeout is different from the requested one. Requested: " + StateWatchingZooKeeper.this.requestedSessionTimeout + ", negotiated: " + StateWatchingZooKeeper.this.sessionTimeout));
                    }
                }
            }
            catch (InterruptedException e) {
                return;
            }
            StateWatchingZooKeeper.this.setConnectedState(event);
            for (Watcher watcher : StateWatchingZooKeeper.this.additionalDefaultWatchers) {
                watcher.process(event);
            }
        }

        private void waitForZk() throws InterruptedException {
            while (!StateWatchingZooKeeper.this.ready) {
                StateWatchingZooKeeper.this.log.debug((Object)"Still waiting for reference to ZooKeeper.");
                Thread.sleep(5L);
            }
        }
    }
}

