/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.hbaseindexer.util.zookeeper;

import com.ngdata.hbaseindexer.util.zookeeper.LeaderElectionCallback;
import com.ngdata.hbaseindexer.util.zookeeper.LeaderElectionSetupException;
import com.ngdata.sep.util.zookeeper.ZkUtil;
import com.ngdata.sep.util.zookeeper.ZooKeeperItf;
import com.ngdata.sep.util.zookeeper.ZooKeeperOperation;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class LeaderElection {
    private ZooKeeperItf zk;
    private String position;
    private String electionPath;
    private LeaderElectionCallback callback;
    private boolean elected = false;
    private ChildrenWatcher watcher = new ChildrenWatcher();
    private ConnectStateWatcher connectStateWatcher = new ConnectStateWatcher();
    private boolean stopped = false;
    private LeaderProvisioner leaderProvisioner = new LeaderProvisioner();
    private Log log = LogFactory.getLog(this.getClass());

    public LeaderElection(ZooKeeperItf zk, String position, String electionPath, LeaderElectionCallback callback) throws LeaderElectionSetupException, InterruptedException, KeeperException {
        this.zk = zk;
        this.position = position;
        this.electionPath = electionPath;
        this.callback = callback;
        this.proposeAsLeader();
        zk.addDefaultWatcher((Watcher)this.connectStateWatcher);
        this.leaderProvisioner.start();
    }

    public void stop() throws InterruptedException {
        this.stopped = true;
        this.zk.removeDefaultWatcher((Watcher)this.connectStateWatcher);
        this.leaderProvisioner.shutdown();
        if (this.leaderProvisioner.currentState == LeaderState.I_AM_LEADER) {
            try {
                this.callback.deactivateAsLeader();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable t) {
                this.log.error((Object)("Error stopping the leader for " + this.position), t);
            }
        }
    }

    private void proposeAsLeader() throws LeaderElectionSetupException, InterruptedException, KeeperException {
        ZkUtil.createPath((ZooKeeperItf)this.zk, (String)this.electionPath);
        try {
            this.zk.retryOperation((ZooKeeperOperation)new ZooKeeperOperation<String>(){

                public String execute() throws KeeperException, InterruptedException {
                    return LeaderElection.this.zk.create(LeaderElection.this.electionPath + "/n_", null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
                }
            });
        }
        catch (KeeperException e) {
            throw new LeaderElectionSetupException("Error creating leader election zookeeper node below " + this.electionPath, e);
        }
        this.watchLeaders();
    }

    private synchronized void watchLeaders() {
        try {
            List children = this.zk.getChildren(this.electionPath, (Watcher)this.watcher);
            Collections.sort(children);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Leaders changed for the position of " + this.position + ", they are now:"));
                for (String child : children) {
                    this.log.debug((Object)child);
                }
            }
            String leader = (String)children.get(0);
            Stat stat = this.zk.exists(this.electionPath + "/" + leader, false);
            if (stat.getEphemeralOwner() == this.zk.getSessionId() && !this.elected) {
                this.elected = true;
                this.log.info((Object)("Elected as leader for the position of " + this.position));
                this.leaderProvisioner.setRequiredState(LeaderState.I_AM_LEADER);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.log.error((Object)("Error getting children of path " + this.electionPath), (Throwable)e);
        }
        catch (KeeperException e) {
            this.log.error((Object)("Error getting children of path " + this.electionPath), (Throwable)e);
        }
    }

    private class LeaderProvisioner
    implements Runnable {
        private volatile LeaderState currentState = LeaderState.I_AM_NOT_LEADER;
        private volatile LeaderState requiredState = LeaderState.I_AM_NOT_LEADER;
        private final Object stateLock = new Object();
        private Thread thread;
        private volatile boolean stop;

        private LeaderProvisioner() {
        }

        public synchronized void shutdown() throws InterruptedException {
            if (this.thread == null || !this.thread.isAlive()) {
                return;
            }
            this.stop = true;
            this.thread.interrupt();
            this.thread.join();
            this.thread = null;
        }

        public synchronized void start() {
            this.stop = false;
            this.thread = new Thread((Runnable)this, "LeaderProvisioner for " + LeaderElection.this.position);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.interrupted() && !this.stop) {
                try {
                    if (this.currentState != this.requiredState) {
                        if (this.requiredState == LeaderState.I_AM_LEADER) {
                            LeaderElection.this.callback.activateAsLeader();
                            this.currentState = LeaderState.I_AM_LEADER;
                        } else if (this.requiredState == LeaderState.I_AM_NOT_LEADER) {
                            LeaderElection.this.callback.deactivateAsLeader();
                            this.currentState = LeaderState.I_AM_NOT_LEADER;
                        }
                    }
                    Object object = this.stateLock;
                    synchronized (object) {
                        if (this.currentState == this.requiredState && !this.stop) {
                            this.stateLock.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (Throwable t) {
                    LeaderElection.this.log.error((Object)("Error in leader provisioner for " + LeaderElection.this.position), t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRequiredState(LeaderState state) {
            Object object = this.stateLock;
            synchronized (object) {
                this.requiredState = state;
                this.stateLock.notifyAll();
            }
        }
    }

    public class ConnectStateWatcher
    implements Watcher {
        public void process(WatchedEvent event) {
            if (LeaderElection.this.stopped) {
                return;
            }
            if (event.getType() == Watcher.Event.EventType.None && (event.getState().equals((Object)Watcher.Event.KeeperState.Disconnected) || event.getState().equals((Object)Watcher.Event.KeeperState.Expired))) {
                if (LeaderElection.this.elected) {
                    LeaderElection.this.elected = false;
                    LeaderElection.this.log.info((Object)("No longer leader for the position of " + LeaderElection.this.position));
                    LeaderElection.this.leaderProvisioner.setRequiredState(LeaderState.I_AM_NOT_LEADER);
                }
            } else if (event.getType() == Watcher.Event.EventType.None && event.getState() == Watcher.Event.KeeperState.SyncConnected) {
                LeaderElection.this.watchLeaders();
            }
        }
    }

    public class ChildrenWatcher
    implements Watcher {
        public void process(WatchedEvent event) {
            if (LeaderElection.this.stopped) {
                return;
            }
            if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged && event.getPath().equals(LeaderElection.this.electionPath)) {
                LeaderElection.this.watchLeaders();
            }
        }
    }

    static enum LeaderState {
        I_AM_LEADER,
        I_AM_NOT_LEADER;

    }
}

