/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.hbaseindexer.util.solr;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.ngdata.sep.util.zookeeper.ZkUtil;
import com.ngdata.sep.util.zookeeper.ZooKeeperItf;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;

public class SolrTestingUtility {
    private final int solrPort;
    private JettySolrRunner jettySolrRunner;
    private File tmpDir;
    private File solrHomeDir;
    private int zkClientPort;
    private String zkConnectString;
    private Map<String, String> configProperties;

    public SolrTestingUtility(int zkClientPort, int solrPort) {
        this(zkClientPort, solrPort, (Map<String, String>)ImmutableMap.of());
    }

    public SolrTestingUtility(int zkClientPort, int solrPort, Map<String, String> configProperties) {
        this.zkClientPort = zkClientPort;
        this.zkConnectString = "localhost:" + zkClientPort + "/solr";
        this.solrPort = solrPort;
        this.configProperties = configProperties;
    }

    public void start() throws Exception {
        this.tmpDir = Files.createTempDir();
        this.solrHomeDir = new File(this.tmpDir, "home");
        if (!this.solrHomeDir.mkdir()) {
            throw new RuntimeException("Failed to create directory " + this.solrHomeDir.getAbsolutePath());
        }
        this.writeSolrXml();
        System.setProperty("solr.solr.home", this.solrHomeDir.getAbsolutePath());
        System.setProperty("zkHost", this.zkConnectString);
        System.setProperty("solr.port", Integer.toString(this.solrPort));
        for (Map.Entry<String, String> entry : this.configProperties.entrySet()) {
            System.setProperty(entry.getKey().toString(), entry.getValue());
        }
        this.jettySolrRunner = this.createServer();
        this.jettySolrRunner.start();
    }

    public File getSolrHomeDir() {
        return this.solrHomeDir;
    }

    public String getZkConnectString() {
        return this.zkConnectString;
    }

    private void writeSolrXml() throws FileNotFoundException {
        File solrXml = new File(this.solrHomeDir, "solr.xml");
        PrintWriter solrXmlWriter = new PrintWriter(solrXml);
        solrXmlWriter.println("<solr>");
        solrXmlWriter.println("  <solrcloud>");
        solrXmlWriter.println("    <str name=\"host\">localhost</str>");
        solrXmlWriter.println("    <int name=\"hostPort\">${solr.port}</int>");
        solrXmlWriter.println("    <str name=\"hostContext\">/solr</str>");
        solrXmlWriter.println("  </solrcloud>");
        solrXmlWriter.println("</solr>");
        solrXmlWriter.close();
    }

    private JettySolrRunner createServer() throws Exception {
        ZooKeeperItf zk = ZkUtil.connect((String)("localhost:" + this.zkClientPort), (int)10000);
        ZkUtil.createPath((ZooKeeperItf)zk, (String)"/solr");
        zk.close();
        return new JettySolrRunner(this.solrHomeDir.toString(), "/solr", this.solrPort);
    }

    public void stop() throws Exception {
        if (this.jettySolrRunner != null) {
            this.jettySolrRunner.stop();
        }
        if (this.tmpDir != null) {
            FileUtils.deleteDirectory((File)this.tmpDir);
        }
        System.getProperties().remove("solr.solr.home");
        System.getProperties().remove("zkHost");
        for (String configPropertyKey : this.configProperties.keySet()) {
            System.getProperties().remove(configPropertyKey);
        }
    }

    public void uploadConfig(String confName, byte[] schema, byte[] solrconf) throws IOException {
        File tmpConfDir = Files.createTempDir();
        Files.copy((InputSupplier)ByteStreams.newInputStreamSupplier((byte[])schema), (File)new File(tmpConfDir, "schema.xml"));
        Files.copy((InputSupplier)ByteStreams.newInputStreamSupplier((byte[])solrconf), (File)new File(tmpConfDir, "solrconfig.xml"));
        this.uploadConfig(confName, tmpConfDir);
        FileUtils.deleteDirectory((File)tmpConfDir);
    }

    public void uploadConfig(String confName, File confDir) throws IOException {
        SolrZkClient zkClient = new SolrZkClient(this.zkConnectString, 30000, 30000, new OnReconnect(){

            public void command() {
            }
        });
        new ZkConfigManager(zkClient).uploadConfigDir(confDir.toPath(), confName);
        zkClient.close();
    }

    public void createCore(String coreName, String collectionName, String configName, int numShards) throws IOException {
        this.createCore(coreName, collectionName, configName, numShards, null);
    }

    public void createCore(String coreName, String collectionName, String configName, int numShards, String dataDir) throws IOException {
        String url = "http://localhost:" + this.solrPort + "/solr/admin/cores?action=CREATE&name=" + coreName + "&collection=" + collectionName + "&configName=" + configName + "&numShards=" + numShards;
        if (dataDir != null) {
            url = url + "&dataDir=" + dataDir;
        }
        URL coreActionURL = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)coreActionURL.openConnection();
        conn.connect();
        int response = conn.getResponseCode();
        conn.disconnect();
        if (response != 200) {
            throw new RuntimeException("Request to " + url + ": expected status 200 but got: " + response + ": " + conn.getResponseMessage());
        }
    }

    public void createCollection(String collectionName, String configName, int numShards) throws IOException {
        for (int shardIndex = 0; shardIndex < numShards; ++shardIndex) {
            String coreName = String.format("%s_shard%d", collectionName, shardIndex + 1);
            this.createCore(coreName, collectionName, configName, numShards, coreName + "_data");
        }
    }
}

