/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.hbaseindexer.util.solr;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SolrConnectionParamUtil {
    private SolrConnectionParamUtil() {
    }

    public static List<String> getShards(Map<String, String> connectionParams) {
        TreeMap shardsByUserIndex = Maps.newTreeMap();
        for (Map.Entry<String, String> param : connectionParams.entrySet()) {
            if (!param.getKey().startsWith("solr.shard.")) continue;
            Integer index = Integer.valueOf(param.getKey().substring("solr.shard.".length()));
            shardsByUserIndex.put(index, param.getValue());
        }
        return Lists.newArrayList(shardsByUserIndex.values());
    }

    public static String getSolrMode(Map<String, String> connectionParameters) {
        return ((String)Optional.fromNullable((Object)connectionParameters.get("solr.mode")).or((Object)"cloud")).toLowerCase();
    }

    public static int getSolrMaxConnectionsPerRoute(Map<String, String> connectionParameters) {
        return Integer.parseInt((String)Optional.fromNullable((Object)connectionParameters.get("solr.conn.maxPerHost")).or((Object)"128"));
    }

    public static int getSolrMaxConnectionsTotal(Map<String, String> connectionParameters) {
        return Integer.parseInt((String)Optional.fromNullable((Object)connectionParameters.get("solr.conn.max")).or((Object)"32"));
    }
}

