/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.hbaseindexer.util.solr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class SolrConfigLoader
extends SolrResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ZooKeeper zk;
    private String configZkPath;

    public SolrConfigLoader(String collection, ZooKeeper zooKeeper) {
        super(Paths.get("solr", new String[0]));
        this.zk = zooKeeper;
        this.configZkPath = this.getCollectionConfigPath(collection);
    }

    private String getCollectionConfigPath(String collectionName) {
        try {
            byte[] data = this.zk.getData("/collections/" + collectionName, false, null);
            ObjectMapper objectMapper = new ObjectMapper();
            JsonParser jsonParser = objectMapper.getJsonFactory().createJsonParser(data);
            JsonNode collectionNode = objectMapper.readTree(jsonParser);
            return "/configs/" + collectionNode.get("configName").getValueAsText();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SolrConfig loadSolrConfig() throws ParserConfigurationException, IOException, SAXException {
        return new SolrConfig((SolrResourceLoader)this, "solrconfig.xml", null);
    }

    public InputStream openResource(String resource) throws IOException {
        InputStream is = null;
        String file = this.configZkPath + "/" + resource;
        try {
            if (this.zk.exists(file, false) != null) {
                byte[] bytes = this.zk.getData(this.configZkPath + "/" + resource, false, null);
                return new ByteArrayInputStream(bytes);
            }
        }
        catch (Exception e) {
            throw new IOException("Error opening " + file, e);
        }
        try {
            is = this.classLoader.getResourceAsStream(resource);
        }
        catch (Exception e) {
            throw new IOException("Error opening " + resource, e);
        }
        if (is == null) {
            throw new IOException("Can't find resource '" + resource + "' in classpath or '" + this.configZkPath + "', cwd=" + System.getProperty("user.dir"));
        }
        return is;
    }

    public String getConfigDir() {
        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "ZkSolrResourceLoader does not support getConfigDir() - likely, what you are trying to do is not supported in ZooKeeper mode");
    }

    public String[] listConfigDir() {
        List list;
        try {
            list = this.zk.getChildren(this.configZkPath, false, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        catch (KeeperException e) {
            log.error("", (Throwable)e);
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        return list.toArray(new String[0]);
    }
}

