/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.hbaseindexer.util;

import com.ngdata.hbaseindexer.VersionAnnotation;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionInfo {
    private static final Log LOG = LogFactory.getLog((String)VersionInfo.class.getName());
    private static Package myPackage = VersionAnnotation.class.getPackage();
    private static VersionAnnotation version = myPackage.getAnnotation(VersionAnnotation.class);

    static Package getPackage() {
        return myPackage;
    }

    public static String getVersion() {
        return version != null ? version.version() : "Unknown";
    }

    public static String getRevision() {
        return version != null ? version.revision() : "Unknown";
    }

    public static String getDate() {
        return version != null ? version.date() : "Unknown";
    }

    public static String getUser() {
        return version != null ? version.user() : "Unknown";
    }

    public static String getUrl() {
        return version != null ? version.url() : "Unknown";
    }

    static String[] versionReport() {
        return new String[]{"HBase Indexer " + VersionInfo.getVersion(), "Git " + VersionInfo.getUrl() + " hash " + VersionInfo.getRevision(), "Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate()};
    }

    public static void writeTo(PrintWriter out) {
        for (String line : VersionInfo.versionReport()) {
            out.println(line);
        }
    }

    public static void logVersion() {
        for (String line : VersionInfo.versionReport()) {
            LOG.info((Object)line);
        }
    }

    public static void main(String[] args) {
        VersionInfo.logVersion();
    }
}

