/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.hbaseindexer.util;

import java.util.regex.Pattern;

public class IndexerNameValidator {
    private static final Pattern INDEXER_NAME_REGEX = Pattern.compile("^\\w+$");

    public static void validate(String indexerName) {
        if (indexerName == null || "".equals(indexerName)) {
            throw new IllegalArgumentException("Indexer name may not be empty");
        }
        if (!INDEXER_NAME_REGEX.matcher(indexerName).matches()) {
            throw new IllegalArgumentException(String.format("Invalid indexer name '%s', must be alpha-numeric", indexerName));
        }
    }
}

