/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.hbaseindexer.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricPredicate;
import java.util.SortedMap;

public class IndexerMetricsUtil {
    public static final String METRIC_GROUP = "hbaseindexer";

    public static void shutdownMetrics(String indexerName) {
        SortedMap groupedMetrics = Metrics.defaultRegistry().groupedMetrics((MetricPredicate)new IndexerMetricPredicate(indexerName));
        for (SortedMap metricMap : groupedMetrics.values()) {
            for (MetricName metricName : metricMap.keySet()) {
                Metrics.defaultRegistry().removeMetric(metricName);
            }
        }
    }

    public static MetricName metricName(Class<?> producerClass, String metric, String indexerName) {
        return new MetricName(METRIC_GROUP, producerClass.getSimpleName(), metric, indexerName);
    }

    public static class IndexerMetricPredicate
    implements MetricPredicate {
        private String indexerName;

        public IndexerMetricPredicate() {
            this(null);
        }

        public IndexerMetricPredicate(String indexerName) {
            this.indexerName = indexerName;
        }

        public boolean matches(MetricName metricName, Metric metric) {
            if (this.indexerName == null) {
                return IndexerMetricsUtil.METRIC_GROUP.equals(metricName.getGroup());
            }
            return IndexerMetricsUtil.METRIC_GROUP.equals(metricName.getGroup()) && this.indexerName.equals(metricName.getScope());
        }
    }
}

