/*
 * Decompiled with CFR 0.152.
 */
package com.ngdata.hbaseindexer;

import com.ngdata.hbaseindexer.util.VersionInfo;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;

public class HBaseIndexerConfiguration {
    private HBaseIndexerConfiguration() {
    }

    public static Configuration create() {
        Configuration conf = new Configuration();
        return HBaseIndexerConfiguration.addHbaseIndexerResources(conf);
    }

    public static Configuration addHbaseIndexerResources(Configuration conf) {
        conf.addResource("hbase-default.xml");
        conf.addResource("hbase-site.xml");
        conf.addResource("hbase-indexer-default.xml");
        conf.addResource("hbase-indexer-site.xml");
        HBaseIndexerConfiguration.checkDefaultsVersion(conf);
        return conf;
    }

    public static int getSessionTimeout(Configuration conf) {
        return conf.getInt("hbaseindexer.zookeeper.session.timeout", 30000);
    }

    private static void checkDefaultsVersion(Configuration conf) {
        if (conf.getBoolean("hbaseindexer.defaults.for.version.skip", Boolean.FALSE.booleanValue())) {
            return;
        }
        String defaultsVersion = conf.get("hbaseindexer.defaults.for.version");
        String thisVersion = VersionInfo.getVersion();
        if (!thisVersion.equals(defaultsVersion)) {
            throw new RuntimeException("hbase-indexer-default.xml file seems to be for and old version of HBase Indexer (" + defaultsVersion + "), this version is " + thisVersion);
        }
    }

    public static void main(String[] args) throws Exception {
        HBaseIndexerConfiguration.create().writeXml((OutputStream)System.out);
    }
}

