/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.sql.split;

import com.klarna.hiverunner.sql.split.Consumer;
import com.klarna.hiverunner.sql.split.Context;
import com.klarna.hiverunner.sql.split.NewLineUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

class BaseContext
implements Context {
    private final StringTokenizer tokenizer;
    private final List<String> statements = new ArrayList<String>();
    private String statement = "";

    BaseContext(StringTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    @Override
    public void flush() {
        if (!this.statement.trim().isEmpty()) {
            this.statements.add(NewLineUtil.removeLeadingTrailingNewLines(this.statement));
        }
        this.statement = "";
    }

    @Override
    public String statement() {
        return this.statement;
    }

    @Override
    public StringTokenizer tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void append(String chars) {
        this.statement = this.statement + chars;
    }

    @Override
    public void appendWith(Consumer consumer) {
        this.append(consumer.consume(this));
    }

    public List<String> getStatements() {
        return this.statements;
    }
}

