/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.data;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.beanutils.converters.ByteArrayConverter;
import org.apache.commons.beanutils.converters.ByteConverter;
import org.apache.commons.beanutils.converters.DoubleConverter;
import org.apache.commons.beanutils.converters.FloatConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.beanutils.converters.LongConverter;
import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.beanutils.converters.SqlTimestampConverter;
import org.apache.commons.beanutils.converters.StringConverter;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public final class Converters {
    static final Map<PrimitiveTypeInfo, Class<?>> TYPES = ImmutableMap.builder().put((Object)TypeInfoFactory.stringTypeInfo, String.class).put((Object)TypeInfoFactory.booleanTypeInfo, Boolean.class).put((Object)TypeInfoFactory.byteTypeInfo, Byte.class).put((Object)TypeInfoFactory.shortTypeInfo, Short.class).put((Object)TypeInfoFactory.intTypeInfo, Integer.class).put((Object)TypeInfoFactory.longTypeInfo, Long.class).put((Object)TypeInfoFactory.floatTypeInfo, Float.class).put((Object)TypeInfoFactory.doubleTypeInfo, Double.class).put((Object)TypeInfoFactory.dateTypeInfo, Date.class).put((Object)TypeInfoFactory.timestampTypeInfo, Timestamp.class).put((Object)TypeInfoFactory.binaryTypeInfo, Byte[].class).build();
    private static final ConvertUtilsBean CONVERTER = new ConvertUtilsBean();

    private Converters() {
    }

    static Class<?> type(PrimitiveTypeInfo typeInfo) {
        Class<Object> type = TYPES.get(typeInfo);
        if (type == null) {
            type = typeInfo instanceof DecimalTypeInfo ? HiveDecimal.class : (typeInfo instanceof VarcharTypeInfo ? HiveVarchar.class : (typeInfo instanceof CharTypeInfo ? HiveChar.class : String.class));
        }
        return type;
    }

    public static Object convert(Object value, PrimitiveTypeInfo typeInfo) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return CONVERTER.convert((String)value, Converters.type(typeInfo));
        }
        return value;
    }

    static {
        CONVERTER.register((Converter)new StringConverter(), String.class);
        CONVERTER.register((Converter)new BooleanConverter(), Boolean.class);
        CONVERTER.register((Converter)new ByteConverter(), Byte.class);
        CONVERTER.register((Converter)new ShortConverter(), Short.class);
        CONVERTER.register((Converter)new IntegerConverter(), Integer.class);
        CONVERTER.register((Converter)new LongConverter(), Long.class);
        CONVERTER.register((Converter)new FloatConverter(), Float.class);
        CONVERTER.register((Converter)new DoubleConverter(), Double.class);
        CONVERTER.register((Converter)new SqlDateConverter(), Date.class);
        CONVERTER.register((Converter)new SqlTimestampConverter(), Timestamp.class);
        CONVERTER.register((Converter)new ByteArrayConverter(), Byte[].class);
        CONVERTER.register((Converter)new HiveDecimalConverter(), HiveDecimal.class);
        CONVERTER.register((Converter)new HiveVarcharConverter(), HiveVarchar.class);
        CONVERTER.register((Converter)new HiveCharConverter(), HiveChar.class);
    }

    private static class HiveCharConverter
    implements Converter {
        private HiveCharConverter() {
        }

        public Object convert(Class type, Object value) {
            return new HiveChar(value.toString(), -1);
        }
    }

    private static class HiveVarcharConverter
    implements Converter {
        private HiveVarcharConverter() {
        }

        public Object convert(Class type, Object value) {
            return new HiveVarchar(value.toString(), -1);
        }
    }

    private static class HiveDecimalConverter
    implements Converter {
        private HiveDecimalConverter() {
        }

        public Object convert(Class type, Object value) {
            try {
                return HiveDecimal.create((BigDecimal)new BigDecimal(value.toString()));
            }
            catch (NumberFormatException e) {
                throw new ConversionException((Throwable)e);
            }
        }
    }
}

