/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.klarna.hiverunner.HiveServerContext;
import com.klarna.hiverunner.builder.Statement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.ql.exec.tez.TezJobExecHelper;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.Service;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.server.HiveServer2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveServerContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HiveServerContainer.class);
    private CLIService client;
    private final HiveServerContext context;
    private SessionHandle sessionHandle;
    private HiveServer2 hiveServer2;
    private SessionState currentSessionState;

    public HiveServerContainer(HiveServerContext context) {
        this.context = context;
    }

    public CLIService getClient() {
        return this.client;
    }

    public void init(Map<String, String> testConfig, Map<String, String> hiveVars) {
        this.context.init();
        HiveConf hiveConf = this.context.getHiveConf();
        for (Map.Entry<String, String> property : testConfig.entrySet()) {
            hiveConf.set(property.getKey(), property.getValue());
        }
        try {
            SessionState sessionState;
            this.hiveServer2 = new HiveServer2();
            this.hiveServer2.init(hiveConf);
            for (Service service : this.hiveServer2.getServices()) {
                if (!(service instanceof CLIService)) continue;
                this.client = (CLIService)service;
            }
            Preconditions.checkNotNull((Object)this.client, (Object)"ClIService was not initialized by HiveServer2");
            this.sessionHandle = this.client.openSession("noUser", "noPassword", null);
            this.currentSessionState = sessionState = this.client.getSessionManager().getSession(this.sessionHandle).getSessionState();
            this.currentSessionState.setHiveVariables(hiveVars);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create HiveServer :" + e.getMessage(), e);
        }
        this.pingHiveServer();
    }

    public Path getBaseDir() {
        return this.context.getBaseDir();
    }

    public List<Object[]> executeStatement(Statement hiveql) {
        return this.executeStatement(hiveql.getSql());
    }

    public List<Object[]> executeStatement(String hiveql) {
        try {
            OperationHandle handle = this.client.executeStatement(this.sessionHandle, hiveql, new HashMap());
            ArrayList<Object[]> resultSet = new ArrayList<Object[]>();
            if (handle.hasResultSet()) {
                RowSet rowSet;
                while ((rowSet = this.client.fetchResults(handle)) != null && rowSet.numRows() > 0) {
                    for (Object[] row : rowSet) {
                        resultSet.add((Object[])row.clone());
                    }
                }
            }
            LOGGER.debug("ResultSet:\n" + Joiner.on((String)"\n").join(Iterables.transform(resultSet, (Function)new Function<Object[], String>(){

                @Nullable
                public String apply(@Nullable Object[] objects) {
                    return Joiner.on((String)", ").useForNull("null").join(objects);
                }
            })));
            return resultSet;
        }
        catch (HiveSQLException e) {
            throw new IllegalArgumentException("Failed to executeQuery Hive query " + hiveql + ": " + e.getMessage(), e);
        }
    }

    public void tearDown() {
        try {
            TezJobExecHelper.killRunningJobs();
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to kill tez session: " + e.getMessage() + ". Turn on log level debug for stacktrace");
            LOGGER.debug(e.getMessage(), e);
        }
        try {
            this.executeStatement("USE default");
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to reset to default schema: " + e.getMessage() + ". Turn on log level debug for stacktrace");
            LOGGER.debug(e.getMessage(), e);
        }
        try {
            this.client.closeSession(this.sessionHandle);
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to close client session: " + e.getMessage() + ". Turn on log level debug for stacktrace");
            LOGGER.debug(e.getMessage(), e);
        }
        try {
            this.hiveServer2.stop();
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to stop HiveServer2: " + e.getMessage() + ". Turn on log level debug for stacktrace");
            LOGGER.debug(e.getMessage(), e);
        }
        this.hiveServer2 = null;
        this.client = null;
        this.sessionHandle = null;
        LOGGER.info("Tore down HiveServer instance");
    }

    public String expandVariableSubstitutes(String expression) {
        return this.getVariableSubstitution().substitute(this.getHiveConf(), expression);
    }

    private void pingHiveServer() {
        this.executeStatement("SHOW TABLES");
    }

    public HiveConf getHiveConf() {
        return this.hiveServer2.getHiveConf();
    }

    public VariableSubstitution getVariableSubstitution() {
        SessionState.setCurrentSessionState((SessionState)this.currentSessionState);
        final SessionState ss = this.currentSessionState;
        return new VariableSubstitution(new HiveVariableSource(){

            public Map<String, String> getHiveVariable() {
                return ss.getHiveVariables();
            }
        });
    }
}

