/*
 * Decompiled with CFR 0.152.
 */
package com.keepersecurity.secretsManager.core;

import com.keepersecurity.secretsManager.core.CryptoUtils;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/keepersecurity/secretsManager/core/TotpCode;", "", "code", "", "timeLeft", "", "period", "(Ljava/lang/String;II)V", "getCode", "()Ljava/lang/String;", "getPeriod", "()I", "getTimeLeft", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "core"})
public final class TotpCode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String code;
    private final int timeLeft;
    private final int period;

    public TotpCode(@NotNull String code, int timeLeft, int period) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        this.code = code;
        this.timeLeft = timeLeft;
        this.period = period;
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    public final int getTimeLeft() {
        return this.timeLeft;
    }

    public final int getPeriod() {
        return this.period;
    }

    @NotNull
    public final String component1() {
        return this.code;
    }

    public final int component2() {
        return this.timeLeft;
    }

    public final int component3() {
        return this.period;
    }

    @NotNull
    public final TotpCode copy(@NotNull String code, int timeLeft, int period) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return new TotpCode(code, timeLeft, period);
    }

    public static /* synthetic */ TotpCode copy$default(TotpCode totpCode, String string, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = totpCode.code;
        }
        if ((n3 & 2) != 0) {
            n = totpCode.timeLeft;
        }
        if ((n3 & 4) != 0) {
            n2 = totpCode.period;
        }
        return totpCode.copy(string, n, n2);
    }

    @NotNull
    public String toString() {
        return "TotpCode(code=" + this.code + ", timeLeft=" + this.timeLeft + ", period=" + this.period + ')';
    }

    public int hashCode() {
        int result = this.code.hashCode();
        result = result * 31 + Integer.hashCode(this.timeLeft);
        result = result * 31 + Integer.hashCode(this.period);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TotpCode)) {
            return false;
        }
        TotpCode totpCode = (TotpCode)other;
        if (!Intrinsics.areEqual((Object)this.code, (Object)totpCode.code)) {
            return false;
        }
        if (this.timeLeft != totpCode.timeLeft) {
            return false;
        }
        return this.period == totpCode.period;
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final TotpCode uriToTotpCode(@NotNull String url, long unixTimeSeconds) {
        return Companion.uriToTotpCode(url, unixTimeSeconds);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final TotpCode uriToTotpCode(@NotNull String url) {
        return Companion.uriToTotpCode(url);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/keepersecurity/secretsManager/core/TotpCode$Companion;", "", "()V", "uriToTotpCode", "Lcom/keepersecurity/secretsManager/core/TotpCode;", "url", "", "unixTimeSeconds", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final TotpCode uriToTotpCode(@NotNull String url, long unixTimeSeconds) {
            int period;
            String protocol;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            String string = protocol = StringsKt.startsWith((String)url, (String)"otpauth://", (boolean)true) ? "otpauth" : "";
            if (!Intrinsics.areEqual((Object)protocol, (Object)"otpauth")) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder().append("http://");
            String string2 = url.substring(10);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            URL totpUrl = new URL(stringBuilder.append(string2).toString());
            Map queryPairs = new LinkedHashMap();
            String string3 = totpUrl.getQuery();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"totpUrl.query");
            String[] stringArray = new String[]{"&"};
            List pairs = StringsKt.split$default((CharSequence)string3, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            for (String pair : pairs) {
                int idx = StringsKt.indexOf$default((CharSequence)pair, (String)"=", (int)0, (boolean)false, (int)6, null);
                String string4 = pair.substring(0, idx);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String key = URLDecoder.decode(string4, "UTF-8");
                String string5 = pair.substring(idx + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                String value = URLDecoder.decode(string5, "UTF-8");
                CharSequence charSequence = value;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                queryPairs.put(key, value);
            }
            String string6 = queryPairs.getOrDefault("secret", "").toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String secret = string6;
            String string7 = queryPairs.getOrDefault("algorithm", "SHA1").toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            String algorithm = string7;
            Integer n = StringsKt.toIntOrNull((String)queryPairs.getOrDefault("digits", ""));
            int digits = n != null ? n : 6;
            Integer n2 = StringsKt.toIntOrNull((String)queryPairs.getOrDefault("period", ""));
            int n3 = period = n2 != null ? n2 : 30;
            if (digits == 0) {
                digits = 6;
            }
            if (period == 0) {
                period = 30;
            }
            if (((CharSequence)secret).length() == 0) {
                return null;
            }
            long tmBase = unixTimeSeconds != 0L ? unixTimeSeconds : System.currentTimeMillis() / 1000L;
            long tm = tmBase / (long)period;
            byte[] byArray = ByteBuffer.allocate(8).putLong(tm).array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"allocate(8).putLong(tm).array()");
            byte[] msg = byArray;
            byte[] secretBytes = CryptoUtils.access$base32ToBytes(secret);
            if (secretBytes.length == 0) {
                return null;
            }
            Mac hmac = null;
            switch (algorithm) {
                case "SHA1": {
                    hmac = Mac.getInstance("HmacSHA1");
                    break;
                }
                case "SHA256": {
                    hmac = Mac.getInstance("HmacSHA256");
                    break;
                }
                case "SHA512": {
                    hmac = Mac.getInstance("HmacSHA512");
                }
            }
            if (hmac == null) {
                return null;
            }
            byte[] digest = new byte[]{};
            try {
                SecretKeySpec spec = new SecretKeySpec(secretBytes, "RAW");
                hmac.init(spec);
                byte[] byArray2 = hmac.doFinal(msg);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"hmac.doFinal(msg)");
                digest = byArray2;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int offset = digest[digest.length - 1] & 0xF;
            byte[] byArray3 = digest;
            int n4 = offset + 4;
            byte[] codeBytes = ArraysKt.copyOfRange((byte[])byArray3, (int)offset, (int)n4);
            codeBytes[0] = (byte)(codeBytes[0] & 0x7F);
            int codeInt = ByteBuffer.wrap(codeBytes).getInt();
            String codeStr = StringsKt.padStart((String)String.valueOf(codeInt %= (int)Math.pow(10.0, digits)), (int)digits, (char)'0');
            int elapsed = (int)(tmBase % (long)period);
            int ttl = period - elapsed;
            return new TotpCode(codeStr, ttl, period);
        }

        public static /* synthetic */ TotpCode uriToTotpCode$default(Companion companion, String string, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = 0L;
            }
            return companion.uriToTotpCode(string, l);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final TotpCode uriToTotpCode(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return com.keepersecurity.secretsManager.core.TotpCode$Companion.uriToTotpCode$default(this, url, 0L, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

