/*
 * Decompiled with CFR 0.152.
 */
package com.keepersecurity.secretsManager.core;

import com.keepersecurity.secretsManager.core.AppData;
import com.keepersecurity.secretsManager.core.CompleteTransactionPayload;
import com.keepersecurity.secretsManager.core.CreatePayload;
import com.keepersecurity.secretsManager.core.CryptoUtils;
import com.keepersecurity.secretsManager.core.DeletePayload;
import com.keepersecurity.secretsManager.core.EncryptedPayload;
import com.keepersecurity.secretsManager.core.FileRef;
import com.keepersecurity.secretsManager.core.FileUploadPayload;
import com.keepersecurity.secretsManager.core.FileUploadPayloadAndFile;
import com.keepersecurity.secretsManager.core.GetPayload;
import com.keepersecurity.secretsManager.core.KeeperError;
import com.keepersecurity.secretsManager.core.KeeperFile;
import com.keepersecurity.secretsManager.core.KeeperFileData;
import com.keepersecurity.secretsManager.core.KeeperFileUpload;
import com.keepersecurity.secretsManager.core.KeeperHttpResponse;
import com.keepersecurity.secretsManager.core.KeeperRecord;
import com.keepersecurity.secretsManager.core.KeeperRecordData;
import com.keepersecurity.secretsManager.core.KeeperRecordField;
import com.keepersecurity.secretsManager.core.KeeperSecrets;
import com.keepersecurity.secretsManager.core.KeyValueStorage;
import com.keepersecurity.secretsManager.core.LocalConfigStorageKt;
import com.keepersecurity.secretsManager.core.Notation;
import com.keepersecurity.secretsManager.core.NotationSection;
import com.keepersecurity.secretsManager.core.SecretsManager;
import com.keepersecurity.secretsManager.core.SecretsManagerAddFileResponse;
import com.keepersecurity.secretsManager.core.SecretsManagerDeleteResponse;
import com.keepersecurity.secretsManager.core.SecretsManagerOptions;
import com.keepersecurity.secretsManager.core.SecretsManagerResponse;
import com.keepersecurity.secretsManager.core.SecretsManagerResponseFile;
import com.keepersecurity.secretsManager.core.SecretsManagerResponseFolder;
import com.keepersecurity.secretsManager.core.SecretsManagerResponseRecord;
import com.keepersecurity.secretsManager.core.SecureRandomException;
import com.keepersecurity.secretsManager.core.SecureRandomSlowGenerationException;
import com.keepersecurity.secretsManager.core.TestStubs;
import com.keepersecurity.secretsManager.core.TransmissionKey;
import com.keepersecurity.secretsManager.core.UpdatePayload;
import com.keepersecurity.secretsManager.core.UpdateTransactionType;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00d8\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0007\u001a\u001e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(\u001a\"\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00012\b\b\u0002\u0010-\u001a\u00020.H\u0007\u001a*\u0010/\u001a\u00020\u00012\u0006\u0010*\u001a\u00020+2\u0006\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u000204H\u0007\u001a\u001a\u00105\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001e\u001a\u0002062\u0006\u00107\u001a\u00020\u0012H\u0003\u001a\u001e\u00108\u001a\u0002092\u0006\u0010*\u001a\u00020+2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00010;H\u0007\u001a\u000e\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020>\u001a\u0018\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020>2\u0006\u0010$\u001a\u00020\u0001H\u0002\u001a\u000e\u0010?\u001a\u00020\u00122\u0006\u0010=\u001a\u00020>\u001a.\u0010@\u001a\u00020(\"\u0006\b\u0000\u0010A\u0018\u00012\u0006\u0010B\u001a\u00020C2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u0002HAH\u0083\b\u00a2\u0006\u0002\u0010D\u001a*\u0010E\u001a\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020.0F2\u0006\u0010*\u001a\u00020+2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00010;H\u0003\u001a\u0010\u0010H\u001a\u00020&2\u0006\u0010B\u001a\u00020CH\u0002\u001a\u001e\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00010;2\u0006\u0010*\u001a\u00020+2\u0006\u0010J\u001a\u00020\u0001H\u0007\u001a \u0010K\u001a\u0002042\u0006\u0010*\u001a\u00020+2\u000e\b\u0002\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00010;H\u0007\u001a$\u0010L\u001a\u00020\u001d2\u0006\u0010B\u001a\u00020C2\u0006\u0010M\u001a\u00020\u00012\n\b\u0002\u0010N\u001a\u0004\u0018\u00010\u0001H\u0007\u001a&\u0010O\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010P\u001a\u00020.\u001a.\u0010Q\u001a\u00020\u0012\"\u0006\b\u0000\u0010A\u0018\u00012\u0006\u0010*\u001a\u00020+2\u0006\u0010R\u001a\u00020\u00012\u0006\u0010'\u001a\u0002HAH\u0083\b\u00a2\u0006\u0002\u0010S\u001a\u0018\u0010T\u001a\u00020U2\u0006\u0010B\u001a\u00020C2\u0006\u0010,\u001a\u00020\u0001H\u0003\u001a(\u0010V\u001a\u00020W2\u0006\u0010B\u001a\u00020C2\u0006\u00100\u001a\u00020\u00012\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0003\u001a\u001e\u0010X\u001a\u00020Y2\u0006\u0010B\u001a\u00020C2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00010;H\u0003\u001a \u0010Z\u001a\u00020[2\u0006\u0010B\u001a\u00020C2\u0006\u0010\\\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020]H\u0003\u001a\u001e\u0010^\u001a\u00020_2\u0006\u0010B\u001a\u00020C2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020\u00010;H\u0002\u001a$\u0010`\u001a\u00020a2\u0006\u0010B\u001a\u00020C2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010b\u001a\u0004\u0018\u00010cH\u0003\u001a\b\u0010d\u001a\u00020\u001dH\u0002\u001a\b\u0010e\u001a\u00020fH\u0002\u001a\u001e\u0010g\u001a\b\u0012\u0004\u0012\u00020\u00010;2\u0006\u0010*\u001a\u00020+2\u0006\u0010J\u001a\u00020\u0001H\u0007\u001a$\u0010h\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010b\u001a\u0004\u0018\u00010cH\u0007\u001a \u0010i\u001a\u00020\u00012\u0006\u0010*\u001a\u00020+2\u0006\u0010\\\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020]H\u0007\u001a \u0010i\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010j\u001a\u00020\u00012\u0006\u0010k\u001a\u00020\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\" \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0014\"\u001a\u0010\u0015\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\"\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000*\u0094\u0001\u0010l\"G\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\bn\u0012\b\bo\u0012\u0004\b\b($\u0012\u0013\u0012\u00110&\u00a2\u0006\f\bn\u0012\b\bo\u0012\u0004\b\b(%\u0012\u0013\u0012\u00110(\u00a2\u0006\f\bn\u0012\b\bo\u0012\u0004\b\b('\u0012\u0004\u0012\u00020#0m2G\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\bn\u0012\b\bo\u0012\u0004\b\b($\u0012\u0013\u0012\u00110&\u00a2\u0006\f\bn\u0012\b\bo\u0012\u0004\b\b(%\u0012\u0013\u0012\u00110(\u00a2\u0006\f\bn\u0012\b\bo\u0012\u0004\b\b('\u0012\u0004\u0012\u00020#0m\u00a8\u0006p"}, d2={"CLIENT_ID_HASH_TAG", "", "FAST_SECURE_RANDOM_PREFIX", "KEEPER_CLIENT_VERSION", "KEY_APP_KEY", "KEY_CLIENT_ID", "KEY_CLIENT_KEY", "KEY_HOSTNAME", "KEY_OWNER_PUBLIC_KEY", "KEY_PRIVATE_KEY", "KEY_PUBLIC_KEY", "KEY_SERVER_PUBIC_KEY_ID", "SLOW_SECURE_RANDOM_MESSAGE", "SLOW_SECURE_RANDOM_PREFIX", "SecureRandomTestResult", "keeperPublicKeys", "", "", "", "getKeeperPublicKeys$annotations", "()V", "keyId", "getKeyId", "()I", "setKeyId", "(I)V", "nonStrictJson", "Lkotlinx/serialization/json/Json;", "addCustomField", "", "record", "Lcom/keepersecurity/secretsManager/core/KeeperRecord;", "field", "Lcom/keepersecurity/secretsManager/core/KeeperRecordField;", "cachingPostFunction", "Lcom/keepersecurity/secretsManager/core/KeeperHttpResponse;", "url", "transmissionKey", "Lcom/keepersecurity/secretsManager/core/TransmissionKey;", "payload", "Lcom/keepersecurity/secretsManager/core/EncryptedPayload;", "completeTransaction", "options", "Lcom/keepersecurity/secretsManager/core/SecretsManagerOptions;", "recordUid", "rollback", "", "createSecret", "folderUid", "recordData", "Lcom/keepersecurity/secretsManager/core/KeeperRecordData;", "secrets", "Lcom/keepersecurity/secretsManager/core/KeeperSecrets;", "decryptRecord", "Lcom/keepersecurity/secretsManager/core/SecretsManagerResponseRecord;", "recordKey", "deleteSecret", "Lcom/keepersecurity/secretsManager/core/SecretsManagerDeleteResponse;", "recordUids", "", "downloadFile", "file", "Lcom/keepersecurity/secretsManager/core/KeeperFile;", "downloadThumbnail", "encryptAndSignPayload", "T", "storage", "Lcom/keepersecurity/secretsManager/core/KeyValueStorage;", "(Lcom/keepersecurity/secretsManager/core/KeyValueStorage;Lcom/keepersecurity/secretsManager/core/TransmissionKey;Ljava/lang/Object;)Lcom/keepersecurity/secretsManager/core/EncryptedPayload;", "fetchAndDecryptSecrets", "Lkotlin/Pair;", "recordsFilter", "generateTransmissionKey", "getNotationResults", "notation", "getSecrets", "initializeStorage", "oneTimeToken", "hostName", "postFunction", "allowUnverifiedCertificate", "postQuery", "path", "(Lcom/keepersecurity/secretsManager/core/SecretsManagerOptions;Ljava/lang/String;Ljava/lang/Object;)[B", "prepareCompleteTransactionPayload", "Lcom/keepersecurity/secretsManager/core/CompleteTransactionPayload;", "prepareCreatePayload", "Lcom/keepersecurity/secretsManager/core/CreatePayload;", "prepareDeletePayload", "Lcom/keepersecurity/secretsManager/core/DeletePayload;", "prepareFileUploadPayload", "Lcom/keepersecurity/secretsManager/core/FileUploadPayloadAndFile;", "ownerRecord", "Lcom/keepersecurity/secretsManager/core/KeeperFileUpload;", "prepareGetPayload", "Lcom/keepersecurity/secretsManager/core/GetPayload;", "prepareUpdatePayload", "Lcom/keepersecurity/secretsManager/core/UpdatePayload;", "transactionType", "Lcom/keepersecurity/secretsManager/core/UpdateTransactionType;", "testSecureRandom", "trustAllSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "tryGetNotationResults", "updateSecret", "uploadFile", "parameters", "fileData", "QueryFunction", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "core"})
@JvmName(name="SecretsManager")
public final class SecretsManager {
    @NotNull
    public static final String KEEPER_CLIENT_VERSION = "mj16.5.3";
    @NotNull
    public static final String KEY_HOSTNAME = "hostname";
    @NotNull
    public static final String KEY_SERVER_PUBIC_KEY_ID = "serverPublicKeyId";
    @NotNull
    public static final String KEY_CLIENT_ID = "clientId";
    @NotNull
    public static final String KEY_CLIENT_KEY = "clientKey";
    @NotNull
    public static final String KEY_APP_KEY = "appKey";
    @NotNull
    public static final String KEY_OWNER_PUBLIC_KEY = "appOwnerPublicKey";
    @NotNull
    public static final String KEY_PRIVATE_KEY = "privateKey";
    @NotNull
    public static final String KEY_PUBLIC_KEY = "publicKey";
    @NotNull
    private static final String CLIENT_ID_HASH_TAG = "KEEPER_SECRETS_MANAGER_CLIENT_ID";
    @NotNull
    private static final String FAST_SECURE_RANDOM_PREFIX = "Fast SecureRandom detected! ";
    @NotNull
    private static final String SLOW_SECURE_RANDOM_PREFIX = "Slow SecureRandom detected! ";
    @NotNull
    private static final String SLOW_SECURE_RANDOM_MESSAGE = " Install one of the following entropy sources to improve speed of random number generator on your platform: 'haveged' or 'rng-tools'";
    @NotNull
    private static String SecureRandomTestResult;
    @NotNull
    private static final Json nonStrictJson;
    private static int keyId;
    @NotNull
    private static final Map<Integer, byte[]> keeperPublicKeys;

    @JvmOverloads
    public static final void initializeStorage(@NotNull KeyValueStorage storage, @NotNull String oneTimeToken, @Nullable String hostName) {
        String clientKey;
        String host;
        block26: {
            String string;
            List tokenParts;
            block25: {
                Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
                Intrinsics.checkNotNullParameter((Object)oneTimeToken, (String)"oneTimeToken");
                char[] cArray = new char[]{':'};
                tokenParts = StringsKt.split$default((CharSequence)oneTimeToken, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                host = null;
                clientKey = null;
                if (tokenParts.size() != 1) break block25;
                String string2 = hostName;
                if (string2 == null) {
                    throw new Exception("The hostname must be present in the token or as a parameter");
                }
                host = string2;
                clientKey = oneTimeToken;
                break block26;
            }
            String string3 = (String)tokenParts.get(0);
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string4 = string3.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(locale)");
            switch (string4) {
                case "US": {
                    string = "keepersecurity.com";
                    break;
                }
                case "EU": {
                    string = "keepersecurity.eu";
                    break;
                }
                case "AU": {
                    string = "keepersecurity.com.au";
                    break;
                }
                case "GOV": {
                    string = "govcloud.keepersecurity.us";
                    break;
                }
                case "JP": {
                    string = "keepersecurity.jp";
                    break;
                }
                case "CA": {
                    string = "keepersecurity.ca";
                    break;
                }
                default: {
                    string = (String)tokenParts.get(0);
                }
            }
            host = string;
            clientKey = (String)tokenParts.get(1);
        }
        byte[] clientKeyBytes = CryptoUtils.webSafe64ToBytes(clientKey);
        byte[] clientKeyHash = CryptoUtils.hash(clientKeyBytes, CLIENT_ID_HASH_TAG);
        String clientId = CryptoUtils.bytesToBase64(clientKeyHash);
        String existingClientId = storage.getString(KEY_CLIENT_ID);
        if (existingClientId != null) {
            if (Intrinsics.areEqual((Object)clientId, (Object)existingClientId)) {
                return;
            }
            throw new Exception("The storage is already initialized with a different client Id (" + existingClientId + ')');
        }
        storage.saveString(KEY_HOSTNAME, host);
        storage.saveString(KEY_CLIENT_ID, clientId);
        storage.saveBytes(KEY_CLIENT_KEY, clientKeyBytes);
        KeyPair keyPair = CryptoUtils.generateKeyPair();
        byte[] byArray = keyPair.getPrivate().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"keyPair.private.encoded");
        storage.saveBytes(KEY_PRIVATE_KEY, byArray);
        PublicKey publicKey = keyPair.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyPair.public");
        storage.saveBytes(KEY_PUBLIC_KEY, CryptoUtils.extractPublicRaw(publicKey));
    }

    public static /* synthetic */ void initializeStorage$default(KeyValueStorage keyValueStorage, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        SecretsManager.initializeStorage(keyValueStorage, string, string2);
    }

    private static final void testSecureRandom() {
        if (!StringsKt.isBlank((CharSequence)SecureRandomTestResult)) {
            if (StringsKt.startsWith$default((String)SecureRandomTestResult, (String)SLOW_SECURE_RANDOM_PREFIX, (boolean)false, (int)2, null)) {
                System.out.println((Object)SecureRandomTestResult);
            }
            return;
        }
        ExecutorService es = Executors.newSingleThreadExecutor();
        Future<Boolean> future = es.submit(SecretsManager::testSecureRandom$lambda-0);
        try {
            future.get(3L, TimeUnit.SECONDS);
            SecureRandomTestResult = FAST_SECURE_RANDOM_PREFIX;
        }
        catch (TimeoutException e) {
            SecureRandomTestResult = "Slow SecureRandom detected!  Install one of the following entropy sources to improve speed of random number generator on your platform: 'haveged' or 'rng-tools'";
            System.out.println((Object)SecureRandomTestResult);
            future.cancel(true);
            throw new SecureRandomSlowGenerationException(SecureRandomTestResult);
        }
        catch (InterruptedException e) {
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message ?: e.localizedMessage");
            throw new SecureRandomException(string);
        }
        catch (ExecutionException e) {
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message ?: e.localizedMessage");
            throw new SecureRandomException(string);
        }
        catch (Exception e) {
            String string = e.getMessage();
            if (string == null) {
                string = e.getLocalizedMessage();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.message ?: e.localizedMessage");
            throw new SecureRandomException(string);
        }
        es.shutdown();
    }

    @ExperimentalSerializationApi
    @JvmOverloads
    @NotNull
    public static final KeeperSecrets getSecrets(@NotNull SecretsManagerOptions options, @NotNull List<String> recordsFilter) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(recordsFilter, (String)"recordsFilter");
        Pair<KeeperSecrets, Boolean> pair = SecretsManager.fetchAndDecryptSecrets(options, recordsFilter);
        KeeperSecrets secrets = (KeeperSecrets)pair.component1();
        boolean justBound = (Boolean)pair.component2();
        if (justBound) {
            try {
                SecretsManager.fetchAndDecryptSecrets(options, recordsFilter);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return secrets;
    }

    public static /* synthetic */ KeeperSecrets getSecrets$default(SecretsManagerOptions secretsManagerOptions, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return SecretsManager.getSecrets(secretsManagerOptions, list);
    }

    @ExperimentalSerializationApi
    @NotNull
    public static final List<String> tryGetNotationResults(@NotNull SecretsManagerOptions options, @NotNull String notation) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)notation, (String)"notation");
        try {
            return SecretsManager.getNotationResults(options, notation);
        }
        catch (Exception e) {
            System.out.println((Object)e.getMessage());
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalSerializationApi
    @NotNull
    public static final List<String> getNotationResults(@NotNull SecretsManagerOptions options, @NotNull String notation) {
        KeeperSecrets secrets;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)notation, (String)"notation");
        List result = new ArrayList();
        List parsedNotation = Notation.parseNotation$default(notation, false, 2, null);
        if (parsedNotation.size() < 3) {
            throw new Exception("Invalid notation '" + notation + '\'');
        }
        Object object = ((NotationSection)parsedNotation.get(2)).getText();
        if (object == null || (object = (String)object.getFirst()) == null) {
            throw new Exception("Invalid notation '" + notation + '\'');
        }
        Object selector = object;
        Object object2 = ((NotationSection)parsedNotation.get(1)).getText();
        if (object2 == null || (object2 = (String)object2.getFirst()) == null) {
            throw new Exception("Invalid notation $'notation'");
        }
        Object recordToken = object2;
        List records = CollectionsKt.emptyList();
        CharSequence charSequence = (CharSequence)recordToken;
        if (new Regex("^[A-Za-z0-9_-]{22}$").matches(charSequence) && (records = (secrets = SecretsManager.getSecrets(options, CollectionsKt.listOf(recordToken))).getRecords()).size() > 1) {
            throw new Exception("Notation error - found multiple records with same UID '" + recordToken + '\'');
        }
        if (records.isEmpty()) {
            void $this$filterTo$iv$iv;
            secrets = SecretsManager.getSecrets$default(options, null, 2, null);
            Iterable $this$filter$iv = secrets.getRecords();
            boolean $i$f$filter = false;
            Object object3 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KeeperRecord it = (KeeperRecord)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getData().getTitle(), recordToken)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            records = (List)destination$iv$iv;
        }
        if (records.size() > 1) {
            throw new Exception("Notation error - multiple records match record '" + recordToken + '\'');
        }
        if (records.isEmpty()) {
            throw new Exception("Notation error - no records match record '" + recordToken + '\'');
        }
        KeeperRecord record = records.get(0);
        Pair<String, String> pair = ((NotationSection)parsedNotation.get(2)).getParameter();
        String parameter = pair != null ? (String)pair.getFirst() : null;
        Pair<String, String> pair2 = ((NotationSection)parsedNotation.get(2)).getIndex1();
        String index1 = pair2 != null ? (String)pair2.getFirst() : null;
        String string = ((String)selector).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        switch (string) {
            case "type": {
                result.add(record.getData().getType());
                break;
            }
            case "title": {
                result.add(record.getData().getTitle());
                break;
            }
            case "notes": {
                if (record.getData().getNotes() == null) break;
                String string2 = record.getData().getNotes();
                Intrinsics.checkNotNull((Object)string2);
                result.add(string2);
                break;
            }
            case "file": {
                void $this$filterTo$iv$iv;
                Object element$iv$iv;
                if (parameter == null) {
                    throw new Exception("Notation error - Missing required parameter: filename or file UID for files in record '" + recordToken + '\'');
                }
                List<KeeperFile> list = record.getFiles();
                if ((list != null ? list.size() : 0) < 1) {
                    throw new Exception("Notation error - Record " + recordToken + " has no file attachments.");
                }
                List<KeeperFile> list2 = record.getFiles();
                Intrinsics.checkNotNull(list2);
                Iterable $this$filter$iv = list2;
                boolean $i$f$filter = false;
                element$iv$iv = $this$filter$iv;
                Iterable destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    KeeperFile it = (KeeperFile)element$iv$iv2;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)parameter, (Object)it.getData().getName()) || Intrinsics.areEqual((Object)parameter, (Object)it.getData().getTitle()) || Intrinsics.areEqual((Object)parameter, (Object)it.getFileUid()))) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                List files = (List)destination$iv$iv;
                if (files.size() > 1) {
                    throw new Exception("Notation error - Record " + recordToken + " has multiple files matching the search criteria '" + parameter + '\'');
                }
                if (files.isEmpty()) {
                    throw new Exception("Notation error - Record " + recordToken + " has no files matching the search criteria '" + parameter + '\'');
                }
                byte[] contents = SecretsManager.downloadFile((KeeperFile)files.get(0));
                String text = CryptoUtils.webSafe64FromBytes(contents);
                result.add(text);
                break;
            }
            case "custom_field": 
            case "field": {
                int expectedSize;
                int valuesCount;
                int idx;
                CharSequence $this$filterTo$iv$iv;
                List list;
                if (parameter == null) {
                    throw new Exception("Notation error - Missing required parameter for the field (type or label): ex. /field/type or /custom_field/MyLabel");
                }
                String string3 = ((String)selector).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                String contents = string3;
                if (Intrinsics.areEqual((Object)contents, (Object)"field")) {
                    list = record.getData().getFields();
                } else if (Intrinsics.areEqual((Object)contents, (Object)"custom_field")) {
                    list = record.getData().getCustom();
                    if (list == null) {
                        list = new ArrayList();
                    }
                } else {
                    throw new Exception("Notation error - Expected /field or /custom_field but found /" + (String)selector);
                }
                List fields = list;
                Iterable $this$filter$iv = fields;
                boolean $i$f$filter = false;
                Iterable destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator element$iv$iv2 = $this$filterTo$iv$iv.iterator();
                while (element$iv$iv2.hasNext()) {
                    Object element$iv$iv = element$iv$iv2.next();
                    KeeperRecordField it = (KeeperRecordField)element$iv$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)parameter, (Object)Notation.fieldType(it)) || Intrinsics.areEqual((Object)parameter, (Object)it.getLabel()))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List flds = (List)destination$iv$iv2;
                if (flds.size() > 1) {
                    throw new Exception("Notation error - Record " + recordToken + " has multiple fields matching the search criteria '" + parameter + '\'');
                }
                if (flds.isEmpty()) {
                    throw new Exception("Notation error - Record " + recordToken + " has no fields matching the search criteria '" + parameter + '\'');
                }
                KeeperRecordField field = (KeeperRecordField)flds.get(0);
                Object object4 = index1;
                int n = object4 != null && (object4 = StringsKt.toIntOrNull((String)object4)) != null ? (Integer)object4 : (idx = -1);
                if (idx == -1) {
                    Pair<String, String> pair3 = ((NotationSection)parsedNotation.get(2)).getIndex1();
                    $this$filterTo$iv$iv = pair3 != null ? (String)pair3.getSecond() : null;
                    if (!($this$filterTo$iv$iv == null || $this$filterTo$iv$iv.length() == 0)) {
                        Pair<String, String> pair4 = ((NotationSection)parsedNotation.get(2)).getIndex1();
                        if (!Intrinsics.areEqual((Object)(pair4 != null ? (String)pair4.getSecond() : null), (Object)"[]")) {
                            throw new Exception("Notation error - Invalid field index " + idx);
                        }
                    }
                }
                if (idx >= (valuesCount = Notation.getFieldValuesCount(field))) {
                    throw new Exception("Notation error - Field index out of bounds " + idx + " >= " + valuesCount + " for field " + parameter);
                }
                Pair<String, String> pair5 = ((NotationSection)parsedNotation.get(2)).getIndex2();
                String objPropertyName = pair5 != null ? (String)pair5.getFirst() : null;
                List<String> res = Notation.getFieldStringValues(field, idx, objPropertyName);
                int n2 = expectedSize = idx >= 0 ? 1 : valuesCount;
                if (res.size() != expectedSize) {
                    System.out.println((Object)("Notation warning - extracted " + res.size() + " out of " + valuesCount + " values for '" + objPropertyName + "' property."));
                }
                if (!(!((Collection)res).isEmpty())) break;
                result.addAll((Collection)res);
                break;
            }
            default: {
                throw new Exception("Invalid notation '" + notation + '\'');
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalSerializationApi
    @NotNull
    public static final SecretsManagerDeleteResponse deleteSecret(@NotNull SecretsManagerOptions options, @NotNull List<String> recordUids) {
        void $this$decodeFromString$iv;
        KeeperHttpResponse response$iv;
        TransmissionKey transmissionKey$iv;
        String path$iv;
        block5: {
            String errorMessage$iv;
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter(recordUids, (String)"recordUids");
            DeletePayload payload = SecretsManager.prepareDeletePayload(options.getStorage(), recordUids);
            path$iv = "delete_secret";
            boolean $i$f$postQuery = false;
            String string = options.getStorage().getString(KEY_HOSTNAME);
            if (string == null) {
                throw new Exception("hostname is missing from the storage");
            }
            String hostName$iv = string;
            String url$iv = "https://" + hostName$iv + "/api/rest/sm/v1/" + path$iv;
            while (true) {
                byte[] privateKey$iv$iv;
                transmissionKey$iv = SecretsManager.generateTransmissionKey(options.getStorage());
                KeyValueStorage storage$iv$iv = options.getStorage();
                boolean $i$f$encryptAndSignPayload = false;
                StringFormat $this$encodeToString$iv$iv$iv = (StringFormat)Json.Default;
                boolean $i$f$encodeToString = false;
                SerializersModule $this$serializer$iv$iv$iv$iv = $this$encodeToString$iv$iv$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv$iv, (KType)Reflection.typeOf(DeletePayload.class));
                boolean $i$f$cast = false;
                byte[] payloadBytes$iv$iv = CryptoUtils.stringToBytes($this$encodeToString$iv$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv$iv, (Object)payload));
                byte[] encryptedPayload$iv$iv = CryptoUtils.encrypt(payloadBytes$iv$iv, transmissionKey$iv.getKey());
                if (storage$iv$iv.getBytes(KEY_PRIVATE_KEY) == null) {
                    throw new Exception("Private key is missing from the storage");
                }
                byte[] signatureBase$iv$iv = ArraysKt.plus((byte[])transmissionKey$iv.getEncryptedKey(), (byte[])encryptedPayload$iv$iv);
                byte[] signature$iv$iv = CryptoUtils.sign(signatureBase$iv$iv, privateKey$iv$iv);
                EncryptedPayload encryptedPayload$iv = new EncryptedPayload(encryptedPayload$iv$iv, signature$iv$iv);
                KeeperHttpResponse keeperHttpResponse = response$iv = options.getQueryFunction() == null ? SecretsManager.postFunction(url$iv, transmissionKey$iv, encryptedPayload$iv, options.getAllowUnverifiedCertificate()) : (KeeperHttpResponse)options.getQueryFunction().invoke((Object)url$iv, (Object)transmissionKey$iv, (Object)encryptedPayload$iv);
                if (response$iv.getStatusCode() == 200) break block5;
                errorMessage$iv = new String(response$iv.getData(), Charsets.UTF_8);
                try {
                    StringFormat $this$decodeFromString$iv$iv = (StringFormat)nonStrictJson;
                    boolean $i$f$decodeFromString = false;
                    SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromString$iv$iv.getSerializersModule();
                    boolean $i$f$serializer2 = false;
                    KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(KeeperError.class));
                    boolean $i$f$cast2 = false;
                    KeeperError error$iv = (KeeperError)$this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv$iv, errorMessage$iv);
                    if (!Intrinsics.areEqual((Object)error$iv.getError(), (Object)"key")) break;
                    options.getStorage().saveString(KEY_SERVER_PUBIC_KEY_ID, String.valueOf(error$iv.getKey_id()));
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            throw new Exception(errorMessage$iv);
        }
        byte[] responseData = response$iv.getData().length == 0 ? response$iv.getData() : CryptoUtils.decrypt(response$iv.getData(), transmissionKey$iv.getKey());
        path$iv = (StringFormat)nonStrictJson;
        String string$iv = CryptoUtils.bytesToString(responseData);
        boolean $i$f$decodeFromString = false;
        SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(SecretsManagerDeleteResponse.class));
        boolean $i$f$cast = false;
        return (SecretsManagerDeleteResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv);
    }

    @ExperimentalSerializationApi
    public static final void updateSecret(@NotNull SecretsManagerOptions options, @NotNull KeeperRecord record, @Nullable UpdateTransactionType transactionType) {
        KeeperHttpResponse response$iv;
        TransmissionKey transmissionKey$iv;
        block5: {
            String errorMessage$iv;
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            UpdatePayload payload = SecretsManager.prepareUpdatePayload(options.getStorage(), record, transactionType);
            String path$iv = "update_secret";
            boolean $i$f$postQuery = false;
            String string = options.getStorage().getString(KEY_HOSTNAME);
            if (string == null) {
                throw new Exception("hostname is missing from the storage");
            }
            String hostName$iv = string;
            String url$iv = "https://" + hostName$iv + "/api/rest/sm/v1/" + path$iv;
            while (true) {
                byte[] privateKey$iv$iv;
                transmissionKey$iv = SecretsManager.generateTransmissionKey(options.getStorage());
                KeyValueStorage storage$iv$iv = options.getStorage();
                boolean $i$f$encryptAndSignPayload = false;
                StringFormat $this$encodeToString$iv$iv$iv = (StringFormat)Json.Default;
                boolean $i$f$encodeToString = false;
                SerializersModule $this$serializer$iv$iv$iv$iv = $this$encodeToString$iv$iv$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv$iv, (KType)Reflection.typeOf(UpdatePayload.class));
                boolean $i$f$cast = false;
                byte[] payloadBytes$iv$iv = CryptoUtils.stringToBytes($this$encodeToString$iv$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv$iv, (Object)payload));
                byte[] encryptedPayload$iv$iv = CryptoUtils.encrypt(payloadBytes$iv$iv, transmissionKey$iv.getKey());
                if (storage$iv$iv.getBytes(KEY_PRIVATE_KEY) == null) {
                    throw new Exception("Private key is missing from the storage");
                }
                byte[] signatureBase$iv$iv = ArraysKt.plus((byte[])transmissionKey$iv.getEncryptedKey(), (byte[])encryptedPayload$iv$iv);
                byte[] signature$iv$iv = CryptoUtils.sign(signatureBase$iv$iv, privateKey$iv$iv);
                EncryptedPayload encryptedPayload$iv = new EncryptedPayload(encryptedPayload$iv$iv, signature$iv$iv);
                KeeperHttpResponse keeperHttpResponse = response$iv = options.getQueryFunction() == null ? SecretsManager.postFunction(url$iv, transmissionKey$iv, encryptedPayload$iv, options.getAllowUnverifiedCertificate()) : (KeeperHttpResponse)options.getQueryFunction().invoke((Object)url$iv, (Object)transmissionKey$iv, (Object)encryptedPayload$iv);
                if (response$iv.getStatusCode() == 200) break block5;
                errorMessage$iv = new String(response$iv.getData(), Charsets.UTF_8);
                try {
                    StringFormat $this$decodeFromString$iv$iv = (StringFormat)nonStrictJson;
                    boolean $i$f$decodeFromString = false;
                    SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromString$iv$iv.getSerializersModule();
                    boolean $i$f$serializer2 = false;
                    KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(KeeperError.class));
                    boolean $i$f$cast2 = false;
                    KeeperError error$iv = (KeeperError)$this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv$iv, errorMessage$iv);
                    if (!Intrinsics.areEqual((Object)error$iv.getError(), (Object)"key")) break;
                    options.getStorage().saveString(KEY_SERVER_PUBIC_KEY_ID, String.valueOf(error$iv.getKey_id()));
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            throw new Exception(errorMessage$iv);
        }
        byte[] byArray = response$iv.getData().length == 0 ? response$iv.getData() : CryptoUtils.decrypt(response$iv.getData(), transmissionKey$iv.getKey());
    }

    public static /* synthetic */ void updateSecret$default(SecretsManagerOptions secretsManagerOptions, KeeperRecord keeperRecord, UpdateTransactionType updateTransactionType, int n, Object object) {
        if ((n & 4) != 0) {
            updateTransactionType = null;
        }
        SecretsManager.updateSecret(secretsManagerOptions, keeperRecord, updateTransactionType);
    }

    @ExperimentalSerializationApi
    public static final void completeTransaction(@NotNull SecretsManagerOptions options, @NotNull String recordUid, boolean rollback) {
        KeeperHttpResponse response$iv;
        TransmissionKey transmissionKey$iv;
        block5: {
            String errorMessage$iv;
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)recordUid, (String)"recordUid");
            CompleteTransactionPayload payload = SecretsManager.prepareCompleteTransactionPayload(options.getStorage(), recordUid);
            String path = rollback ? "rollback_secret_update" : "finalize_secret_update";
            boolean $i$f$postQuery = false;
            String string = options.getStorage().getString(KEY_HOSTNAME);
            if (string == null) {
                throw new Exception("hostname is missing from the storage");
            }
            String hostName$iv = string;
            String url$iv = "https://" + hostName$iv + "/api/rest/sm/v1/" + path;
            while (true) {
                byte[] privateKey$iv$iv;
                transmissionKey$iv = SecretsManager.generateTransmissionKey(options.getStorage());
                KeyValueStorage storage$iv$iv = options.getStorage();
                boolean $i$f$encryptAndSignPayload = false;
                StringFormat $this$encodeToString$iv$iv$iv = (StringFormat)Json.Default;
                boolean $i$f$encodeToString = false;
                SerializersModule $this$serializer$iv$iv$iv$iv = $this$encodeToString$iv$iv$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv$iv, (KType)Reflection.typeOf(CompleteTransactionPayload.class));
                boolean $i$f$cast = false;
                byte[] payloadBytes$iv$iv = CryptoUtils.stringToBytes($this$encodeToString$iv$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv$iv, (Object)payload));
                byte[] encryptedPayload$iv$iv = CryptoUtils.encrypt(payloadBytes$iv$iv, transmissionKey$iv.getKey());
                if (storage$iv$iv.getBytes(KEY_PRIVATE_KEY) == null) {
                    throw new Exception("Private key is missing from the storage");
                }
                byte[] signatureBase$iv$iv = ArraysKt.plus((byte[])transmissionKey$iv.getEncryptedKey(), (byte[])encryptedPayload$iv$iv);
                byte[] signature$iv$iv = CryptoUtils.sign(signatureBase$iv$iv, privateKey$iv$iv);
                EncryptedPayload encryptedPayload$iv = new EncryptedPayload(encryptedPayload$iv$iv, signature$iv$iv);
                KeeperHttpResponse keeperHttpResponse = response$iv = options.getQueryFunction() == null ? SecretsManager.postFunction(url$iv, transmissionKey$iv, encryptedPayload$iv, options.getAllowUnverifiedCertificate()) : (KeeperHttpResponse)options.getQueryFunction().invoke((Object)url$iv, (Object)transmissionKey$iv, (Object)encryptedPayload$iv);
                if (response$iv.getStatusCode() == 200) break block5;
                errorMessage$iv = new String(response$iv.getData(), Charsets.UTF_8);
                try {
                    StringFormat $this$decodeFromString$iv$iv = (StringFormat)nonStrictJson;
                    boolean $i$f$decodeFromString = false;
                    SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromString$iv$iv.getSerializersModule();
                    boolean $i$f$serializer2 = false;
                    KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(KeeperError.class));
                    boolean $i$f$cast2 = false;
                    KeeperError error$iv = (KeeperError)$this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv$iv, errorMessage$iv);
                    if (!Intrinsics.areEqual((Object)error$iv.getError(), (Object)"key")) break;
                    options.getStorage().saveString(KEY_SERVER_PUBIC_KEY_ID, String.valueOf(error$iv.getKey_id()));
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            throw new Exception(errorMessage$iv);
        }
        byte[] byArray = response$iv.getData().length == 0 ? response$iv.getData() : CryptoUtils.decrypt(response$iv.getData(), transmissionKey$iv.getKey());
    }

    public static /* synthetic */ void completeTransaction$default(SecretsManagerOptions secretsManagerOptions, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        SecretsManager.completeTransaction(secretsManagerOptions, string, bl);
    }

    @ExperimentalSerializationApi
    public static final void addCustomField(@NotNull KeeperRecord record, @NotNull KeeperRecordField field) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        if (Intrinsics.areEqual(field.getClass().getSuperclass(), KeeperRecordField.class)) {
            if (record.getData().getCustom() == null) {
                record.getData().setCustom(new ArrayList());
            }
            List<KeeperRecordField> list = record.getData().getCustom();
            Intrinsics.checkNotNull(list);
            list.add(field);
        }
    }

    @ExperimentalSerializationApi
    @JvmOverloads
    @NotNull
    public static final String createSecret(@NotNull SecretsManagerOptions options, @NotNull String folderUid, @NotNull KeeperRecordData recordData, @NotNull KeeperSecrets secrets) {
        KeeperHttpResponse response$iv;
        TransmissionKey transmissionKey$iv;
        CreatePayload payload;
        block5: {
            String errorMessage$iv;
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)folderUid, (String)"folderUid");
            Intrinsics.checkNotNullParameter((Object)recordData, (String)"recordData");
            Intrinsics.checkNotNullParameter((Object)secrets, (String)"secrets");
            payload = SecretsManager.prepareCreatePayload(options.getStorage(), folderUid, recordData, secrets);
            String path$iv = "create_secret";
            boolean $i$f$postQuery = false;
            String string = options.getStorage().getString(KEY_HOSTNAME);
            if (string == null) {
                throw new Exception("hostname is missing from the storage");
            }
            String hostName$iv = string;
            String url$iv = "https://" + hostName$iv + "/api/rest/sm/v1/" + path$iv;
            while (true) {
                byte[] privateKey$iv$iv;
                transmissionKey$iv = SecretsManager.generateTransmissionKey(options.getStorage());
                KeyValueStorage storage$iv$iv = options.getStorage();
                boolean $i$f$encryptAndSignPayload = false;
                StringFormat $this$encodeToString$iv$iv$iv = (StringFormat)Json.Default;
                boolean $i$f$encodeToString = false;
                SerializersModule $this$serializer$iv$iv$iv$iv = $this$encodeToString$iv$iv$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv$iv, (KType)Reflection.typeOf(CreatePayload.class));
                boolean $i$f$cast = false;
                byte[] payloadBytes$iv$iv = CryptoUtils.stringToBytes($this$encodeToString$iv$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv$iv, (Object)payload));
                byte[] encryptedPayload$iv$iv = CryptoUtils.encrypt(payloadBytes$iv$iv, transmissionKey$iv.getKey());
                if (storage$iv$iv.getBytes(KEY_PRIVATE_KEY) == null) {
                    throw new Exception("Private key is missing from the storage");
                }
                byte[] signatureBase$iv$iv = ArraysKt.plus((byte[])transmissionKey$iv.getEncryptedKey(), (byte[])encryptedPayload$iv$iv);
                byte[] signature$iv$iv = CryptoUtils.sign(signatureBase$iv$iv, privateKey$iv$iv);
                EncryptedPayload encryptedPayload$iv = new EncryptedPayload(encryptedPayload$iv$iv, signature$iv$iv);
                KeeperHttpResponse keeperHttpResponse = response$iv = options.getQueryFunction() == null ? SecretsManager.postFunction(url$iv, transmissionKey$iv, encryptedPayload$iv, options.getAllowUnverifiedCertificate()) : (KeeperHttpResponse)options.getQueryFunction().invoke((Object)url$iv, (Object)transmissionKey$iv, (Object)encryptedPayload$iv);
                if (response$iv.getStatusCode() == 200) break block5;
                errorMessage$iv = new String(response$iv.getData(), Charsets.UTF_8);
                try {
                    StringFormat $this$decodeFromString$iv$iv = (StringFormat)nonStrictJson;
                    boolean $i$f$decodeFromString = false;
                    SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromString$iv$iv.getSerializersModule();
                    boolean $i$f$serializer2 = false;
                    KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(KeeperError.class));
                    boolean $i$f$cast2 = false;
                    KeeperError error$iv = (KeeperError)$this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv$iv, errorMessage$iv);
                    if (!Intrinsics.areEqual((Object)error$iv.getError(), (Object)"key")) break;
                    options.getStorage().saveString(KEY_SERVER_PUBIC_KEY_ID, String.valueOf(error$iv.getKey_id()));
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            throw new Exception(errorMessage$iv);
        }
        byte[] byArray = response$iv.getData().length == 0 ? response$iv.getData() : CryptoUtils.decrypt(response$iv.getData(), transmissionKey$iv.getKey());
        return payload.getRecordUid();
    }

    public static /* synthetic */ String createSecret$default(SecretsManagerOptions secretsManagerOptions, String string, KeeperRecordData keeperRecordData, KeeperSecrets keeperSecrets, int n, Object object) {
        if ((n & 8) != 0) {
            keeperSecrets = SecretsManager.getSecrets$default(secretsManagerOptions, null, 2, null);
        }
        return SecretsManager.createSecret(secretsManagerOptions, string, keeperRecordData, keeperSecrets);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalSerializationApi
    @NotNull
    public static final String uploadFile(@NotNull SecretsManagerOptions options, @NotNull KeeperRecord ownerRecord, @NotNull KeeperFileUpload file) {
        void $this$decodeFromString$iv;
        KeeperHttpResponse response$iv;
        TransmissionKey transmissionKey$iv;
        FileUploadPayload payload$iv;
        FileUploadPayloadAndFile payloadAndFile;
        block6: {
            String errorMessage$iv;
            void path$iv;
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)ownerRecord, (String)"ownerRecord");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            payloadAndFile = SecretsManager.prepareFileUploadPayload(options.getStorage(), ownerRecord, file);
            String string = "add_file";
            payload$iv = payloadAndFile.getPayload();
            boolean $i$f$postQuery = false;
            String string2 = options.getStorage().getString(KEY_HOSTNAME);
            if (string2 == null) {
                throw new Exception("hostname is missing from the storage");
            }
            String hostName$iv = string2;
            String url$iv = "https://" + hostName$iv + "/api/rest/sm/v1/" + (String)path$iv;
            while (true) {
                byte[] privateKey$iv$iv;
                transmissionKey$iv = SecretsManager.generateTransmissionKey(options.getStorage());
                KeyValueStorage storage$iv$iv = options.getStorage();
                boolean $i$f$encryptAndSignPayload = false;
                StringFormat $this$encodeToString$iv$iv$iv = (StringFormat)Json.Default;
                boolean $i$f$encodeToString = false;
                SerializersModule $this$serializer$iv$iv$iv$iv = $this$encodeToString$iv$iv$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv$iv, (KType)Reflection.typeOf(FileUploadPayload.class));
                boolean $i$f$cast = false;
                byte[] payloadBytes$iv$iv = CryptoUtils.stringToBytes($this$encodeToString$iv$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv$iv, (Object)payload$iv));
                byte[] encryptedPayload$iv$iv = CryptoUtils.encrypt(payloadBytes$iv$iv, transmissionKey$iv.getKey());
                if (storage$iv$iv.getBytes(KEY_PRIVATE_KEY) == null) {
                    throw new Exception("Private key is missing from the storage");
                }
                byte[] signatureBase$iv$iv = ArraysKt.plus((byte[])transmissionKey$iv.getEncryptedKey(), (byte[])encryptedPayload$iv$iv);
                byte[] signature$iv$iv = CryptoUtils.sign(signatureBase$iv$iv, privateKey$iv$iv);
                EncryptedPayload encryptedPayload$iv = new EncryptedPayload(encryptedPayload$iv$iv, signature$iv$iv);
                KeeperHttpResponse keeperHttpResponse = response$iv = options.getQueryFunction() == null ? SecretsManager.postFunction(url$iv, transmissionKey$iv, encryptedPayload$iv, options.getAllowUnverifiedCertificate()) : (KeeperHttpResponse)options.getQueryFunction().invoke((Object)url$iv, (Object)transmissionKey$iv, (Object)encryptedPayload$iv);
                if (response$iv.getStatusCode() == 200) break block6;
                errorMessage$iv = new String(response$iv.getData(), Charsets.UTF_8);
                try {
                    StringFormat $this$decodeFromString$iv$iv = (StringFormat)nonStrictJson;
                    boolean $i$f$decodeFromString = false;
                    SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromString$iv$iv.getSerializersModule();
                    boolean $i$f$serializer2 = false;
                    KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(KeeperError.class));
                    boolean $i$f$cast2 = false;
                    KeeperError error$iv = (KeeperError)$this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv$iv, errorMessage$iv);
                    if (!Intrinsics.areEqual((Object)error$iv.getError(), (Object)"key")) break;
                    options.getStorage().saveString(KEY_SERVER_PUBIC_KEY_ID, String.valueOf(error$iv.getKey_id()));
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            throw new Exception(errorMessage$iv);
        }
        byte[] responseData = response$iv.getData().length == 0 ? response$iv.getData() : CryptoUtils.decrypt(response$iv.getData(), transmissionKey$iv.getKey());
        payload$iv = (StringFormat)nonStrictJson;
        String string$iv = CryptoUtils.bytesToString(responseData);
        boolean $i$f$decodeFromString = false;
        SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(SecretsManagerAddFileResponse.class));
        boolean $i$f$cast = false;
        SecretsManagerAddFileResponse response = (SecretsManagerAddFileResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv);
        KeeperHttpResponse uploadResult = SecretsManager.uploadFile(response.getUrl(), response.getParameters(), payloadAndFile.getEncryptedFile());
        if (uploadResult.getStatusCode() != response.getSuccessStatusCode()) {
            throw new Exception("Upload failed (" + CryptoUtils.bytesToString(uploadResult.getData()) + "), code " + uploadResult.getStatusCode());
        }
        return payloadAndFile.getPayload().getFileRecordUid();
    }

    @NotNull
    public static final byte[] downloadFile(@NotNull KeeperFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return SecretsManager.downloadFile(file, file.getUrl());
    }

    @NotNull
    public static final byte[] downloadThumbnail(@NotNull KeeperFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.getThumbnailUrl() == null) {
            throw new Exception("Thumbnail does not exist for the file " + file.getFileUid());
        }
        return SecretsManager.downloadFile(file, file.getThumbnailUrl());
    }

    private static final byte[] downloadFile(KeeperFile file, String url) {
        byte[] data;
        byte[] byArray;
        URLConnection uRLConnection = new URL(url).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        }
        HttpsURLConnection $this$downloadFile_u24lambda_u2d4 = (HttpsURLConnection)uRLConnection;
        boolean bl = false;
        $this$downloadFile_u24lambda_u2d4.setRequestMethod("GET");
        int statusCode = $this$downloadFile_u24lambda_u2d4.getResponseCode();
        if ($this$downloadFile_u24lambda_u2d4.getErrorStream() != null) {
            InputStream inputStream = $this$downloadFile_u24lambda_u2d4.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"errorStream");
            byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        } else {
            InputStream inputStream = $this$downloadFile_u24lambda_u2d4.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            byArray = data = ByteStreamsKt.readBytes((InputStream)inputStream);
        }
        if (statusCode != 200) {
            throw new Exception(new String(data, Charsets.UTF_8));
        }
        return CryptoUtils.decrypt(data, file.getFileKey());
    }

    private static final KeeperHttpResponse uploadFile(String url, String parameters, byte[] fileData) {
        byte[] byArray;
        int statusCode = 0;
        byte[] data = null;
        String string = "----------%x";
        Object[] objectArray = new Object[]{Instant.now().getEpochSecond()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        String boundary = string2;
        byte[] boundaryBytes = CryptoUtils.stringToBytes("\r\n--" + boundary);
        JsonObject paramJson = (JsonObject)Json.Default.parseToJsonElement(parameters);
        URLConnection uRLConnection = new URL(url).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        }
        HttpsURLConnection $this$uploadFile_u24lambda_u2d6 = (HttpsURLConnection)uRLConnection;
        boolean bl = false;
        $this$uploadFile_u24lambda_u2d6.setRequestMethod("POST");
        $this$uploadFile_u24lambda_u2d6.setUseCaches(false);
        $this$uploadFile_u24lambda_u2d6.setDoInput(true);
        $this$uploadFile_u24lambda_u2d6.setDoOutput(true);
        $this$uploadFile_u24lambda_u2d6.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        OutputStream $this$uploadFile_u24lambda_u2d6_u24lambda_u2d5 = $this$uploadFile_u24lambda_u2d6.getOutputStream();
        boolean bl2 = false;
        for (Map.Entry param : paramJson.entrySet()) {
            $this$uploadFile_u24lambda_u2d6_u24lambda_u2d5.write(boundaryBytes);
            $this$uploadFile_u24lambda_u2d6_u24lambda_u2d5.write(CryptoUtils.stringToBytes("\r\nContent-Disposition: form-data; name=\"" + (String)param.getKey() + "\"\r\n\r\n" + JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)param.getValue())).getContent()));
        }
        $this$uploadFile_u24lambda_u2d6_u24lambda_u2d5.write(boundaryBytes);
        $this$uploadFile_u24lambda_u2d6_u24lambda_u2d5.write(CryptoUtils.stringToBytes("\r\nContent-Disposition: form-data; name=\"file\"\r\nContent-Type: application/octet-stream\r\n\r\n"));
        $this$uploadFile_u24lambda_u2d6_u24lambda_u2d5.write(fileData);
        $this$uploadFile_u24lambda_u2d6_u24lambda_u2d5.write(boundaryBytes);
        $this$uploadFile_u24lambda_u2d6_u24lambda_u2d5.write(CryptoUtils.stringToBytes("--\r\n"));
        statusCode = $this$uploadFile_u24lambda_u2d6.getResponseCode();
        if ($this$uploadFile_u24lambda_u2d6.getErrorStream() != null) {
            InputStream inputStream = $this$uploadFile_u24lambda_u2d6.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"errorStream");
            byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        } else {
            InputStream inputStream = $this$uploadFile_u24lambda_u2d6.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        }
        data = byArray;
        return new KeeperHttpResponse(statusCode, data);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalSerializationApi
    private static final Pair<KeeperSecrets, Boolean> fetchAndDecryptSecrets(SecretsManagerOptions options, List<String> recordsFilter) {
        AppData appData;
        KeeperHttpResponse response$iv;
        boolean $i$f$cast;
        TransmissionKey transmissionKey$iv;
        KeyValueStorage storage;
        block17: {
            String errorMessage$iv;
            storage = options.getStorage();
            GetPayload payload = SecretsManager.prepareGetPayload(storage, recordsFilter);
            String path$iv = "get_secret";
            boolean $i$f$postQuery = false;
            String string = options.getStorage().getString(KEY_HOSTNAME);
            if (string == null) {
                throw new Exception("hostname is missing from the storage");
            }
            String hostName$iv = string;
            String url$iv = "https://" + hostName$iv + "/api/rest/sm/v1/" + path$iv;
            while (true) {
                byte[] privateKey$iv$iv;
                transmissionKey$iv = SecretsManager.generateTransmissionKey(options.getStorage());
                KeyValueStorage storage$iv$iv = options.getStorage();
                boolean $i$f$encryptAndSignPayload = false;
                StringFormat $this$encodeToString$iv$iv$iv = (StringFormat)Json.Default;
                boolean $i$f$encodeToString = false;
                SerializersModule $this$serializer$iv$iv$iv$iv = $this$encodeToString$iv$iv$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv$iv, (KType)Reflection.typeOf(GetPayload.class));
                $i$f$cast = false;
                byte[] payloadBytes$iv$iv = CryptoUtils.stringToBytes($this$encodeToString$iv$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv$iv, (Object)payload));
                byte[] encryptedPayload$iv$iv = CryptoUtils.encrypt(payloadBytes$iv$iv, transmissionKey$iv.getKey());
                if (storage$iv$iv.getBytes(KEY_PRIVATE_KEY) == null) {
                    throw new Exception("Private key is missing from the storage");
                }
                byte[] signatureBase$iv$iv = ArraysKt.plus((byte[])transmissionKey$iv.getEncryptedKey(), (byte[])encryptedPayload$iv$iv);
                byte[] signature$iv$iv = CryptoUtils.sign(signatureBase$iv$iv, privateKey$iv$iv);
                EncryptedPayload encryptedPayload$iv = new EncryptedPayload(encryptedPayload$iv$iv, signature$iv$iv);
                KeeperHttpResponse keeperHttpResponse = response$iv = options.getQueryFunction() == null ? SecretsManager.postFunction(url$iv, transmissionKey$iv, encryptedPayload$iv, options.getAllowUnverifiedCertificate()) : (KeeperHttpResponse)options.getQueryFunction().invoke((Object)url$iv, (Object)transmissionKey$iv, (Object)encryptedPayload$iv);
                if (response$iv.getStatusCode() == 200) break block17;
                errorMessage$iv = new String(response$iv.getData(), Charsets.UTF_8);
                try {
                    StringFormat $this$decodeFromString$iv$iv = (StringFormat)nonStrictJson;
                    boolean $i$f$decodeFromString = false;
                    SerializersModule $this$serializer$iv$iv$iv = $this$decodeFromString$iv$iv.getSerializersModule();
                    boolean $i$f$serializer2 = false;
                    KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(KeeperError.class));
                    boolean $i$f$cast2 = false;
                    KeeperError error$iv = (KeeperError)$this$decodeFromString$iv$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv$iv, errorMessage$iv);
                    if (!Intrinsics.areEqual((Object)error$iv.getError(), (Object)"key")) break;
                    options.getStorage().saveString(KEY_SERVER_PUBIC_KEY_ID, String.valueOf(error$iv.getKey_id()));
                }
                catch (Exception error$iv) {
                    // empty catch block
                    break;
                }
            }
            throw new Exception(errorMessage$iv);
        }
        byte[] responseData = response$iv.getData().length == 0 ? response$iv.getData() : CryptoUtils.decrypt(response$iv.getData(), transmissionKey$iv.getKey());
        String jsonString = CryptoUtils.bytesToString(responseData);
        StringFormat $this$decodeFromString$iv = (StringFormat)nonStrictJson;
        boolean $i$f$decodeFromString = false;
        SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(SecretsManagerResponse.class));
        boolean $i$f$cast3 = false;
        SecretsManagerResponse response = (SecretsManagerResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, jsonString);
        boolean justBound = false;
        byte[] appKey = null;
        if (response.getEncryptedAppKey() != null) {
            justBound = true;
            byte[] byArray = storage.getBytes(KEY_CLIENT_KEY);
            if (byArray == null) {
                throw new Exception("Client key is missing from the storage");
            }
            byte[] clientKey = byArray;
            appKey = CryptoUtils.decrypt(response.getEncryptedAppKey(), clientKey);
            storage.saveBytes(KEY_APP_KEY, appKey);
            storage.delete(KEY_CLIENT_KEY);
            storage.delete(KEY_PUBLIC_KEY);
            String string = response.getAppOwnerPublicKey();
            if (string != null) {
                String it = string;
                boolean bl = false;
                storage.saveString(KEY_OWNER_PUBLIC_KEY, it);
            }
        } else {
            byte[] byArray = storage.getBytes(KEY_APP_KEY);
            if (byArray == null) {
                throw new Exception("App key is missing from the storage");
            }
            appKey = byArray;
        }
        List records = new ArrayList();
        if (response.getRecords() != null) {
            Iterable $this$forEach$iv = response.getRecords();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SecretsManagerResponseRecord it = (SecretsManagerResponseRecord)element$iv;
                boolean bl = false;
                byte[] recordKey = CryptoUtils.decrypt(it.getRecordKey(), appKey);
                KeeperRecord decryptedRecord = SecretsManager.decryptRecord(it, recordKey);
                if (decryptedRecord == null) continue;
                records.add(decryptedRecord);
            }
        }
        if (response.getFolders() != null) {
            Iterable $this$forEach$iv = response.getFolders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SecretsManagerResponseFolder folder = (SecretsManagerResponseFolder)element$iv;
                boolean bl = false;
                byte[] folderKey = CryptoUtils.decrypt(folder.getFolderKey(), appKey);
                Iterable $this$forEach$iv2 = folder.getRecords();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SecretsManagerResponseRecord record = (SecretsManagerResponseRecord)element$iv2;
                    boolean bl2 = false;
                    byte[] recordKey = CryptoUtils.decrypt(record.getRecordKey(), folderKey);
                    KeeperRecord decryptedRecord = SecretsManager.decryptRecord(record, recordKey);
                    if (decryptedRecord == null) continue;
                    decryptedRecord.setFolderUid(folder.getFolderUid());
                    decryptedRecord.setFolderKey(folderKey);
                    records.add(decryptedRecord);
                }
            }
        }
        if (response.getAppData() == null) {
            appData = new AppData("", "");
        } else {
            void $this$decodeFromString$iv2;
            StringFormat $i$f$forEach = (StringFormat)nonStrictJson;
            String string$iv = CryptoUtils.bytesToString(CryptoUtils.decrypt(CryptoUtils.webSafe64ToBytes(response.getAppData()), appKey));
            boolean $i$f$decodeFromString2 = false;
            SerializersModule $this$serializer$iv$iv2 = $this$decodeFromString$iv2.getSerializersModule();
            boolean $i$f$serializer3 = false;
            KSerializer $this$cast$iv$iv$iv2 = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv2, (KType)Reflection.typeOf(AppData.class));
            $i$f$cast = false;
            appData = (AppData)$this$decodeFromString$iv2.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv2, string$iv);
        }
        AppData appData2 = appData;
        List<String> warnings = response.getWarnings() == null || response.getWarnings().isEmpty() ? null : response.getWarnings();
        KeeperSecrets secrets = new KeeperSecrets(appData2, records, response.getExpiresOn() != null && response.getExpiresOn() > 0L ? Instant.ofEpochMilli(response.getExpiresOn()) : null, warnings);
        return new Pair((Object)secrets, (Object)justBound);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalSerializationApi
    private static final KeeperRecord decryptRecord(SecretsManagerResponseRecord record, byte[] recordKey) {
        byte[] decryptedRecord = CryptoUtils.decrypt(record.getData(), recordKey);
        List files = new ArrayList();
        if (record.getFiles() != null) {
            Iterable $this$forEach$iv = record.getFiles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$decodeFromString$iv;
                SecretsManagerResponseFile it = (SecretsManagerResponseFile)element$iv;
                boolean bl = false;
                byte[] fileKey = CryptoUtils.decrypt(it.getFileKey(), recordKey);
                byte[] decryptedFile = CryptoUtils.decrypt(it.getData(), fileKey);
                StringFormat stringFormat = (StringFormat)Json.Default;
                String string$iv = CryptoUtils.bytesToString(decryptedFile);
                boolean $i$f$decodeFromString = false;
                SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(KeeperFileData.class));
                boolean $i$f$cast = false;
                files.add(new KeeperFile(fileKey, it.getFileUid(), (KeeperFileData)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv), it.getUrl(), it.getThumbnailUrl()));
            }
        }
        try {
            void $this$decodeFromString$iv;
            StringFormat $i$f$forEach = (StringFormat)Json.Default;
            String string$iv = CryptoUtils.bytesToString(decryptedRecord);
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(KeeperRecordData.class));
            boolean $i$f$cast = false;
            KeeperRecordData recordData = (KeeperRecordData)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, string$iv);
            return new KeeperRecord(recordKey, record.getRecordUid(), null, null, recordData, record.getRevision(), files);
        }
        catch (Exception e) {
            System.out.println((Object)("Skipped record " + record.getRecordUid() + "\n Error parsing record type - KSM SDK is behind/ahead of record/field type definitions. Please upgrade to latest version. If you need assistance please email support@keepersecurity.com"));
            System.out.println((Object)e.getMessage());
            return null;
        }
    }

    private static final GetPayload prepareGetPayload(KeyValueStorage storage, List<String> recordsFilter) {
        String string = storage.getString(KEY_CLIENT_ID);
        if (string == null) {
            throw new Exception("Client Id is missing from the configuration");
        }
        String clientId = string;
        GetPayload payload = new GetPayload(KEEPER_CLIENT_VERSION, clientId, null, null);
        byte[] appKey = storage.getBytes(KEY_APP_KEY);
        if (appKey == null) {
            byte[] byArray = storage.getBytes(KEY_PUBLIC_KEY);
            if (byArray == null) {
                throw new Exception("Public key is missing from the storage");
            }
            byte[] publicKey = byArray;
            payload.setPublicKey(CryptoUtils.bytesToBase64(publicKey));
        }
        if (!((Collection)recordsFilter).isEmpty()) {
            payload.setRequestedRecords(recordsFilter);
        }
        return payload;
    }

    @ExperimentalSerializationApi
    private static final DeletePayload prepareDeletePayload(KeyValueStorage storage, List<String> recordUids) {
        String string = storage.getString(KEY_CLIENT_ID);
        if (string == null) {
            throw new Exception("Client Id is missing from the configuration");
        }
        String clientId = string;
        return new DeletePayload(KEEPER_CLIENT_VERSION, clientId, recordUids);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalSerializationApi
    private static final UpdatePayload prepareUpdatePayload(KeyValueStorage storage, KeeperRecord record, UpdateTransactionType transactionType) {
        void $this$encodeToString$iv;
        String string = storage.getString(KEY_CLIENT_ID);
        if (string == null) {
            throw new Exception("Client Id is missing from the configuration");
        }
        String clientId = string;
        StringFormat stringFormat = (StringFormat)Json.Default;
        KeeperRecordData value$iv = record.getData();
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(KeeperRecordData.class));
        boolean $i$f$cast = false;
        byte[] recordBytes = CryptoUtils.stringToBytes($this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)value$iv));
        byte[] encryptedRecord = CryptoUtils.encrypt(recordBytes, record.getRecordKey());
        return new UpdatePayload(KEEPER_CLIENT_VERSION, clientId, record.getRecordUid(), CryptoUtils.webSafe64FromBytes(encryptedRecord), record.getRevision(), transactionType);
    }

    static /* synthetic */ UpdatePayload prepareUpdatePayload$default(KeyValueStorage keyValueStorage, KeeperRecord keeperRecord, UpdateTransactionType updateTransactionType, int n, Object object) {
        if ((n & 4) != 0) {
            updateTransactionType = null;
        }
        return SecretsManager.prepareUpdatePayload(keyValueStorage, keeperRecord, updateTransactionType);
    }

    @ExperimentalSerializationApi
    private static final CompleteTransactionPayload prepareCompleteTransactionPayload(KeyValueStorage storage, String recordUid) {
        String string = storage.getString(KEY_CLIENT_ID);
        if (string == null) {
            throw new Exception("Client Id is missing from the configuration");
        }
        String clientId = string;
        return new CompleteTransactionPayload(KEEPER_CLIENT_VERSION, clientId, recordUid);
    }

    @ExperimentalSerializationApi
    private static final CreatePayload prepareCreatePayload(KeyValueStorage storage, String folderUid, KeeperRecordData recordData, KeeperSecrets secrets) {
        KeeperRecord recordFromFolder;
        Object v2;
        byte[] ownerPublicKey;
        String clientId;
        block4: {
            String string = storage.getString(KEY_CLIENT_ID);
            if (string == null) {
                throw new Exception("Client Id is missing from the configuration");
            }
            clientId = string;
            byte[] byArray = storage.getBytes(KEY_OWNER_PUBLIC_KEY);
            if (byArray == null) {
                throw new Exception("Application owner public key is missing from the configuration");
            }
            ownerPublicKey = byArray;
            Iterable iterable = secrets.getRecords();
            for (Object t : iterable) {
                KeeperRecord it = (KeeperRecord)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFolderUid(), (Object)folderUid)) continue;
                v2 = t;
                break block4;
            }
            v2 = null;
        }
        KeeperRecord keeperRecord = recordFromFolder = (KeeperRecord)v2;
        if ((byte[])(keeperRecord != null ? keeperRecord.getFolderKey() : null) == null) {
            throw new Exception("Unable to create record - folder key for " + folderUid + " not found");
        }
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(KeeperRecordData.class));
        boolean $i$f$cast = false;
        byte[] recordBytes = CryptoUtils.stringToBytes($this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)recordData));
        byte[] recordKey = CryptoUtils.getRandomBytes(32);
        byte[] recordUid = CryptoUtils.getRandomBytes(16);
        byte[] encryptedRecord = CryptoUtils.encrypt(recordBytes, recordKey);
        byte[] encryptedRecordKey = CryptoUtils.publicEncrypt(recordKey, ownerPublicKey);
        byte[] byArray = recordFromFolder.getFolderKey();
        Intrinsics.checkNotNull((Object)byArray);
        byte[] encryptedFolderKey = CryptoUtils.encrypt(recordKey, byArray);
        return new CreatePayload(KEEPER_CLIENT_VERSION, clientId, CryptoUtils.webSafe64FromBytes(recordUid), CryptoUtils.bytesToBase64(encryptedRecordKey), folderUid, CryptoUtils.bytesToBase64(encryptedFolderKey), CryptoUtils.webSafe64FromBytes(encryptedRecord));
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalSerializationApi
    private static final FileUploadPayloadAndFile prepareFileUploadPayload(KeyValueStorage storage, KeeperRecord ownerRecord, KeeperFileUpload file) {
        void $this$encodeToString$iv;
        Object v2;
        Object[] this_$iv;
        byte[] encryptedFileData;
        byte[] encryptedLinkKey;
        byte[] encryptedFileRecordKey;
        byte[] encryptedFileRecord;
        String fileRecordUid;
        String clientId;
        block6: {
            String string = storage.getString(KEY_CLIENT_ID);
            if (string == null) {
                throw new Exception("Client Id is missing from the configuration");
            }
            clientId = string;
            byte[] byArray = storage.getBytes(KEY_OWNER_PUBLIC_KEY);
            if (byArray == null) {
                throw new Exception("Application owner public key is missing from the configuration");
            }
            byte[] ownerPublicKey = byArray;
            KeeperFileData fileData = new KeeperFileData(file.getTitle(), file.getName(), file.getType(), file.getData().length, Instant.now().toEpochMilli());
            StringFormat $this$encodeToString$iv2 = (StringFormat)Json.Default;
            boolean $i$f$encodeToString = false;
            SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv2.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(KeeperFileData.class));
            boolean $i$f$cast = false;
            byte[] fileRecordBytes = CryptoUtils.stringToBytes($this$encodeToString$iv2.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)fileData));
            byte[] fileRecordKey = CryptoUtils.getRandomBytes(32);
            fileRecordUid = CryptoUtils.webSafe64FromBytes(CryptoUtils.getRandomBytes(16));
            encryptedFileRecord = CryptoUtils.encrypt(fileRecordBytes, fileRecordKey);
            encryptedFileRecordKey = CryptoUtils.publicEncrypt(fileRecordKey, ownerPublicKey);
            encryptedLinkKey = CryptoUtils.encrypt(fileRecordKey, ownerRecord.getRecordKey());
            encryptedFileData = CryptoUtils.encrypt(file.getData(), fileRecordKey);
            this_$iv = ownerRecord.getData();
            boolean $i$f$getField = false;
            Iterable iterable = CollectionsKt.plus((Collection)this_$iv.getFields(), this_$iv.getCustom());
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object x$iv = t = iterator.next();
                boolean bl = false;
                if (!(x$iv instanceof FileRef)) continue;
                v2 = t;
                break block6;
            }
            v2 = null;
        }
        if (v2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.keepersecurity.secretsManager.core.FileRef");
        }
        FileRef fileRef = v2;
        if (fileRef == null) {
            this_$iv = new String[]{fileRecordUid};
            ownerRecord.getData().getFields().add(new FileRef(null, null, CollectionsKt.mutableListOf((Object[])this_$iv), 3, null));
        } else {
            fileRef.getValue().add(fileRecordUid);
        }
        StringFormat $i$f$getField = (StringFormat)Json.Default;
        KeeperRecordData value$iv = ownerRecord.getData();
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(KeeperRecordData.class));
        boolean $i$f$cast = false;
        byte[] ownerRecordBytes = CryptoUtils.stringToBytes($this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)value$iv));
        byte[] encryptedOwnerRecord = CryptoUtils.encrypt(ownerRecordBytes, ownerRecord.getRecordKey());
        return new FileUploadPayloadAndFile(new FileUploadPayload(KEEPER_CLIENT_VERSION, clientId, fileRecordUid, CryptoUtils.bytesToBase64(encryptedFileRecordKey), CryptoUtils.webSafe64FromBytes(encryptedFileRecord), ownerRecord.getRecordUid(), CryptoUtils.webSafe64FromBytes(encryptedOwnerRecord), CryptoUtils.bytesToBase64(encryptedLinkKey), encryptedFileData.length), encryptedFileData);
    }

    @NotNull
    public static final KeeperHttpResponse cachingPostFunction(@NotNull String url, @NotNull TransmissionKey transmissionKey, @NotNull EncryptedPayload payload) {
        KeeperHttpResponse keeperHttpResponse;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)transmissionKey, (String)"transmissionKey");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        try {
            KeeperHttpResponse response = SecretsManager.postFunction(url, transmissionKey, payload, false);
            if (response.getStatusCode() == 200) {
                LocalConfigStorageKt.saveCachedValue(ArraysKt.plus((byte[])transmissionKey.getKey(), (byte[])response.getData()));
            }
        }
        catch (Exception e) {
            byte[] cachedData;
            byte[] byArray = cachedData = LocalConfigStorageKt.getCachedValue();
            int n = 0;
            int n2 = 32;
            byte[] cachedTransmissionKey = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            transmissionKey.setKey(cachedTransmissionKey);
            byte[] byArray2 = cachedData;
            n2 = 32;
            int n3 = cachedData.length;
            byte[] data = ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3);
            keeperHttpResponse = new KeeperHttpResponse(200, data);
        }
        return keeperHttpResponse;
    }

    @NotNull
    public static final KeeperHttpResponse postFunction(@NotNull String url, @NotNull TransmissionKey transmissionKey, @NotNull EncryptedPayload payload, boolean allowUnverifiedCertificate) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)transmissionKey, (String)"transmissionKey");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        int statusCode = 0;
        byte[] data = null;
        URLConnection uRLConnection = new URL(url).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        }
        HttpsURLConnection $this$postFunction_u24lambda_u2d13 = (HttpsURLConnection)uRLConnection;
        boolean bl = false;
        if (allowUnverifiedCertificate) {
            $this$postFunction_u24lambda_u2d13.setSSLSocketFactory(SecretsManager.trustAllSocketFactory());
        }
        $this$postFunction_u24lambda_u2d13.setRequestMethod("POST");
        $this$postFunction_u24lambda_u2d13.setDoOutput(true);
        $this$postFunction_u24lambda_u2d13.setRequestProperty("PublicKeyId", String.valueOf(transmissionKey.getPublicKeyId()));
        $this$postFunction_u24lambda_u2d13.setRequestProperty("TransmissionKey", CryptoUtils.bytesToBase64(transmissionKey.getEncryptedKey()));
        $this$postFunction_u24lambda_u2d13.setRequestProperty("Authorization", "Signature " + CryptoUtils.bytesToBase64(payload.getSignature()));
        $this$postFunction_u24lambda_u2d13.getOutputStream().write(payload.getPayload());
        $this$postFunction_u24lambda_u2d13.getOutputStream().flush();
        statusCode = $this$postFunction_u24lambda_u2d13.getResponseCode();
        if ($this$postFunction_u24lambda_u2d13.getErrorStream() != null) {
            InputStream inputStream = $this$postFunction_u24lambda_u2d13.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"errorStream");
            byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        } else {
            InputStream inputStream = $this$postFunction_u24lambda_u2d13.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            byArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        }
        data = byArray;
        return new KeeperHttpResponse(statusCode, data);
    }

    public static final int getKeyId() {
        return keyId;
    }

    public static final void setKeyId(int n) {
        keyId = n;
    }

    private static /* synthetic */ void getKeeperPublicKeys$annotations() {
    }

    private static final TransmissionKey generateTransmissionKey(KeyValueStorage storage) {
        byte[] transmissionKey = TestStubs.INSTANCE.transmissionKeyStubReady() ? (byte[])TestStubs.INSTANCE.getTransmissionKeyStub().invoke() : CryptoUtils.getRandomBytes(32);
        String string = storage.getString(KEY_SERVER_PUBIC_KEY_ID);
        int keyNumber = string != null ? Integer.parseInt(string) : 7;
        byte[] byArray = keeperPublicKeys.get(keyNumber);
        if (byArray == null) {
            throw new Exception("Key number " + keyNumber + " is not supported");
        }
        byte[] keeperPublicKey = byArray;
        byte[] encryptedKey = CryptoUtils.publicEncrypt(transmissionKey, keeperPublicKey);
        return new TransmissionKey(keyNumber, transmissionKey, encryptedKey);
    }

    @ExperimentalSerializationApi
    private static final /* synthetic */ <T> EncryptedPayload encryptAndSignPayload(KeyValueStorage storage, TransmissionKey transmissionKey, T payload) {
        boolean $i$f$encryptAndSignPayload = false;
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, null);
        boolean $i$f$cast = false;
        byte[] payloadBytes = CryptoUtils.stringToBytes($this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, payload));
        byte[] encryptedPayload = CryptoUtils.encrypt(payloadBytes, transmissionKey.getKey());
        byte[] byArray = storage.getBytes(KEY_PRIVATE_KEY);
        if (byArray == null) {
            throw new Exception("Private key is missing from the storage");
        }
        byte[] privateKey = byArray;
        byte[] signatureBase = ArraysKt.plus((byte[])transmissionKey.getEncryptedKey(), (byte[])encryptedPayload);
        byte[] signature = CryptoUtils.sign(signatureBase, privateKey);
        return new EncryptedPayload(encryptedPayload, signature);
    }

    @ExperimentalSerializationApi
    private static final /* synthetic */ <T> byte[] postQuery(SecretsManagerOptions options, String path, T payload) {
        KeeperHttpResponse response;
        TransmissionKey transmissionKey;
        block6: {
            String errorMessage;
            boolean $i$f$postQuery = false;
            String string = options.getStorage().getString(KEY_HOSTNAME);
            if (string == null) {
                throw new Exception("hostname is missing from the storage");
            }
            String hostName = string;
            String url = "https://" + hostName + "/api/rest/sm/v1/" + path;
            while (true) {
                byte[] privateKey$iv;
                transmissionKey = SecretsManager.generateTransmissionKey(options.getStorage());
                KeyValueStorage storage$iv = options.getStorage();
                boolean $i$f$encryptAndSignPayload = false;
                StringFormat $this$encodeToString$iv$iv = (StringFormat)Json.Default;
                boolean $i$f$encodeToString = false;
                SerializersModule $this$serializer$iv$iv$iv = $this$encodeToString$iv$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, null);
                boolean $i$f$cast = false;
                byte[] payloadBytes$iv = CryptoUtils.stringToBytes($this$encodeToString$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv, payload));
                byte[] encryptedPayload$iv = CryptoUtils.encrypt(payloadBytes$iv, transmissionKey.getKey());
                if (storage$iv.getBytes(KEY_PRIVATE_KEY) == null) {
                    throw new Exception("Private key is missing from the storage");
                }
                byte[] signatureBase$iv = ArraysKt.plus((byte[])transmissionKey.getEncryptedKey(), (byte[])encryptedPayload$iv);
                byte[] signature$iv = CryptoUtils.sign(signatureBase$iv, privateKey$iv);
                EncryptedPayload encryptedPayload = new EncryptedPayload(encryptedPayload$iv, signature$iv);
                KeeperHttpResponse keeperHttpResponse = response = options.getQueryFunction() == null ? SecretsManager.postFunction(url, transmissionKey, encryptedPayload, options.getAllowUnverifiedCertificate()) : (KeeperHttpResponse)options.getQueryFunction().invoke((Object)url, (Object)transmissionKey, (Object)encryptedPayload);
                if (response.getStatusCode() == 200) break block6;
                errorMessage = new String(response.getData(), Charsets.UTF_8);
                try {
                    StringFormat $this$decodeFromString$iv = (StringFormat)nonStrictJson;
                    boolean $i$f$decodeFromString = false;
                    SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                    boolean $i$f$serializer2 = false;
                    KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(KeeperError.class));
                    boolean $i$f$cast2 = false;
                    KeeperError error = (KeeperError)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, errorMessage);
                    if (!Intrinsics.areEqual((Object)error.getError(), (Object)"key")) break;
                    options.getStorage().saveString(KEY_SERVER_PUBIC_KEY_ID, String.valueOf(error.getKey_id()));
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
            throw new Exception(errorMessage);
        }
        if (response.getData().length == 0) {
            return response.getData();
        }
        return CryptoUtils.decrypt(response.getData(), transmissionKey.getKey());
    }

    private static final SSLSocketFactory trustAllSocketFactory() {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){
            @NotNull
            private final X509Certificate[] AcceptedIssuers;
            {
                this.AcceptedIssuers = new X509Certificate[0];
            }

            public void checkClientTrusted(@Nullable X509Certificate[] certs, @Nullable String authType) {
            }

            public void checkServerTrusted(@Nullable X509Certificate[] certs, @Nullable String authType) {
            }

            @NotNull
            public X509Certificate[] getAcceptedIssuers() {
                return this.AcceptedIssuers;
            }
        }};
        TrustManager[] trustAllCerts2 = trustManagerArray;
        SSLContext sslContext = SSLContext.getInstance("TLS");
        try {
            sslContext.init(null, trustAllCerts2, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"sslContext.socketFactory");
        return sSLSocketFactory;
    }

    @JvmOverloads
    public static final void initializeStorage(@NotNull KeyValueStorage storage, @NotNull String oneTimeToken) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)oneTimeToken, (String)"oneTimeToken");
        SecretsManager.initializeStorage$default(storage, oneTimeToken, null, 4, null);
    }

    @ExperimentalSerializationApi
    @JvmOverloads
    @NotNull
    public static final KeeperSecrets getSecrets(@NotNull SecretsManagerOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return SecretsManager.getSecrets$default(options, null, 2, null);
    }

    @ExperimentalSerializationApi
    @JvmOverloads
    @NotNull
    public static final String createSecret(@NotNull SecretsManagerOptions options, @NotNull String folderUid, @NotNull KeeperRecordData recordData) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)folderUid, (String)"folderUid");
        Intrinsics.checkNotNullParameter((Object)recordData, (String)"recordData");
        return SecretsManager.createSecret$default(options, folderUid, recordData, null, 8, null);
    }

    private static final Boolean testSecureRandom$lambda-0() {
        SecureRandom secureRandom = SecureRandom.getInstanceStrong();
        secureRandom.nextInt();
        return true;
    }

    public static final /* synthetic */ void access$testSecureRandom() {
        SecretsManager.testSecureRandom();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        SecureRandomTestResult = "";
        nonStrictJson = JsonKt.Json$default(null, (Function1)nonStrictJson.1.INSTANCE, (int)1, null);
        keyId = 7;
        Object[] objectArray = new String[]{"BK9w6TZFxE6nFNbMfIpULCup2a8xc6w2tUTABjxny7yFmxW0dAEojwC6j6zb5nTlmb1dAx8nwo3qF7RPYGmloRM", "BKnhy0obglZJK-igwthNLdknoSXRrGB-mvFRzyb_L-DKKefWjYdFD2888qN1ROczz4n3keYSfKz9Koj90Z6w_tQ", "BAsPQdCpLIGXdWNLdAwx-3J5lNqUtKbaOMV56hUj8VzxE2USLHuHHuKDeno0ymJt-acxWV1xPlBfNUShhRTR77g", "BNYIh_Sv03nRZUUJveE8d2mxKLIDXv654UbshaItHrCJhd6cT7pdZ_XwbdyxAOCWMkBb9AZ4t1XRCsM8-wkEBRg", "BA6uNfeYSvqagwu4TOY6wFK4JyU5C200vJna0lH4PJ-SzGVXej8l9dElyQ58_ljfPs5Rq6zVVXpdDe8A7Y3WRhk", "BMjTIlXfohI8TDymsHxo0DqYysCy7yZGJ80WhgOBR4QUd6LBDA6-_318a-jCGW96zxXKMm8clDTKpE8w75KG-FY", "BJBDU1P1H21IwIdT2brKkPqbQR0Zl0TIHf7Bz_OO9jaNgIwydMkxt4GpBmkYoprZ_DHUGOrno2faB7pmTR7HhuI", "BJFF8j-dH7pDEw_U347w2CBM6xYM8Dk5fPPAktjib-opOqzvvbsER-WDHM4ONCSBf9O_obAHzCyygxmtpktDuiE", "BDKyWBvLbyZ-jMueORl3JwJnnEpCiZdN7yUvT0vOyjwpPBCDf6zfL4RWzvSkhAAFnwOni_1tQSl8dfXHbXqXsQ8", "BDXyZZnrl0tc2jdC5I61JjwkjK2kr7uet9tZjt8StTiJTAQQmnVOYBgbtP08PWDbecxnHghx3kJ8QXq1XE68y8c", "BFX68cb97m9_sweGdOVavFM3j5ot6gveg6xT4BtGahfGhKib-zdZyO9pwvv1cBda9ahkSzo1BQ4NVXp9qRyqVGU"};
        Iterable $this$associateBy$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            String string = (String)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            int n = keyId;
            keyId = n + 1;
            String it = (String)element$iv$iv;
            Integer n2 = n;
            boolean bl2 = false;
            byte[] byArray = CryptoUtils.webSafe64ToBytes(it);
            map.put(n2, byArray);
        }
        keeperPublicKeys = destination$iv$iv;
    }
}

