/*
 * Decompiled with CFR 0.152.
 */
package com.keepersecurity.secretsManager.core;

import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/keepersecurity/secretsManager/core/KeeperCryptoParameters;", "", "()V", "ecParameterSpec", "Ljava/security/spec/ECParameterSpec;", "getEcParameterSpec$core", "()Ljava/security/spec/ECParameterSpec;", "keyFactory", "Ljava/security/KeyFactory;", "getKeyFactory$core", "()Ljava/security/KeyFactory;", "keyGen", "Ljava/security/KeyPairGenerator;", "getKeyGen$core", "()Ljava/security/KeyPairGenerator;", "provider", "Ljava/security/Provider;", "getProvider$core", "()Ljava/security/Provider;", "sha256", "Ljava/security/MessageDigest;", "getSha256$core", "()Ljava/security/MessageDigest;", "core"})
public final class KeeperCryptoParameters {
    @NotNull
    public static final KeeperCryptoParameters INSTANCE;
    @Nullable
    private static final Provider provider;
    @NotNull
    private static final KeyFactory keyFactory;
    @NotNull
    private static final KeyPairGenerator keyGen;
    @NotNull
    private static final ECParameterSpec ecParameterSpec;
    @NotNull
    private static final MessageDigest sha256;

    private KeeperCryptoParameters() {
    }

    @Nullable
    public final Provider getProvider$core() {
        return provider;
    }

    @NotNull
    public final KeyFactory getKeyFactory$core() {
        return keyFactory;
    }

    @NotNull
    public final KeyPairGenerator getKeyGen$core() {
        return keyGen;
    }

    @NotNull
    public final ECParameterSpec getEcParameterSpec$core() {
        return ecParameterSpec;
    }

    @NotNull
    public final MessageDigest getSha256$core() {
        return sha256;
    }

    static {
        MessageDigest messageDigest;
        KeyPairGenerator keyPairGenerator;
        KeyFactory keyFactory;
        INSTANCE = new KeeperCryptoParameters();
        Provider bcProvider = Security.getProvider("BCFIPS");
        if (bcProvider == null) {
            bcProvider = Security.getProvider("BC");
        }
        provider = bcProvider;
        if (provider == null) {
            KeyFactory keyFactory2 = KeyFactory.getInstance("EC");
            keyFactory = keyFactory2;
            Intrinsics.checkNotNullExpressionValue((Object)keyFactory2, (String)"getInstance(\"EC\")");
        } else {
            KeyFactory keyFactory3 = KeyFactory.getInstance("EC", provider);
            keyFactory = keyFactory3;
            Intrinsics.checkNotNullExpressionValue((Object)keyFactory3, (String)"getInstance(\"EC\", provider)");
        }
        KeeperCryptoParameters.keyFactory = keyFactory;
        ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec("secp256r1");
        AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
        parameters.init(ecGenParameterSpec);
        ECParameterSpec eCParameterSpec = parameters.getParameterSpec(ECParameterSpec.class);
        Intrinsics.checkNotNullExpressionValue((Object)eCParameterSpec, (String)"parameters.getParameterS\u2026arameterSpec::class.java)");
        ecParameterSpec = eCParameterSpec;
        if (provider == null) {
            KeyPairGenerator keyPairGenerator2 = KeyPairGenerator.getInstance("EC");
            keyPairGenerator = keyPairGenerator2;
            Intrinsics.checkNotNullExpressionValue((Object)keyPairGenerator2, (String)"getInstance(\"EC\")");
        } else {
            KeyPairGenerator keyPairGenerator3 = KeyPairGenerator.getInstance("EC", provider);
            keyPairGenerator = keyPairGenerator3;
            Intrinsics.checkNotNullExpressionValue((Object)keyPairGenerator3, (String)"getInstance(\"EC\", provider)");
        }
        keyGen = keyPairGenerator;
        keyGen.initialize(ecGenParameterSpec);
        if (provider == null) {
            MessageDigest messageDigest2 = MessageDigest.getInstance("SHA-256");
            messageDigest = messageDigest2;
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest2, (String)"getInstance(\"SHA-256\")");
        } else {
            MessageDigest messageDigest3 = MessageDigest.getInstance("SHA-256", provider);
            messageDigest = messageDigest3;
            Intrinsics.checkNotNullExpressionValue((Object)messageDigest3, (String)"getInstance(\"SHA-256\", provider)");
        }
        sha256 = messageDigest;
    }
}

