/*
 * Decompiled with CFR 0.152.
 */
package com.keepersecurity.secretsManager.core;

import com.keepersecurity.secretsManager.core.KeeperCryptoParameters;
import com.keepersecurity.secretsManager.core.TotpCode;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u000fH\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u000fH\u0000\u001a\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\b\u0010\u001b\u001a\u00020\u001cH\u0000\u001aQ\u0010\u001d\u001a\u00020\u00012\b\b\u0002\u0010\u001e\u001a\u00020\u00062\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010#\u001a\u00020\u0001H\u0007\u00a2\u0006\u0002\u0010$\u001a \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0000\u001a\u0018\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u0019\u001a\u00020+H\u0000\u001a\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020\u0006H\u0000\u001a\u001c\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u00012\b\b\u0002\u00101\u001a\u000202H\u0007\u001a\u0018\u00103\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u0001H\u0000\u001a\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u000fH\u0000\u001a\u0010\u00108\u001a\u00020\u001a2\u0006\u00109\u001a\u00020\u000fH\u0000\u001a\u0018\u0010:\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0000\u001a\u0018\u0010;\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0000\u001a\u001c\u0010<\u001a\u00020\u00012\b\b\u0002\u0010=\u001a\u00020\u00062\b\b\u0002\u0010>\u001a\u00020\u0001H\u0000\u001a\u0018\u0010?\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0000\u001a\u0010\u0010@\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0001H\u0000\u001a\u0010\u0010A\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u000fH\u0000\u001a\u0010\u0010B\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006C"}, d2={"AsciiDigits", "", "AsciiLowercase", "AsciiSpecialCharacters", "AsciiUppercase", "DEFAULT_DIGITS", "", "DEFAULT_TIME_STEP", "DefaultPasswordLength", "base32Alphabet", "rxBase32Alphabet", "Lkotlin/text/Regex;", "getRxBase32Alphabet", "()Lkotlin/text/Regex;", "base32ToBytes", "", "base32Text", "base64ToBytes", "data", "bytesToBase64", "bytesToString", "decrypt", "key", "encrypt", "extractPublicRaw", "publicKey", "Ljava/security/PublicKey;", "generateKeyPair", "Ljava/security/KeyPair;", "generatePassword", "minLength", "lowercase", "uppercase", "digits", "specialCharacters", "specialCharacterSet", "(ILjava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;)Ljava/lang/String;", "getCipher", "Ljavax/crypto/Cipher;", "mode", "iv", "getEciesSymmetricKey", "privateKey", "Ljava/security/Key;", "getRandomBytes", "length", "getTotpCode", "Lcom/keepersecurity/secretsManager/core/TotpCode;", "url", "unixTimeSeconds", "", "hash", "tag", "importPrivateKey", "Ljava/security/interfaces/ECPrivateKey;", "privateKeyDer", "importPublicKey", "rawBytes", "privateDecrypt", "publicEncrypt", "randomSample", "sampleLength", "sampleString", "sign", "stringToBytes", "webSafe64FromBytes", "webSafe64ToBytes", "core"})
@JvmName(name="CryptoUtils")
public final class CryptoUtils {
    public static final int DEFAULT_TIME_STEP = 30;
    public static final int DEFAULT_DIGITS = 6;
    @NotNull
    public static final String base32Alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    @NotNull
    private static final Regex rxBase32Alphabet = new Regex("^[A-Z2-7]+$");
    public static final int DefaultPasswordLength = 32;
    @NotNull
    public static final String AsciiLowercase = "abcdefghijklmnopqrstuvwxyz";
    @NotNull
    public static final String AsciiUppercase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    @NotNull
    public static final String AsciiDigits = "0123456789";
    @NotNull
    public static final String AsciiSpecialCharacters = "\"!@#$%()+;<>=?[]{}^.,";

    @NotNull
    public static final String bytesToBase64(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = Base64.getEncoder().encodeToString(data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEncoder().encodeToString(data)");
        return string;
    }

    @NotNull
    public static final byte[] base64ToBytes(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] byArray = Base64.getDecoder().decode(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getDecoder().decode(data)");
        return byArray;
    }

    @NotNull
    public static final byte[] webSafe64ToBytes(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        byte[] byArray = Base64.getUrlDecoder().decode(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getUrlDecoder().decode(data)");
        return byArray;
    }

    @NotNull
    public static final String webSafe64FromBytes(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = Base64.getUrlEncoder().withoutPadding().encodeToString(data);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrlEncoder().withoutP\u2026ng().encodeToString(data)");
        return string;
    }

    @NotNull
    public static final String bytesToString(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new String(data, Charsets.UTF_8);
    }

    @NotNull
    public static final byte[] stringToBytes(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return StringsKt.encodeToByteArray((String)data);
    }

    @NotNull
    public static final byte[] getRandomBytes(int length) {
        SecureRandom secureRandom = SecureRandom.getInstanceStrong();
        byte[] bytes = new byte[length];
        secureRandom.nextBytes(bytes);
        return bytes;
    }

    @NotNull
    public static final KeyPair generateKeyPair() {
        KeyPair keyPair = KeeperCryptoParameters.INSTANCE.getKeyGen$core().genKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"KeeperCryptoParameters.keyGen.genKeyPair()");
        return keyPair;
    }

    @NotNull
    public static final byte[] hash(@NotNull byte[] data, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Mac mac = KeeperCryptoParameters.INSTANCE.getProvider$core() == null ? Mac.getInstance("HmacSHA512") : Mac.getInstance("HmacSHA512", KeeperCryptoParameters.INSTANCE.getProvider$core());
        mac.init(new SecretKeySpec(data, "HmacSHA512"));
        byte[] byArray = mac.doFinal(CryptoUtils.stringToBytes(tag));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"mac.doFinal(stringToBytes(tag))");
        return byArray;
    }

    @NotNull
    public static final Cipher getCipher(int mode, @NotNull byte[] iv, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Cipher cipher = KeeperCryptoParameters.INSTANCE.getProvider$core() == null ? Cipher.getInstance("AES/GCM/NoPadding") : Cipher.getInstance("AES/GCM/NoPadding", KeeperCryptoParameters.INSTANCE.getProvider$core());
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        GCMParameterSpec gcmParameterSpec = new GCMParameterSpec(128, iv);
        cipher.init(mode, (Key)keySpec, gcmParameterSpec);
        Intrinsics.checkNotNullExpressionValue((Object)cipher, (String)"cipher");
        return cipher;
    }

    @NotNull
    public static final byte[] encrypt(@NotNull byte[] data, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] iv = CryptoUtils.getRandomBytes(12);
        Cipher cipher = CryptoUtils.getCipher(1, iv, key);
        byte[] encryptedData = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)encryptedData, (String)"encryptedData");
        return ArraysKt.plus((byte[])iv, (byte[])encryptedData);
    }

    @NotNull
    public static final byte[] decrypt(@NotNull byte[] data, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        byte[] byArray = data;
        int n = 0;
        int n2 = 12;
        byte[] iv = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
        Cipher cipher = CryptoUtils.getCipher(2, iv, key);
        byte[] byArray2 = cipher.doFinal(data, iv.length, data.length - iv.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"cipher.doFinal(data, iv.size, data.size - iv.size)");
        return byArray2;
    }

    @NotNull
    public static final byte[] decrypt(@NotNull String data, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return CryptoUtils.decrypt(CryptoUtils.base64ToBytes(data), key);
    }

    @NotNull
    public static final ECPrivateKey importPrivateKey(@NotNull byte[] privateKeyDer) {
        Intrinsics.checkNotNullParameter((Object)privateKeyDer, (String)"privateKeyDer");
        PrivateKey privateKey = KeeperCryptoParameters.INSTANCE.getKeyFactory$core().generatePrivate(new PKCS8EncodedKeySpec(privateKeyDer));
        if (privateKey == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.security.interfaces.ECPrivateKey");
        }
        return (ECPrivateKey)privateKey;
    }

    @NotNull
    public static final PublicKey importPublicKey(@NotNull byte[] rawBytes) {
        Intrinsics.checkNotNullParameter((Object)rawBytes, (String)"rawBytes");
        byte[] byArray = rawBytes;
        int n = 1;
        int n2 = 33;
        BigInteger bigInteger = new BigInteger(1, ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
        byArray = rawBytes;
        n = 33;
        n2 = 65;
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(new ECPoint(bigInteger, new BigInteger(1, ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2))), KeeperCryptoParameters.INSTANCE.getEcParameterSpec$core());
        PublicKey publicKey = KeeperCryptoParameters.INSTANCE.getKeyFactory$core().generatePublic(pubKeySpec);
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"KeeperCryptoParameters.k\u2026eneratePublic(pubKeySpec)");
        return publicKey;
    }

    @NotNull
    public static final byte[] getEciesSymmetricKey(@NotNull Key privateKey, @NotNull Key publicKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        KeyAgreement ka = KeeperCryptoParameters.INSTANCE.getProvider$core() == null ? KeyAgreement.getInstance("ECDH") : KeyAgreement.getInstance("ECDH", KeeperCryptoParameters.INSTANCE.getProvider$core());
        ka.init(privateKey);
        ka.doPhase(publicKey, true);
        byte[] commonSecret = ka.generateSecret();
        byte[] byArray = KeeperCryptoParameters.INSTANCE.getSha256$core().digest(commonSecret);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"KeeperCryptoParameters.sha256.digest(commonSecret)");
        return byArray;
    }

    @NotNull
    public static final byte[] extractPublicRaw(@NotNull PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        byte[] byArray = publicKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"publicKey.encoded");
        return CollectionsKt.toByteArray((Collection)ArraysKt.takeLast((byte[])byArray, (int)65));
    }

    @NotNull
    public static final byte[] publicEncrypt(@NotNull byte[] data, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        KeyPair ephemeralKeyPair = KeeperCryptoParameters.INSTANCE.getKeyGen$core().genKeyPair();
        PublicKey recipientPublicKey = CryptoUtils.importPublicKey(key);
        PrivateKey privateKey = ephemeralKeyPair.getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"ephemeralKeyPair.private");
        byte[] symmetricKey = CryptoUtils.getEciesSymmetricKey(privateKey, recipientPublicKey);
        byte[] encryptedData = CryptoUtils.encrypt(data, symmetricKey);
        PublicKey publicKey = ephemeralKeyPair.getPublic();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"ephemeralKeyPair.public");
        return ArraysKt.plus((byte[])CryptoUtils.extractPublicRaw(publicKey), (byte[])encryptedData);
    }

    @NotNull
    public static final byte[] privateDecrypt(@NotNull byte[] data, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ECPrivateKey privateKey = CryptoUtils.importPrivateKey(key);
        byte[] byArray = data;
        int n = 0;
        int n2 = 65;
        PublicKey publicKey = CryptoUtils.importPublicKey(ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
        byte[] symmetricKey = CryptoUtils.getEciesSymmetricKey(privateKey, publicKey);
        byte[] byArray2 = data;
        n2 = 65;
        int n3 = data.length;
        return CryptoUtils.decrypt(ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3), symmetricKey);
    }

    @NotNull
    public static final byte[] sign(@NotNull byte[] data, @NotNull byte[] key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ECPrivateKey privateKey = CryptoUtils.importPrivateKey(key);
        Signature sig = KeeperCryptoParameters.INSTANCE.getProvider$core() == null ? Signature.getInstance("SHA256withECDSA") : Signature.getInstance("SHA256withECDSA", KeeperCryptoParameters.INSTANCE.getProvider$core());
        sig.initSign(privateKey);
        sig.update(data);
        byte[] byArray = sig.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sig.sign()");
        return byArray;
    }

    @NotNull
    public static final Regex getRxBase32Alphabet() {
        return rxBase32Alphabet;
    }

    private static final byte[] base32ToBytes(String base32Text) {
        byte[] output = new byte[]{};
        char[] cArray = new char[]{'='};
        String base32 = StringsKt.trimEnd((String)((Object)StringsKt.trim((CharSequence)base32Text)).toString(), (char[])cArray);
        if (((CharSequence)base32).length() == 0 || !rxBase32Alphabet.matches((CharSequence)base32)) {
            return output;
        }
        char[] cArray2 = base32.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
        char[] bytes = cArray2;
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(base32.length() * 5))), (int)8);
        int bitIndex = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && bitIndex <= n || n2 < 0 && n <= bitIndex) {
            while (true) {
                int dualByte = StringsKt.indexOf$default((CharSequence)base32Alphabet, (char)bytes[bitIndex / 5], (int)0, (boolean)false, (int)6, null) << 10;
                if (bitIndex / 5 + 1 < bytes.length) {
                    dualByte |= StringsKt.indexOf$default((CharSequence)base32Alphabet, (char)bytes[bitIndex / 5 + 1], (int)0, (boolean)false, (int)6, null) << 5;
                }
                if (bitIndex / 5 + 2 < bytes.length) {
                    dualByte |= StringsKt.indexOf$default((CharSequence)base32Alphabet, (char)bytes[bitIndex / 5 + 2], (int)0, (boolean)false, (int)6, null);
                }
                dualByte = dualByte >> 15 - bitIndex % 5 - 8 & 0xFF;
                output = ArraysKt.plus((byte[])output, (byte)((byte)dualByte));
                if (bitIndex == n) break;
                bitIndex += n2;
            }
        }
        return output;
    }

    @JvmOverloads
    @Nullable
    public static final TotpCode getTotpCode(@NotNull String url, long unixTimeSeconds) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return TotpCode.Companion.uriToTotpCode(url, unixTimeSeconds);
    }

    public static /* synthetic */ TotpCode getTotpCode$default(String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        return CryptoUtils.getTotpCode(string, l);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String randomSample(int sampleLength, @NotNull String sampleString) {
        int sampleLen;
        Intrinsics.checkNotNullParameter((Object)sampleString, (String)"sampleString");
        String result = "";
        int n = sampleLen = sampleLength < 0 ? 0 : sampleLength;
        if (sampleLen > 0 && ((CharSequence)sampleString).length() > 0) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            SecureRandom secureRandom = SecureRandom.getInstanceStrong();
            char[] bytes = new char[sampleLen];
            Iterable iterable = (Iterable)ArraysKt.getIndices((char[])bytes);
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Character.valueOf(sampleString.charAt(secureRandom.nextInt(sampleString.length()))));
            }
            result = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        }
        return result;
    }

    public static /* synthetic */ String randomSample$default(int n, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            string = "";
        }
        return CryptoUtils.randomSample(n, string);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public static final String generatePassword(int minLength, @Nullable Integer lowercase, @Nullable Integer uppercase, @Nullable Integer digits, @Nullable Integer specialCharacters, @NotNull String specialCharacterSet) {
        int n;
        Object it2;
        int n2;
        Intrinsics.checkNotNullParameter((Object)specialCharacterSet, (String)"specialCharacterSet");
        Integer lowercaseLen = lowercase;
        Integer uppercaseLen = uppercase;
        Integer digitsLen = digits;
        Integer specialCharactersLen = specialCharacters;
        Object[] objectArray = new Integer[]{lowercase, uppercase, digits, specialCharacters};
        List counts = CollectionsKt.listOf((Object[])objectArray);
        Iterable iterable = counts;
        int n3 = 0;
        for (Object object : iterable) {
            Integer n4 = (Integer)object;
            n2 = n3;
            boolean bl = false;
            void v0 = it2;
            n = Math.abs(v0 != null ? v0.intValue() : 0);
            n3 = n2 + n;
        }
        int sumCategories = n3;
        Iterable iterable2 = counts;
        int n5 = 0;
        for (Object it2 : iterable2) {
            void it3;
            Integer bl = (Integer)it2;
            n2 = n5;
            boolean bl2 = false;
            void v1 = it3;
            n = Intrinsics.compare((int)((v1 != null ? v1.intValue() : 1) <= 0 ? 1 : 0), (int)0);
            n5 = n2 + n;
        }
        int numExactCounts = n5;
        if (counts.size() == numExactCounts && sumCategories < minLength) {
            Integer n6 = lowercaseLen;
            if ((n6 != null ? n6 : 0) < 0) {
                Integer n7 = lowercaseLen;
                Intrinsics.checkNotNull((Object)n7);
                lowercaseLen = Math.abs(n7);
            }
            Integer n8 = uppercaseLen;
            if ((n8 != null ? n8 : 0) < 0) {
                Integer n9 = uppercaseLen;
                Intrinsics.checkNotNull((Object)n9);
                uppercaseLen = Math.abs(n9);
            }
            Integer n10 = digitsLen;
            if ((n10 != null ? n10 : 0) < 0) {
                Integer n11 = digitsLen;
                Intrinsics.checkNotNull((Object)n11);
                digitsLen = Math.abs(n11);
            }
            Integer n12 = specialCharactersLen;
            if ((n12 != null ? n12 : 0) < 0) {
                Integer n13 = specialCharactersLen;
                Intrinsics.checkNotNull((Object)n13);
                specialCharactersLen = Math.abs(n13);
            }
        }
        String extraChars = "";
        int extraCount = 0;
        if (minLength > sumCategories) {
            extraCount = minLength - sumCategories;
        }
        Integer n14 = lowercaseLen;
        if ((n14 != null ? n14 : 1) > 0) {
            extraChars = extraChars + AsciiLowercase;
        }
        Integer n15 = uppercaseLen;
        if ((n15 != null ? n15 : 1) > 0) {
            extraChars = extraChars + AsciiUppercase;
        }
        Integer n16 = digitsLen;
        if ((n16 != null ? n16 : 1) > 0) {
            extraChars = extraChars + AsciiDigits;
        }
        Integer n17 = specialCharactersLen;
        if ((n17 != null ? n17 : 1) > 0) {
            extraChars = extraChars + specialCharacterSet;
        }
        if (extraCount > 0 && ((CharSequence)extraChars).length() == 0) {
            extraChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" + specialCharacterSet;
        }
        it2 = new Pair[5];
        Integer n18 = lowercaseLen;
        it2[0] = TuplesKt.to((Object)Math.abs(n18 != null ? n18 : 0), (Object)AsciiLowercase);
        Integer n19 = uppercaseLen;
        it2[1] = TuplesKt.to((Object)Math.abs(n19 != null ? n19 : 0), (Object)AsciiUppercase);
        Integer n20 = digitsLen;
        it2[2] = TuplesKt.to((Object)Math.abs(n20 != null ? n20 : 0), (Object)AsciiDigits);
        Integer n21 = specialCharactersLen;
        it2[3] = TuplesKt.to((Object)Math.abs(n21 != null ? n21 : 0), (Object)specialCharacterSet);
        it2[4] = TuplesKt.to((Object)extraCount, (Object)extraChars);
        List categoryMap = CollectionsKt.listOf(it2);
        String passwordCharacters = null;
        passwordCharacters = "";
        Iterable $this$forEach$iv = categoryMap;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it4 = (Pair)element$iv;
            boolean bl = false;
            if (((Number)it4.getFirst()).intValue() <= 0) continue;
            passwordCharacters = passwordCharacters + CryptoUtils.randomSample(((Number)it4.getFirst()).intValue(), (String)it4.getSecond());
        }
        char[] cArray = passwordCharacters.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        char[] pCharArray = cArray;
        ArraysKt.shuffle((char[])pCharArray);
        return new String(pCharArray);
    }

    public static /* synthetic */ String generatePassword$default(int n, Integer n2, Integer n3, Integer n4, Integer n5, String string, int n6, Object object) {
        if ((n6 & 1) != 0) {
            n = 32;
        }
        if ((n6 & 2) != 0) {
            n2 = null;
        }
        if ((n6 & 4) != 0) {
            n3 = null;
        }
        if ((n6 & 8) != 0) {
            n4 = null;
        }
        if ((n6 & 0x10) != 0) {
            n5 = null;
        }
        if ((n6 & 0x20) != 0) {
            string = AsciiSpecialCharacters;
        }
        return CryptoUtils.generatePassword(n, n2, n3, n4, n5, string);
    }

    @JvmOverloads
    @Nullable
    public static final TotpCode getTotpCode(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return CryptoUtils.getTotpCode$default(url, 0L, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final String generatePassword(int minLength, @Nullable Integer lowercase, @Nullable Integer uppercase, @Nullable Integer digits, @Nullable Integer specialCharacters) {
        return CryptoUtils.generatePassword$default(minLength, lowercase, uppercase, digits, specialCharacters, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public static final String generatePassword(int minLength, @Nullable Integer lowercase, @Nullable Integer uppercase, @Nullable Integer digits) {
        return CryptoUtils.generatePassword$default(minLength, lowercase, uppercase, digits, null, null, 48, null);
    }

    @JvmOverloads
    @NotNull
    public static final String generatePassword(int minLength, @Nullable Integer lowercase, @Nullable Integer uppercase) {
        return CryptoUtils.generatePassword$default(minLength, lowercase, uppercase, null, null, null, 56, null);
    }

    @JvmOverloads
    @NotNull
    public static final String generatePassword(int minLength, @Nullable Integer lowercase) {
        return CryptoUtils.generatePassword$default(minLength, lowercase, null, null, null, null, 60, null);
    }

    @JvmOverloads
    @NotNull
    public static final String generatePassword(int minLength) {
        return CryptoUtils.generatePassword$default(minLength, null, null, null, null, null, 62, null);
    }

    @JvmOverloads
    @NotNull
    public static final String generatePassword() {
        return CryptoUtils.generatePassword$default(0, null, null, null, null, null, 63, null);
    }

    public static final /* synthetic */ byte[] access$base32ToBytes(String base32Text) {
        return CryptoUtils.base32ToBytes(base32Text);
    }
}

