/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.jdbc;

import com.jcabi.jdbc.Preparation;
import com.jcabi.jdbc.Utc;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;

final class PrepareArgs
implements Preparation {
    private final transient Collection<Object> args;

    PrepareArgs(Collection<Object> arguments) {
        this.args = Collections.unmodifiableCollection(arguments);
    }

    @Override
    public void prepare(PreparedStatement stmt) throws SQLException {
        int pos = 1;
        for (Object arg : this.args) {
            if (arg == null) {
                stmt.setString(pos, null);
            } else if (arg instanceof Long) {
                stmt.setLong(pos, (Long)Long.class.cast(arg));
            } else if (arg instanceof Boolean) {
                stmt.setBoolean(pos, (Boolean)Boolean.class.cast(arg));
            } else if (arg instanceof Date) {
                stmt.setDate(pos, (Date)Date.class.cast(arg));
            } else if (arg instanceof Integer) {
                stmt.setInt(pos, (Integer)Integer.class.cast(arg));
            } else if (arg instanceof Utc) {
                ((Utc)Utc.class.cast(arg)).setTimestamp(stmt, pos);
            } else if (arg instanceof byte[]) {
                stmt.setBytes(pos, (byte[])byte[].class.cast(arg));
            } else {
                stmt.setString(pos, arg.toString());
            }
            ++pos;
        }
    }
}

