/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.jdbc;

import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.jdbc.Connect;
import com.jcabi.jdbc.JdbcSession$AjcClosure1;
import com.jcabi.jdbc.JdbcSession$AjcClosure11;
import com.jcabi.jdbc.JdbcSession$AjcClosure13;
import com.jcabi.jdbc.JdbcSession$AjcClosure15;
import com.jcabi.jdbc.JdbcSession$AjcClosure17;
import com.jcabi.jdbc.JdbcSession$AjcClosure19;
import com.jcabi.jdbc.JdbcSession$AjcClosure3;
import com.jcabi.jdbc.JdbcSession$AjcClosure5;
import com.jcabi.jdbc.JdbcSession$AjcClosure7;
import com.jcabi.jdbc.JdbcSession$AjcClosure9;
import com.jcabi.jdbc.Outcome;
import com.jcabi.jdbc.Preparation;
import com.jcabi.jdbc.PrepareArgs;
import com.jcabi.jdbc.Request;
import com.jcabi.jdbc.StaticSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@Loggable(value=1)
public final class JdbcSession {
    private final transient DataSource source;
    private final transient Collection<Object> args;
    private final transient Collection<Preparation> preparations;
    private final transient AtomicReference<Connection> connection;
    private transient boolean auto;
    private transient String query;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    public JdbcSession(@NotNull(message="data source can't be NULL") DataSource src) {
        DataSource dataSource = src;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null, (Object)dataSource);
        MethodValidator.aspectOf().beforeCtor(joinPoint);
        this.args = new CopyOnWriteArrayList<Object>();
        this.preparations = new CopyOnWriteArrayList<Preparation>();
        this.connection = new AtomicReference();
        this.auto = true;
        this.source = src;
        this.preparations.add(new PrepareArgs(this.args));
    }

    public JdbcSession(Connection cnx) {
        StaticSource src = new StaticSource(cnx);
        JdbcSession ajc$aspectInstance = this;
        ajc$aspectInstance.args = new CopyOnWriteArrayList<Object>();
        ajc$aspectInstance.preparations = new CopyOnWriteArrayList<Preparation>();
        ajc$aspectInstance.connection = new AtomicReference();
        ajc$aspectInstance.auto = true;
        ajc$aspectInstance.source = src;
        ajc$aspectInstance.preparations.add(new PrepareArgs(ajc$aspectInstance.args));
    }

    public JdbcSession sql(@NotNull(message="SQL query can't be NULL") String sql) {
        String string = sql;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (JdbcSession)MethodLogger.aspectOf().wrapClass(new JdbcSession$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JdbcSession.sql_aroundBody0(this, string, joinPoint);
    }

    public JdbcSession autocommit(boolean autocommit) {
        boolean bl = autocommit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
            return (JdbcSession)MethodLogger.aspectOf().wrapClass(new JdbcSession$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JdbcSession.autocommit_aroundBody2(this, bl, joinPoint);
    }

    public JdbcSession set(Object value) {
        Object object = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)object);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, object, joinPoint};
            return (JdbcSession)MethodLogger.aspectOf().wrapClass(new JdbcSession$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JdbcSession.set_aroundBody4(this, object, joinPoint);
    }

    public JdbcSession prepare(Preparation prp) {
        Preparation preparation = prp;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)preparation);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, preparation, joinPoint};
            return (JdbcSession)MethodLogger.aspectOf().wrapClass(new JdbcSession$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JdbcSession.prepare_aroundBody6(this, preparation, joinPoint);
    }

    public JdbcSession clear() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (JdbcSession)MethodLogger.aspectOf().wrapClass(new JdbcSession$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JdbcSession.clear_aroundBody8(this, joinPoint);
    }

    public void commit() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodLogger.aspectOf().wrapClass(new JdbcSession$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        JdbcSession.commit_aroundBody10(this, joinPoint);
    }

    public <T> T insert(@NotNull(message="outcome can't be NULL") Outcome<T> outcome) throws SQLException {
        Outcome<T> outcome2 = outcome;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, outcome2);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, outcome2, joinPoint};
            return (T)MethodLogger.aspectOf().wrapClass(new JdbcSession$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return (T)JdbcSession.insert_aroundBody12(this, outcome2, joinPoint);
    }

    public <T> T update(@NotNull(message="outcome can't be NULL") Outcome<T> outcome) throws SQLException {
        Outcome<T> outcome2 = outcome;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, outcome2);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, outcome2, joinPoint};
            return (T)MethodLogger.aspectOf().wrapClass(new JdbcSession$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return (T)JdbcSession.update_aroundBody14(this, outcome2, joinPoint);
    }

    public JdbcSession execute() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (JdbcSession)MethodLogger.aspectOf().wrapClass(new JdbcSession$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
        }
        return JdbcSession.execute_aroundBody16(this, joinPoint);
    }

    public <T> T select(@NotNull(message="outcome can't be NULL") Outcome<T> outcome) throws SQLException {
        Outcome<T> outcome2 = outcome;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, outcome2);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, outcome2, joinPoint};
            return (T)MethodLogger.aspectOf().wrapClass(new JdbcSession$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
        }
        return (T)JdbcSession.select_aroundBody18(this, outcome2, joinPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T run(Outcome<T> outcome, Connect connect, Request request) throws SQLException {
        T result;
        if (this.query == null) {
            throw new IllegalStateException("call #sql() first");
        }
        Connection conn = this.connect();
        try {
            conn.setAutoCommit(this.auto);
            PreparedStatement stmt = connect.open(conn);
            try {
                this.configure(stmt);
                ResultSet rset = request.fetch(stmt);
                try {
                    result = outcome.handle(rset, stmt);
                }
                finally {
                    if (rset != null) {
                        rset.close();
                    }
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            if (!this.auto) {
                conn.rollback();
                this.disconnect();
            }
            throw new SQLException(ex);
        }
        finally {
            if (this.auto) {
                this.disconnect();
            }
            this.clear();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection connect() throws SQLException {
        Collection<Object> collection = this.args;
        synchronized (collection) {
            if (this.connection.get() == null) {
                this.connection.set(this.source.getConnection());
            }
            return this.connection.get();
        }
    }

    private void disconnect() throws SQLException {
        Connection conn = this.connection.getAndSet(null);
        if (conn == null) {
            throw new IllegalStateException("connection is not open, can't close");
        }
        conn.close();
    }

    private void configure(PreparedStatement stmt) throws SQLException {
        for (Preparation prep : this.preparations) {
            prep.prepare(stmt);
        }
    }

    public String toString() {
        return "JdbcSession(source=" + this.source + ", args=" + this.args + ", preparations=" + this.preparations + ", connection=" + this.connection + ", auto=" + this.auto + ", query=" + this.query + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcSession)) {
            return false;
        }
        JdbcSession other = (JdbcSession)o;
        DataSource this$source = this.source;
        DataSource other$source = other.source;
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        Collection<Object> this$args = this.args;
        Collection<Object> other$args = other.args;
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        AtomicReference<Connection> this$connection = this.connection;
        AtomicReference<Connection> other$connection = other.connection;
        if (this$connection == null ? other$connection != null : !this$connection.equals(other$connection)) {
            return false;
        }
        if (this.auto != other.auto) {
            return false;
        }
        String this$query = this.query;
        String other$query = other.query;
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DataSource $source = this.source;
        result = result * 59 + ($source == null ? 0 : $source.hashCode());
        Collection<Object> $args = this.args;
        result = result * 59 + ($args == null ? 0 : ((Object)$args).hashCode());
        AtomicReference<Connection> $connection = this.connection;
        result = result * 59 + ($connection == null ? 0 : $connection.hashCode());
        result = result * 59 + (this.auto ? 79 : 97);
        String $query = this.query;
        result = result * 59 + ($query == null ? 0 : $query.hashCode());
        return result;
    }

    static {
        JdbcSession.ajc$preClinit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ JdbcSession sql_aroundBody0(JdbcSession ajc$this, String sql, JoinPoint joinPoint) {
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        Collection<Object> collection = ajc$this.args;
        synchronized (collection) {
            ajc$this.query = sql;
        }
        return ajc$this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ JdbcSession autocommit_aroundBody2(JdbcSession ajc$this, boolean autocommit, JoinPoint joinPoint) {
        Collection<Object> collection = ajc$this.args;
        synchronized (collection) {
            ajc$this.auto = autocommit;
        }
        return ajc$this;
    }

    static /* synthetic */ JdbcSession set_aroundBody4(JdbcSession ajc$this, Object value, JoinPoint joinPoint) {
        ajc$this.args.add(value);
        return ajc$this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ JdbcSession prepare_aroundBody6(JdbcSession ajc$this, Preparation prp, JoinPoint joinPoint) {
        Collection<Object> collection = ajc$this.args;
        synchronized (collection) {
            ajc$this.preparations.add(prp);
        }
        return ajc$this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ JdbcSession clear_aroundBody8(JdbcSession ajc$this, JoinPoint joinPoint) {
        Collection<Object> collection = ajc$this.args;
        synchronized (collection) {
            ajc$this.args.clear();
            ajc$this.preparations.clear();
            ajc$this.preparations.add(new PrepareArgs(ajc$this.args));
        }
        return ajc$this;
    }

    static /* synthetic */ void commit_aroundBody10(JdbcSession ajc$this, JoinPoint joinPoint) {
        Connection conn = ajc$this.connection.get();
        if (conn == null) {
            throw new IllegalStateException("connection is not open, can't commit");
        }
        conn.commit();
        ajc$this.disconnect();
    }

    static /* synthetic */ Object insert_aroundBody12(JdbcSession ajc$this, Outcome outcome, JoinPoint joinPoint) {
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        return ajc$this.run(outcome, new Connect.WithKeys(ajc$this.query), Request.EXECUTE);
    }

    static /* synthetic */ Object update_aroundBody14(JdbcSession ajc$this, Outcome outcome, JoinPoint joinPoint) {
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        return ajc$this.run(outcome, new Connect.WithKeys(ajc$this.query), Request.EXECUTE_UPDATE);
    }

    static /* synthetic */ JdbcSession execute_aroundBody16(JdbcSession ajc$this, JoinPoint joinPoint) {
        ajc$this.run(Outcome.VOID, new Connect.Plain(ajc$this.query), Request.EXECUTE);
        return ajc$this;
    }

    static /* synthetic */ Object select_aroundBody18(JdbcSession ajc$this, Outcome outcome, JoinPoint joinPoint) {
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        return ajc$this.run(outcome, new Connect.Plain(ajc$this.query), Request.EXECUTE_QUERY);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JdbcSession.java", JdbcSession.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "sql", "com.jcabi.jdbc.JdbcSession", "java.lang.String", "sql", "", "com.jcabi.jdbc.JdbcSession"), 188);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "autocommit", "com.jcabi.jdbc.JdbcSession", "boolean", "autocommit", "", "com.jcabi.jdbc.JdbcSession"), 207);
        ajc$tjp_10 = factory.makeSJP("preinitialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.jdbc.JdbcSession", "javax.sql.DataSource", "src", ""), 156);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "set", "com.jcabi.jdbc.JdbcSession", "java.lang.Object", "value", "", "com.jcabi.jdbc.JdbcSession"), 225);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "prepare", "com.jcabi.jdbc.JdbcSession", "com.jcabi.jdbc.Preparation", "prp", "", "com.jcabi.jdbc.JdbcSession"), 236);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clear", "com.jcabi.jdbc.JdbcSession", "", "", "", "com.jcabi.jdbc.JdbcSession"), 248);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "commit", "com.jcabi.jdbc.JdbcSession", "", "", "java.sql.SQLException", "void"), 262);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "insert", "com.jcabi.jdbc.JdbcSession", "com.jcabi.jdbc.Outcome", "outcome", "java.sql.SQLException", "java.lang.Object"), 289);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "com.jcabi.jdbc.JdbcSession", "com.jcabi.jdbc.Outcome", "outcome", "java.sql.SQLException", "java.lang.Object"), 310);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "execute", "com.jcabi.jdbc.JdbcSession", "", "", "java.sql.SQLException", "com.jcabi.jdbc.JdbcSession"), 334);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "select", "com.jcabi.jdbc.JdbcSession", "com.jcabi.jdbc.Outcome", "outcome", "java.sql.SQLException", "java.lang.Object"), 356);
    }
}

