/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.optionsProcessing;

import com.ibm.db2.cmx.annotation.Group;
import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.FileLoader;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.tools.Tool;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.binder.BindMetaDataInfo;
import com.ibm.db2.cmx.tools.internal.generatePdqXml.SQLFile;
import com.ibm.db2.cmx.tools.internal.generator.jdt.TypeHelper;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.Help;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OptionsProcessor {
    public static final char optionsFileCommentIndicator_ = '#';
    public static final String optionsFileNameOptionsDelimiter_ = "=";
    public static final String implSuffix_ = "Impl";
    protected static final String[] pureQueryXmlSuffixes = new String[]{".pdqxml", ".xml"};
    private static final Pattern pdqxmlStatementSetPat = Pattern.compile("(\\.pdqxml|\\.xml)\\s*(:)", 2);
    private static final int pdqXmlStatementSetPat_colonGroup = 2;
    private static final String groupOptionsNameLowerCase = "groupOptions".toLowerCase();
    public static final String descriptionOfHowArtifactTypesAreDeterminedInOptionsFile = Messages.getText("MSG_OPTIONS_FILE_HOW_ARTIFACT_TYPE_DETERMINED", pureQueryXmlSuffixes[0], pureQueryXmlSuffixes[1], "defaultOptions");
    public static final String descriptionOfPureQueryXmlFileNames = Messages.getText("MSG_PUREQUERYXML_FILE_NAME_REQUIREMENTS", pureQueryXmlSuffixes[0], pureQueryXmlSuffixes[1]);
    private static final int maximumSuffixLength = Math.max(pureQueryXmlSuffixes[0].length(), pureQueryXmlSuffixes[1].length());
    private static final EnumMap<Tool, Boolean> utilitiesHaveArtifacts_ = new EnumMap(Tool.class);

    public static List<String[]> parseOptionsFile(Tool tool, String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(OptionsProcessor.getResourceOrFileAsBufferedInputStream(string)));
            return OptionsProcessor.parseOptionsFile(tool, bufferedReader, string);
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw dataRuntimeException;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_FAIL_TO_PROCESS_ARTIFACT_OPTIONS_FILE", string), fileNotFoundException, 10347);
        }
        catch (IOException iOException) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_FAIL_TO_PROCESS_ARTIFACT_OPTIONS_FILE", string), iOException, 10844);
        }
        catch (Exception exception) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_FAIL_TO_PROCESS_ARTIFACT_OPTIONS_FILE", string), exception, 10845);
        }
    }

    public static List<String[]> parseOptionsFile(Tool tool, BufferedReader bufferedReader, String string) {
        try {
            String string2;
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            HashSet<String> hashSet = null;
            boolean bl2 = Tool.BINDER == tool;
            StringBuilder stringBuilder = new StringBuilder();
            if (!bl2) {
                hashSet = new HashSet<String>();
            }
            boolean bl3 = false;
            while (null != (string2 = bufferedReader.readLine())) {
                EscapeLexer escapeLexer;
                String string3;
                String string4;
                boolean bl4 = false;
                if (0 == (string2 = string2.trim()).length() || '#' == string2.charAt(0) || 0 >= (string4 = (string3 = (escapeLexer = new EscapeLexer(string2, true)).hasMoreTokensRecognizeDoubleQuotedStrings(String.valueOf('#')) ? escapeLexer.getUpToNextNotInQuotedStringOrRemainder('#', '#', false, false) : string2).trim()).length()) continue;
                int n2 = string4.indexOf(optionsFileNameOptionsDelimiter_);
                if (0 == n2) {
                    stringBuilder.append("\n" + Messages.getText("ERR_ARTIFACT_OPTIONS_FILE_LINE_STARTS_WITH_DELIMITER", optionsFileNameOptionsDelimiter_));
                }
                String string5 = 0 < n2 ? string4.substring(0, n2) : string4;
                String string6 = string5.trim();
                String string7 = "";
                boolean bl5 = "defaultOptions".equalsIgnoreCase(string6);
                if (bl3 && bl5 || !bl2 && !hashSet.add(string6)) {
                    if ("groupOptions".regionMatches(true, 0, string6, 0, "groupOptions".length())) {
                        stringBuilder.append("\n" + Messages.getText("ERR_DUP_GROUP_ON_GENERATOR", string6, Character.valueOf('#')));
                    } else {
                        stringBuilder.append("\n" + Messages.getText("ERR_DUPLICATE_KEYS_IN_ARTIFACT_OPTIONS_FILE", string6, Character.valueOf('#')));
                    }
                }
                if (bl4) continue;
                bl3 |= bl5;
                int n3 = n2 + optionsFileNameOptionsDelimiter_.length();
                int n4 = string4.length();
                if (-1 < n2 && n3 <= n4 - 1) {
                    string7 = string4.substring(n3);
                }
                String string8 = string7.trim();
                arrayList.add(new String[]{string6, string8});
            }
            if (0 != stringBuilder.length()) {
                stringBuilder.insert(0, "The options file is not in the correct format:");
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(stringBuilder.toString(), null, 10793);
            }
            ArrayList<String[]> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (DataRuntimeException dataRuntimeException) {
            throw dataRuntimeException;
        }
        catch (IOException iOException) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_FAIL_TO_PROCESS_ARTIFACT_OPTIONS_FILE", string), iOException, 10348);
        }
        catch (Exception exception) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_FAIL_TO_PROCESS_ARTIFACT_OPTIONS_FILE", string), exception, 10481);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ArtifactOptionsSet[] getAllArtifactOptionsSetsAndConfigureLogger(ArtifactOptionsSet artifactOptionsSet, boolean bl2, List<String[]> list, Object object) throws IOException {
        Object object2;
        List<String> list2;
        Tool tool = artifactOptionsSet.getTool();
        List<PossibleArgs> list3 = PossibleArgs.getAllArtifacts(tool);
        List<Object> list4 = new ArrayList<ArtifactOptionsSet>();
        List<ArtifactOptionsSet> list5 = null;
        List<ArtifactOptionsSet> list6 = null;
        List<ArtifactOptionsSet>[] listArray = OptionsProcessor.getOptionsFileAsListOfArtifactOptionsSetsAndUpdateCommandLine(artifactOptionsSet, list, bl2, object);
        list5 = listArray[0];
        list6 = listArray[1];
        artifactOptionsSet.replaceDeprecatedOptions();
        if (null == list5) {
            for (PossibleArgs object3 : list3) {
                list2 = artifactOptionsSet.getOptionOrArtifactMultipleValues(object3, true);
                if (null == list2) continue;
                for (String string : list2) {
                    if (null == string) continue;
                    object2 = new ArtifactOptionsSet(artifactOptionsSet, string, object3);
                    list4.add(object2);
                }
            }
            if (0 == list4.size()) {
                list4.add(artifactOptionsSet);
            }
        } else {
            for (PossibleArgs possibleArgs : list3) {
                list2 = artifactOptionsSet.getOptionOrArtifactMultipleValues(possibleArgs, true);
                if (null == list2) continue;
                for (String string : list2) {
                    Iterator<ArtifactOptionsSet> iterator;
                    if (null == string) continue;
                    object2 = new ArrayList();
                    String[] stringArray = OptionsProcessor.getArtifactNameAndStatementSetName(string);
                    String string2 = stringArray[0];
                    String string3 = stringArray[1];
                    boolean bl3 = false;
                    for (ArtifactOptionsSet artifactOptionsSet2 : list5) {
                        iterator = artifactOptionsSet2.getArtifactName();
                        String string4 = artifactOptionsSet2.getArtifactStatementSet();
                        if (!((String)((Object)iterator)).equals(string2)) continue;
                        if (null == string3) {
                            object2.add(artifactOptionsSet2);
                            bl3 |= null == string4;
                            continue;
                        }
                        if (string3.equals(string4)) {
                            object2.add(artifactOptionsSet2);
                            bl3 = true;
                            continue;
                        }
                        if (null != string4) continue;
                        object2.add(new ArtifactOptionsSet(artifactOptionsSet2, string, possibleArgs));
                        bl3 = true;
                    }
                    if (!bl3) {
                        ArtifactOptionsSet artifactOptionsSet3 = new ArtifactOptionsSet(artifactOptionsSet, string, possibleArgs);
                        if (Tool.BINDER == tool && PossibleArgs.INTERFACE == artifactOptionsSet3.getArtifactType() && list6 != null && list6.size() > 0) {
                            void var21_40;
                            Object var21_38 = null;
                            try {
                                iterator = Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
                                Group group = ((Class)((Object)iterator)).getAnnotation(Group.class);
                                if (group instanceof Group) {
                                    String string5 = group.value();
                                }
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_LD_IMPL", string2, string2), classNotFoundException, 11240);
                            }
                            if (var21_40 != null) {
                                for (ArtifactOptionsSet artifactOptionsSet4 : list6) {
                                    if (!var21_40.equalsIgnoreCase(artifactOptionsSet4.getArtifactName())) continue;
                                    ArtifactOptionsSet artifactOptionsSet5 = new ArtifactOptionsSet(artifactOptionsSet3);
                                    artifactOptionsSet5.copyOptionsAndErrorsFromOtherArtifactOptionsSet(artifactOptionsSet4, false);
                                    object2.add(artifactOptionsSet5);
                                }
                                if (object2.size() <= 0) {
                                    object2.add(0, artifactOptionsSet3);
                                }
                            }
                        } else {
                            object2.add(0, artifactOptionsSet3);
                        }
                    }
                    list4.addAll((Collection<Object>)object2);
                }
            }
            if (list4.isEmpty()) {
                list4 = list5;
            }
        }
        ArtifactOptionsSet[] artifactOptionsSetArray = list4.toArray(new ArtifactOptionsSet[list4.size()]);
        if (OptionsProcessor.utilityHasArtifacts(tool)) {
            for (ArtifactOptionsSet artifactOptionsSet6 : artifactOptionsSetArray) {
                if (null != artifactOptionsSet6.getArtifactName() && null != artifactOptionsSet6.getArtifactType()) continue;
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_ARTIFACTNAME_AND_TYPE_NOT_SPECIFIED", new Object[]{artifactOptionsSet6.getArtifactName(), artifactOptionsSet6.getArtifactType()}), null, 10794);
            }
        }
        for (ArtifactOptionsSet artifactOptionsSet7 : artifactOptionsSetArray) {
            artifactOptionsSet7.initializeOptionsAndArtifactsNotUsed();
        }
        return artifactOptionsSetArray;
    }

    public static ArtifactOptionsSet getArtifactOptionsSetAndConfigureLogger(Tool tool, String[] stringArray, TypeOfOptions typeOfOptions, String string, boolean bl2) {
        ArtifactOptionsSet artifactOptionsSet = new ArtifactOptionsSet(tool, typeOfOptions);
        if (null != string) {
            artifactOptionsSet.setArtifactToProcess(string, null);
        }
        if (null == stringArray || 0 == stringArray.length) {
            artifactOptionsSet.setHelpRequested(true);
        } else {
            EnumSet<PossibleArgs> enumSet = EnumSet.noneOf(PossibleArgs.class);
            for (int i10 = 0; i10 < stringArray.length; ++i10) {
                boolean bl3;
                if (Help.ARGS.isHelpRequest(stringArray[i10])) {
                    if (TypeOfOptions.COMMAND_LINE == typeOfOptions) {
                        artifactOptionsSet.setHelpRequested(true);
                        return artifactOptionsSet;
                    }
                    artifactOptionsSet.addErrorMessage(Messages.getText("ERR_OPTION_NOT_RECOGNIZED", stringArray[i10]), true, true);
                }
                int n2 = 0;
                String string2 = i10 + 1 < stringArray.length ? stringArray[i10 + 1] : null;
                PossibleArgs possibleArgs = PossibleArgs.getValue(stringArray[i10]);
                boolean bl4 = null != possibleArgs;
                boolean bl5 = OptionsProcessor.isArgAValue(string2, possibleArgs);
                if (bl4) {
                    bl3 = enumSet.add(possibleArgs);
                    if (!bl3) {
                        switch (possibleArgs) {
                            case INTERFACE: 
                            case INTERFACE_IMPL: 
                            case DEPRECATED_INTERFACE_IMPL: {
                                break;
                            }
                            default: {
                                if (!possibleArgs.acceptsMultipleValues(tool)) break;
                                artifactOptionsSet.addErrorMessage(Messages.getText("ERR_ARG_ONCE", possibleArgs.externalOptionName()), true, false);
                            }
                        }
                    }
                    if (PossibleArgs.NO_CLEANUP == possibleArgs && !bl5) {
                        artifactOptionsSet.addOptionOrArtifact(possibleArgs, PossibleArgs.PredefinedOptionValues.TRUE);
                        n2 = 0;
                    } else {
                        String string3;
                        int n3 = 0;
                        n2 = 0;
                        while (i10 + ++n3 < stringArray.length && OptionsProcessor.isArgAValue(string3 = stringArray[i10 + n3], possibleArgs) && (1 >= n3 || possibleArgs.acceptsMultipleValues(tool))) {
                            artifactOptionsSet.addOptionOrArtifact(possibleArgs, string3);
                            ++n2;
                        }
                        if (0 == n2) {
                            artifactOptionsSet.addOptionOrArtifact(possibleArgs, (String)null);
                        }
                    }
                } else {
                    boolean bl6 = bl3 = !bl4 && OptionsProcessor.isArgAValue(stringArray[i10], null);
                    if (bl3 && Tool.BINDER == tool && TypeOfOptions.COMMAND_LINE == typeOfOptions) {
                        artifactOptionsSet.addOptionOrArtifact(PossibleArgs.DEPRECATED_INTERFACE_IMPL, stringArray[i10]);
                    } else {
                        artifactOptionsSet.addErrorMessage(Messages.getText("ERR_OPTION_NOT_RECOGNIZED", stringArray[i10]), true, true);
                        if (!bl3 && bl5) {
                            n2 = 1;
                        }
                    }
                }
                i10 += n2;
            }
        }
        OptionsProcessor.findErrorsInArtifactOptionsSets(artifactOptionsSet);
        ToolsLogger.configureLogger(artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.TRACE_FILE), artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.TRACE_LEVEL, false), bl2);
        return artifactOptionsSet;
    }

    private static ArtifactOptionsSet getOptionsFileLineAsArtifactOptionsSetAndConfigureLogger(Tool tool, String string, String string2, TypeOfOptions typeOfOptions, boolean bl2) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (null != string2) {
            object = new EscapeLexer(string2, false);
            while (((EscapeLexer)object).hasMoreTokensRecognizeDoubleQuotedStrings(" \t")) {
                arrayList.add(((EscapeLexer)object).getUpToNextNotInQuotedStringOrRemainder(' ', '\t', true, false));
            }
        }
        object = OptionsProcessor.getArtifactOptionsSetAndConfigureLogger(tool, arrayList.toArray(new String[arrayList.size()]), typeOfOptions, string, bl2);
        return object;
    }

    private static List<ArtifactOptionsSet>[] getOptionsFileAsListOfArtifactOptionsSetsAndUpdateCommandLine(ArtifactOptionsSet artifactOptionsSet, List<String[]> object, boolean bl2, Object object2) throws IOException {
        Object object3;
        Object object4;
        List[] listArray = new ArrayList[2];
        ArrayList<ArtifactOptionsSet> arrayList = null;
        Tool tool = artifactOptionsSet.getTool();
        if (null == object && null != (object4 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.OPTIONS_FILE))) {
            object = OptionsProcessor.parseOptionsFile(tool, (String)object4);
            if (artifactOptionsSet.getOptionValueBoolean(PossibleArgs.BIND_AUTO_DETECT) && !((String)object4).equals("~!AUTO_DETECTED_BIND_PROPS_CONTENTS!~")) {
                HashSet<String> hashSet = new HashSet<String>();
                Object object5 = object.iterator();
                while (object5.hasNext()) {
                    object3 = object5.next();
                    hashSet.add(object3[0]);
                }
                object5 = OptionsProcessor.parseOptionsFile(tool, "~!AUTO_DETECTED_BIND_PROPS_CONTENTS!~");
                object3 = OptionsProcessor.filterAutoDetectedEntries((List<String[]>)object5, hashSet);
                ((ArrayList)object3).addAll(object);
                object = object3;
            }
        }
        object4 = null;
        if (null != object) {
            Object object6;
            object4 = new ArrayList();
            object3 = null;
            arrayList = new ArrayList<ArtifactOptionsSet>();
            for (int i10 = 0; i10 < object.size(); ++i10) {
                String[] stringArray = object.get(i10);
                if ("defaultOptions".equalsIgnoreCase(stringArray[0])) {
                    object3 = OptionsProcessor.getOptionsFileLineAsArtifactOptionsSetAndConfigureLogger(tool, "defaultOptions", stringArray[1], TypeOfOptions.OPTIONS_FILE_DEFAULT_OPTIONS, bl2);
                    continue;
                }
                if (stringArray[0].toLowerCase().startsWith(groupOptionsNameLowerCase)) {
                    object6 = stringArray[0].substring("groupOptions".length() + 1).trim();
                    if (tool != Tool.GENERATOR && tool != Tool.BINDER) continue;
                    arrayList.add(OptionsProcessor.getOptionsFileLineAsArtifactOptionsSetAndConfigureLogger(tool, (String)object6, stringArray[1], TypeOfOptions.OPTIONS_FILE_GROUP_OPTIONS, bl2));
                    continue;
                }
                object4.add(OptionsProcessor.getOptionsFileLineAsArtifactOptionsSetAndConfigureLogger(tool, stringArray[0], stringArray[1], TypeOfOptions.OPTIONS_FILE_ARTIFACT_OPTIONS, bl2));
            }
            String string = null;
            if (!arrayList.isEmpty()) {
                boolean bl3 = false;
                object6 = new ArrayList();
                ArtifactOptionsSet artifactOptionsSet2 = null;
                Iterator iterator = object4.iterator();
                while (iterator.hasNext()) {
                    ArtifactOptionsSet artifactOptionsSet3 = (ArtifactOptionsSet)iterator.next();
                    bl3 = false;
                    artifactOptionsSet2 = null;
                    string = null;
                    String string2 = artifactOptionsSet3.getArtifactName();
                    Class<?> clazz = null;
                    if (!string2.contains(pureQueryXmlSuffixes[0]) && !string2.contains(pureQueryXmlSuffixes[1])) {
                        if (tool == Tool.GENERATOR) {
                            string = TypeHelper.getGroupAnnotationFromInterfaceSource(string2, object2);
                        } else {
                            Object object7;
                            try {
                                object7 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.ARCHIVE);
                                clazz = null != object7 ? Class.forName(string2, true, FileLoader.binderClassLoader.get() != null ? FileLoader.binderClassLoader.get() : BindMetaDataInfo.class.getClassLoader()) : Class.forName(artifactOptionsSet3.getArtifactName(), true, Thread.currentThread().getContextClassLoader());
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_LD_IMPL", artifactOptionsSet3.getArtifactName(), artifactOptionsSet3.getArtifactName()), classNotFoundException, 11250);
                            }
                            object7 = clazz.getAnnotation(Group.class);
                            if (object7 != null && object7 instanceof Group) {
                                Group group = (Group)object7;
                                string = group.value();
                            }
                        }
                    }
                    if (string == null) continue;
                    for (ArtifactOptionsSet artifactOptionsSet4 : arrayList) {
                        if (!string.equalsIgnoreCase(artifactOptionsSet4.getArtifactName())) continue;
                        if (!bl3) {
                            artifactOptionsSet2 = new ArtifactOptionsSet(artifactOptionsSet3);
                            artifactOptionsSet3.copyOptionsAndErrorsFromOtherArtifactOptionsSet(artifactOptionsSet4, false);
                            artifactOptionsSet3.changeTypeOfOptionsToMerged();
                            bl3 = true;
                            continue;
                        }
                        ArtifactOptionsSet artifactOptionsSet5 = new ArtifactOptionsSet(artifactOptionsSet2);
                        artifactOptionsSet5.copyOptionsAndErrorsFromOtherArtifactOptionsSet(artifactOptionsSet4, false);
                        artifactOptionsSet3.changeTypeOfOptionsToMerged();
                        object6.add(artifactOptionsSet5);
                    }
                }
                if (null != object6 && !object6.isEmpty()) {
                    object4.addAll(object6);
                }
            }
            OptionsProcessor.mergeArtifactOptionSets(artifactOptionsSet, object3, (List<ArtifactOptionsSet>)object4);
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                object6 = (ArtifactOptionsSet)iterator.next();
                OptionsProcessor.findErrorsInArtifactOptionsSets((ArtifactOptionsSet)object6);
                ((ArtifactOptionsSet)object6).replaceDeprecatedOptions();
                OptionsProcessor.runChecksForRequiredOptionsAndOptionCombinations((ArtifactOptionsSet)object6, tool);
            }
        }
        listArray[0] = object4;
        listArray[1] = arrayList;
        return listArray;
    }

    private static ArrayList<String[]> filterAutoDetectedEntries(List<String[]> list, HashSet<String> hashSet) throws IOException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : hashSet) {
            int n2;
            String object2;
            PdqXmlEntry pdqXmlEntry = OptionsProcessor.computePdqXmlSignature(string);
            if (pdqXmlEntry != null) {
                hashMap.put(string, pdqXmlEntry);
            }
            if (hashMap.containsKey(object2 = string.substring((n2 = string.lastIndexOf(47)) + 1))) continue;
            hashMap.put(object2, pdqXmlEntry);
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (String[] stringArray : list) {
            if (hashSet.contains(stringArray[0])) continue;
            int n3 = stringArray[0].lastIndexOf(47);
            String string = stringArray[0].substring(n3 + 1);
            PdqXmlEntry pdqXmlEntry = OptionsProcessor.computePdqXmlSignature(stringArray[0]);
            PdqXmlEntry pdqXmlEntry2 = (PdqXmlEntry)hashMap.get(string);
            if (pdqXmlEntry2 != null) {
                if (pdqXmlEntry2.equals(pdqXmlEntry)) continue;
                arrayList.add(stringArray);
                continue;
            }
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PdqXmlEntry computePdqXmlSignature(String string) throws IOException {
        InputStream inputStream = null;
        PdqXmlEntry pdqXmlEntry = new PdqXmlEntry();
        ClassLoader classLoader = FileLoader.binderClassLoader.get();
        inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        try {
            Object object;
            byte[] byArray = FileLoader.readInputStreamToByteArray(inputStream);
            pdqXmlEntry.length_ = byArray.length;
            try {
                object = MessageDigest.getInstance("MD5");
                pdqXmlEntry.md5_ = ((MessageDigest)object).digest(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException(noSuchAlgorithmException.getMessage());
            }
            object = pdqXmlEntry;
            return object;
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void mergeArtifactOptionSets(ArtifactOptionsSet artifactOptionsSet, ArtifactOptionsSet artifactOptionsSet2, List<ArtifactOptionsSet> list) {
        if (null != list) {
            for (ArtifactOptionsSet artifactOptionsSet3 : list) {
                artifactOptionsSet3.copyOptionsAndErrorsFromOtherArtifactOptionsSet(artifactOptionsSet, true);
                artifactOptionsSet3.changeTypeOfOptionsToMerged();
                if (null == artifactOptionsSet2) continue;
                artifactOptionsSet3.copyOptionsAndErrorsFromOtherArtifactOptionsSet(artifactOptionsSet2, false);
                artifactOptionsSet3.changeTypeOfOptionsToMerged();
            }
        }
        artifactOptionsSet.copyOptionsAndErrorsFromOtherArtifactOptionsSet(artifactOptionsSet2, false);
    }

    private static void findErrorsInArtifactOptionsSets(ArtifactOptionsSet artifactOptionsSet) {
        if (null != artifactOptionsSet) {
            Tool tool = artifactOptionsSet.getTool();
            TypeOfOptions typeOfOptions = artifactOptionsSet.getTypeOfOptions();
            boolean bl2 = artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(PossibleArgs.OPTIONS_FILE);
            int n2 = 0;
            for (PossibleArgs possibleArgs : PossibleArgs.values()) {
                List<String> list;
                if (!possibleArgs.isArtifact(tool) || null == (list = artifactOptionsSet.getOptionOrArtifactMultipleValuesForErrorChecking(possibleArgs))) continue;
                n2 += list.size();
            }
            OptionsProcessor.runChecksForValidValuesOfIndividualOptions(artifactOptionsSet, tool, bl2);
            switch (typeOfOptions) {
                case COMMAND_LINE: {
                    OptionsProcessor.runChecksRequiredForCommandLineOptions(artifactOptionsSet, tool, typeOfOptions, n2, bl2);
                    break;
                }
                case OPTIONS_FILE_DEFAULT_OPTIONS: {
                    OptionsProcessor.runChecksRequiredForOptionsFileDefaultOptions(artifactOptionsSet, tool, typeOfOptions);
                    break;
                }
                case OPTIONS_FILE_ARTIFACT_OPTIONS: {
                    OptionsProcessor.runChecksRequiredForOptionsFileArtifactOptions(artifactOptionsSet, tool, typeOfOptions);
                    break;
                }
            }
        }
    }

    private static void runChecksForValidValuesOfIndividualOptions(ArtifactOptionsSet artifactOptionsSet, Tool tool, boolean bl2) {
        List<String> list;
        Object object;
        Object object2;
        String string;
        List<String> list22;
        String string2 = artifactOptionsSet.getOptionOrArtifactSingleValueForErrorChecking(PossibleArgs.URL);
        if (null != string2 && (1 > string2.length() || string2.startsWith("-") || Tool.BINDER == tool && !string2.startsWith("jdbc:db2://"))) {
            artifactOptionsSet.addErrorMessage(Messages.getText("ERR_BIND_URL", string2, PossibleArgs.URL.externalOptionName(), PossibleArgs.URL.errorMessage(tool)), true, false);
        }
        PossibleArgs[] possibleArgsArray = new PossibleArgs[]{PossibleArgs.XML_FILE_GENERATOR, PossibleArgs.PUREQUERY_XML_FILE};
        PossibleArgs possibleArgs = artifactOptionsSet.getArtifactType();
        for (PossibleArgs possibleArgs2 : possibleArgsArray) {
            List<String> list3;
            if (PossibleArgs.PUREQUERY_XML_FILE == possibleArgs2 && Tool.CONFIGURE != tool) continue;
            if (null != possibleArgs && possibleArgs == possibleArgs2) {
                OptionsProcessor.checkIfInputFileExists(artifactOptionsSet, possibleArgs2, artifactOptionsSet.getArtifactName());
            }
            if (null == (list3 = artifactOptionsSet.getOptionOrArtifactMultipleValuesForErrorChecking(possibleArgs2))) continue;
            for (List<String> list22 : list3) {
                OptionsProcessor.checkIfInputFileExists(artifactOptionsSet, possibleArgs2, (String)((Object)list22));
            }
        }
        PossibleArgs[] possibleArgsArray2 = new PossibleArgs[]{PossibleArgs.PUREQUERY_XML_FILE, PossibleArgs.PUREQUERY_PROPERTIES, PossibleArgs.OPTIONS_FILE_FORBIND, PossibleArgs.OPTIONS_FILE_FORCONFIGURE};
        String string22 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.INPUT_DIRECTORY);
        if (Tool.MANAGE_REPOSITORY == tool && !artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(PossibleArgs.EXTRACT)) {
            for (PossibleArgs possibleArgs2 : possibleArgsArray2) {
                list22 = artifactOptionsSet.getOptionOrArtifactMultipleValuesForErrorChecking(possibleArgs2);
                if (null == list22) continue;
                for (String string3 : list22) {
                    if (null == string3) continue;
                    if (string22 != null) {
                        if (!string22.endsWith(File.separator)) {
                            string22 = string22 + File.separator;
                        }
                        string3 = string22 + string3;
                    }
                    if (null != string3 && new File(string3).exists()) continue;
                    artifactOptionsSet.addErrorMessage(Messages.getText("ERR_FILE_NOTFND", string3, possibleArgs2.externalOptionName()), true, false);
                }
            }
        }
        int n2 = artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(PossibleArgs.INPUT_PUREQUERY_XML) ? 1 : 0;
        boolean bl3 = artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(PossibleArgs.INPUT_PUREQUERY_XML_GROUP);
        if (n2 != 0 && bl3) {
            artifactOptionsSet.addErrorMessage(Messages.getText("ERR_BOTH_INPUT_FILE_OPTIONS_GIVEN", PossibleArgs.INPUT_PUREQUERY_XML.externalOptionName(), PossibleArgs.INPUT_PUREQUERY_XML_GROUP.externalOptionName()), true, false);
        } else if (Tool.MERGE == tool && n2 == 0 && !bl3) {
            artifactOptionsSet.addErrorMessage(Messages.getText("ERR_INPUT_FILES_MISSING", PossibleArgs.INPUT_PUREQUERY_XML.externalOptionName(), PossibleArgs.INPUT_PUREQUERY_XML_GROUP.externalOptionName()), true, false);
        }
        String string4 = artifactOptionsSet.getOptionOrArtifactSingleValueForErrorChecking(PossibleArgs.ROOT_PATH);
        if (null != string4) {
            if (!new File(string4).exists()) {
                artifactOptionsSet.addErrorMessage(Messages.getText("ERR_ROOTPATH", string4, PossibleArgs.ROOT_PATH.externalOptionName()), true, false);
            } else {
                File file = new File(string4);
                if (!file.isAbsolute()) {
                    string4 = file.getAbsolutePath();
                    artifactOptionsSet.replaceOptionOrArtifact(PossibleArgs.ROOT_PATH, string4);
                }
            }
        }
        if (!(null == (string = artifactOptionsSet.getOptionOrArtifactSingleValueForErrorChecking(PossibleArgs.ARCHIVE)) || string.endsWith(".jar") || string.endsWith(".zip") || string.endsWith(".war") || string.endsWith(".ear"))) {
            artifactOptionsSet.addErrorMessage(Messages.getText(Messages.getText("ERR_ARCHIVE_UNKNOWN_EXTENSION", new Object[]{PossibleArgs.ARCHIVE, string}), new Object[0]), true, false);
        }
        if (null != (list22 = artifactOptionsSet.getOptionOrArtifactSingleValueForErrorChecking(PossibleArgs.INPUT_SQL)) && !((String)((Object)list22)).equals(PossibleArgs.PredefinedOptionValues.INPUT_SQL_DYNAMIC_STATEMENT_CACHE.toString())) {
            object2 = ((String)((Object)list22)).toLowerCase();
            boolean bl4 = false;
            object = SQLFile.inputExtensionsLowerCase;
            int n3 = ((String[])object).length;
            for (int i10 = 0; i10 < n3; ++i10) {
                list = object[i10];
                if (!((String)object2).endsWith((String)((Object)list))) continue;
                bl4 = true;
                break;
            }
            if (!bl4) {
                artifactOptionsSet.addErrorMessage(Messages.getText("ERR_FILE_EXTENSION_UNSUPPORTED", new Object[]{list22, PossibleArgs.INPUT_SQL, Messages.getListOfValues(true, SQLFile.inputExtensionsLowerCase)}), true, false);
            }
        }
        if (artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(PossibleArgs.BIND_OPTIONS) && "true".equalsIgnoreCase(artifactOptionsSet.getOptionOrArtifactSingleValueForErrorChecking(PossibleArgs.GENERATE_DBRM))) {
            artifactOptionsSet.addErrorMessage(Messages.getText("ERR_VERIFY_INVALID_COMBINATION", PossibleArgs.GENERATE_DBRM.externalOptionName(), PossibleArgs.BIND_OPTIONS.externalOptionName()), true, false);
        }
        object2 = null;
        object2 = artifactOptionsSet.getOptionOrArtifactSingleValueForErrorChecking(PossibleArgs.COMMENT_START);
        if (null != object2 && ((String)(object = ((String)object2).trim())).startsWith("/*")) {
            artifactOptionsSet.addErrorMessage(Messages.getText("MSG_COMMENTSTART_ILLEGAL_VALUE", object2, PossibleArgs.COMMENT_START.externalOptionName(), "/*"), true, false);
        }
        for (PossibleArgs possibleArgs3 : PossibleArgs.values()) {
            Object object3;
            list = artifactOptionsSet.getOptionOrArtifactMultipleValuesForErrorChecking(possibleArgs3);
            if (null == list) continue;
            int n4 = list.size();
            if (!possibleArgs3.acceptsMultipleValues(tool) && 1 != n4) {
                object3 = "";
                if (!possibleArgs3.maskUserValueInOutput()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl5 = true;
                    for (String string5 : list) {
                        boolean bl6;
                        boolean bl7 = bl6 = null != string5;
                        if (!bl5) {
                            stringBuilder.append(", ");
                        }
                        if (bl6) {
                            stringBuilder.append("\"");
                        }
                        stringBuilder.append(string5);
                        if (bl6) {
                            stringBuilder.append("\"");
                        }
                        bl5 = false;
                    }
                    if (0 < stringBuilder.length()) {
                        object3 = Messages.getText("ERR_ARG_VALUES", stringBuilder.toString());
                    }
                }
                artifactOptionsSet.addErrorMessage(Messages.getText("ERR_ARGS_MULTIVALUES_FOR_SINGLEVALUE", possibleArgs3.errorMessage(tool), n4, object3), true, false);
            }
            if (possibleArgs3.getExceptionIfValueNotOneOfPredefinedOptionValues() && null != possibleArgs3.predefinedOptionValues()) {
                for (String string6 : list) {
                    PossibleArgs.PredefinedOptionValues predefinedOptionValues;
                    if (null == string6 || null != (predefinedOptionValues = possibleArgs3.getOptionValueFromString(string6))) continue;
                    artifactOptionsSet.addErrorMessage(possibleArgs3.errorMessage(tool) + Messages.getText("ERR_OPTIONVALUE_NOT_IN_PREDEFINED_VALUES2", string6), true, false);
                }
            }
            if (PossibleArgs.TRACE_LEVEL == possibleArgs3) {
                for (String string7 : list) {
                    Level level;
                    if (null == string7 || null != (level = Log.getLevelFromPropertyValueNullIfNotFound(string7))) continue;
                    artifactOptionsSet.addErrorMessage(possibleArgs3.errorMessage(tool) + Messages.getText("ERR_OPTIONVALUE_NOT_IN_PREDEFINED_VALUES2", string7), true, false);
                }
            }
            object3 = EnumSet.of(PossibleArgs.PUREQUERY_XML_FILE, PossibleArgs.INPUT_PUREQUERY_XML, PossibleArgs.OUTPUT_PUREQUERY_XML, PossibleArgs.XML_FILE_GENERATOR);
            if (!possibleArgs3.isArtifact(tool) && !((AbstractCollection)object3).contains((Object)possibleArgs3)) continue;
            for (String string8 : list) {
                String string9;
                PossibleArgs possibleArgs4;
                String string5;
                if (null == string8) continue;
                String[] stringArray = OptionsProcessor.getArtifactNameAndStatementSetName(string8);
                string5 = stringArray[0];
                String string10 = stringArray[1];
                if (null != string10 && (Tool.BINDER != tool || PossibleArgs.PUREQUERY_XML_FILE != possibleArgs3)) {
                    artifactOptionsSet.addErrorMessage(Messages.getText("ERR_STATEMENT_SET_NAME_NOT_ALLOWED_IN_VALUE_OF_COMMAND_LINE_OPTION", possibleArgs3.externalOptionName(), string8, string10, string5), true, false);
                }
                if (PossibleArgs.PUREQUERY_XML_FILE == possibleArgs3 && Tool.GENERATOR != tool && Tool.BINDER != tool && Tool.CONFIGURE != tool && !OptionsProcessor.isPureQueryXmlFileExtensionValid(string5)) {
                    artifactOptionsSet.addErrorMessage(Messages.getText("ERR_ILLEGAL_FILE_EXTENSION", new Object[]{string5, possibleArgs3}), true, false);
                }
                if (PossibleArgs.INPUT_PUREQUERY_XML == possibleArgs3) {
                    if (OptionsProcessor.isPureQueryXmlFileExtensionValid(string5)) continue;
                    artifactOptionsSet.addErrorMessage(Messages.getText("ERR_ILLEGAL_FILE_EXTENSION", new Object[]{string5, possibleArgs3}), true, false);
                    continue;
                }
                if (!possibleArgs3.isArtifact(tool) || !bl2 || (possibleArgs4 = OptionsProcessor.getArtifactTypeForOptionsFileLine(string5)) == possibleArgs3 || PossibleArgs.INTERFACE == possibleArgs4 && (PossibleArgs.INTERFACE_IMPL == possibleArgs3 || PossibleArgs.DEPRECATED_INTERFACE_IMPL == possibleArgs3)) continue;
                switch (possibleArgs3) {
                    case PUREQUERY_XML_FILE: {
                        string9 = Messages.getText("ERR_OPTION_IS_PDQXML_BUT_NAME_IS_INTERFACE", new Object[]{possibleArgs3, string5, descriptionOfHowArtifactTypesAreDeterminedInOptionsFile});
                        break;
                    }
                    case INTERFACE: {
                        string9 = Messages.getText("ERR_OPTION_IS_INTERFACE_BUT_NAME_IS_PDQXML", new Object[]{possibleArgs3, string5, descriptionOfHowArtifactTypesAreDeterminedInOptionsFile});
                        break;
                    }
                    default: {
                        string9 = Messages.getText("ERR_OPTION_IS_WRONG_TYPE_GENERIC", new Object[]{possibleArgs3, string5, descriptionOfHowArtifactTypesAreDeterminedInOptionsFile});
                    }
                }
                artifactOptionsSet.addErrorMessage(string9, true, false);
            }
        }
    }

    private static void runChecksRequiredForCommandLineOptions(ArtifactOptionsSet artifactOptionsSet, Tool tool, TypeOfOptions typeOfOptions, int n2, boolean bl2) {
        if (TypeOfOptions.COMMAND_LINE != typeOfOptions) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{typeOfOptions}), null, 10795);
        }
        for (PossibleArgs possibleArgs : PossibleArgs.values()) {
            if (!artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(possibleArgs)) continue;
            if (!possibleArgs.isAllowedForTool(artifactOptionsSet.getTool())) {
                artifactOptionsSet.addErrorMessage(Messages.getText("ERR_OPTION_NOT_ALLOWED_FOR_UTILITY", possibleArgs.externalOptionName()), true, true);
                continue;
            }
            if (!bl2 || possibleArgs.isAllowedOnCommandLineWhenOptionsFileIsSpecified(tool)) continue;
            boolean bl3 = false;
            switch (tool) {
                case GENERATOR: {
                    if (PossibleArgs.INTERFACE != possibleArgs) break;
                    bl3 = true;
                    artifactOptionsSet.addErrorMessage(Messages.getText("ERR_INTERFACES_WITH_ARTIFACT_OPTIONS_FILE", PossibleArgs.INTERFACE.externalOptionName(), PossibleArgs.OPTIONS_FILE.externalOptionName()), true, false);
                    break;
                }
                case CONFIGURE: {
                    if (PossibleArgs.PUREQUERY_XML_FILE != possibleArgs) break;
                    bl3 = true;
                    artifactOptionsSet.addErrorMessage(Messages.getText("ERR_PUREQUERYXML_WITH_ARTIFACT_OPTIONS_FILE", PossibleArgs.PUREQUERY_XML_FILE.externalOptionName(), PossibleArgs.OPTIONS_FILE.externalOptionName()), true, false);
                    break;
                }
                case BINDER: {
                    if (PossibleArgs.INTERFACE_IMPL != possibleArgs) break;
                    bl3 = true;
                    artifactOptionsSet.addErrorMessage(Messages.getText("ERR_IMPLS_WITH_OPTIONS_FILE", PossibleArgs.INTERFACE_IMPL.externalOptionName(), PossibleArgs.OPTIONS_FILE.externalOptionName(), PossibleArgs.INTERFACE.externalOptionName()), true, false);
                    break;
                }
                default: {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{tool}), null, 10431);
                }
            }
            if (bl3) continue;
            if (possibleArgs.isAllowedForAnArtifactInOptionsFile(tool) || possibleArgs.isAllowedInDefaultOptionsInOptionsFile()) {
                artifactOptionsSet.addErrorMessage(Messages.getText("ERR_OPTION_NOT_ALLOWED_ON_CMDLINE_WITH_ARTIFACT_OPTIONS_FILE", possibleArgs.externalOptionName(), PossibleArgs.OPTIONS_FILE.externalOptionName()), true, false);
                continue;
            }
            artifactOptionsSet.addErrorMessage(Messages.getText("ERR_OPTION_NOT_ALLOWED_ON_CMDLINE_WITH_ARTIFACT_OPTIONS_FILE_2", possibleArgs.externalOptionName(), PossibleArgs.OPTIONS_FILE.externalOptionName()), true, false);
        }
        if (!bl2) {
            if (1 < n2 && artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(PossibleArgs.ROOT_PKG_NAME)) {
                if (Tool.GENERATOR == tool) {
                    artifactOptionsSet.addErrorMessage(Messages.getText("ERR_MULT_INTERFACES_WITH_ROOTPKG_NEW", PossibleArgs.ROOT_PKG_NAME.externalOptionName(), "defaultOptions"), true, false);
                } else if (Tool.CONFIGURE == tool) {
                    artifactOptionsSet.addErrorMessage(Messages.getText("ERR_MULT_PUREQUERYXML_WITH_ROOTPKG_NEW", PossibleArgs.ROOT_PKG_NAME.externalOptionName(), "defaultOptions"), true, false);
                }
            }
            if (tool == Tool.CONFIGURE && !artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.ROOT_PKG_NAME)) {
                artifactOptionsSet.addErrorMessage(Messages.getText("ERR_ROOTPKGNAME_REQUIRED", PossibleArgs.ROOT_PKG_NAME.externalOptionName()), true, false);
            }
            if (Tool.GENERATOR == tool && 1 < n2 && artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(PossibleArgs.PUREQUERY_XML_FILE)) {
                artifactOptionsSet.addErrorMessage(Messages.getText("ERR_MULT_INTERFACES_WITH_PUREQUERYXML", PossibleArgs.PUREQUERY_XML_FILE.externalOptionName(), "defaultOptions"), true, false);
            }
            if (1 > n2) {
                switch (tool) {
                    case GENERATOR: {
                        artifactOptionsSet.addErrorMessage(Messages.getText("ERR_GEN_INTERFACE_REQ", PossibleArgs.INTERFACE.externalOptionName()), true, false);
                        break;
                    }
                    case BINDER: {
                        if (artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(PossibleArgs.ARCHIVE)) break;
                        artifactOptionsSet.addErrorMessage(Messages.getText("ERR_BINDER_INTERFACE_XMLFILE_REQ", PossibleArgs.INTERFACE.externalOptionName(), PossibleArgs.PUREQUERY_XML_FILE.externalOptionName()), true, false);
                        break;
                    }
                    case CONFIGURE: 
                    case METADATAREPLACER: {
                        artifactOptionsSet.addErrorMessage(Messages.getText("ERR_CONFIGURE_XMLFILE_REQ", PossibleArgs.PUREQUERY_XML_FILE.externalOptionName()), true, false);
                        break;
                    }
                    case MERGE: {
                        artifactOptionsSet.addErrorMessage(Messages.getText("ERR_OUTPUT_PUREQUERY_XML_FILE_NAME_REQUIRED", PossibleArgs.OUTPUT_PUREQUERY_XML.externalOptionName()), true, false);
                        break;
                    }
                    case GENERATE_PUREQUERYXML: {
                        artifactOptionsSet.addErrorMessage(Messages.getText("ERR_PUREQUERYXML_REQUIRED", PossibleArgs.PUREQUERY_XML_FILE.externalOptionName()), true, false);
                        break;
                    }
                    case MANAGE_REPOSITORY: {
                        break;
                    }
                    case VALIDATOR: {
                        artifactOptionsSet.addErrorMessage(Messages.getText("ERR_VALIDATOR_XMLFILE_REQ", PossibleArgs.PUREQUERY_XML_FILE.externalOptionName()), true, false);
                        break;
                    }
                    default: {
                        if (!OptionsProcessor.utilityHasArtifacts(tool)) break;
                        throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{tool}), null, 10374);
                    }
                }
            }
            OptionsProcessor.runChecksForRequiredOptionsAndOptionCombinations(artifactOptionsSet, tool);
        }
        if (artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(PossibleArgs.VERIFY_PACKAGES)) {
            EnumSet<PossibleArgs[]> enumSet = EnumSet.of(PossibleArgs.URL, new PossibleArgs[]{PossibleArgs.PASSWORD, PossibleArgs.USERNAME, PossibleArgs.OPTIONS_FILE, PossibleArgs.INTERFACE, PossibleArgs.PUREQUERY_XML_FILE, PossibleArgs.INTERFACE_IMPL, PossibleArgs.ISOLATION_LEVEL, PossibleArgs.BIND_OPTIONS, PossibleArgs.TRACE_FILE, PossibleArgs.TRACE_LEVEL, PossibleArgs.ARCHIVE, PossibleArgs.VERIFY_PACKAGES});
            for (PossibleArgs possibleArgs : PossibleArgs.getValues(tool)) {
                if (enumSet.contains((Object)possibleArgs) || !artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(possibleArgs)) continue;
                artifactOptionsSet.addErrorMessage(Messages.getText("ERR_VERIFY_INVALID_COMBINATION", possibleArgs.externalOptionName(), PossibleArgs.VERIFY_PACKAGES.externalOptionName()), true, false);
            }
        }
    }

    private static void runChecksRequiredForOptionsFileDefaultOptions(ArtifactOptionsSet artifactOptionsSet, Tool tool, TypeOfOptions typeOfOptions) {
        if (TypeOfOptions.OPTIONS_FILE_DEFAULT_OPTIONS != typeOfOptions) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{typeOfOptions}), null, 10799);
        }
        for (PossibleArgs possibleArgs : PossibleArgs.values()) {
            if (possibleArgs.isAllowedInDefaultOptionsInOptionsFile() && !possibleArgs.isArtifact(tool) && PossibleArgs.OPTIONS_FILE != possibleArgs || !artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(possibleArgs)) continue;
            String string = null;
            if (possibleArgs.isArtifact(tool)) {
                switch (possibleArgs) {
                    case INTERFACE: {
                        string = Messages.getText("ERR_ARTIFACTS_AS_OPTIONS_IN_ARTIFACT_OPTIONS_FILE_INTERFACE", PossibleArgs.INTERFACE.externalOptionName());
                        break;
                    }
                    case INTERFACE_IMPL: 
                    case DEPRECATED_INTERFACE_IMPL: {
                        string = Messages.getText("ERR_ARTIFACTS_AS_OPTIONS_IN_ARTIFACT_OPTIONS_FILE_IMPL", PossibleArgs.INTERFACE_IMPL.externalOptionName());
                        break;
                    }
                    case PUREQUERY_XML_FILE: {
                        string = Messages.getText("ERR_ARTIFACTS_AS_OPTIONS_IN_ARTIFACT_OPTIONS_FILE_PDQXML", PossibleArgs.PUREQUERY_XML_FILE.externalOptionName());
                        break;
                    }
                    case OUTPUT_PUREQUERY_XML: {
                        string = Messages.getText("ERR_OUTPUTPUREQUERYXML_AS_OPTIONS_IN_ARTIFACT_OPTIONS_FILE", PossibleArgs.OUTPUT_PUREQUERY_XML.externalOptionName());
                    }
                }
            }
            if (null == string) {
                string = Messages.getText("ERR_OPTION_NOT_ALLOWED_AS_DEFAULT", possibleArgs.externalOptionName(), "defaultOptions");
            }
            artifactOptionsSet.addErrorMessage(string, true, false);
        }
    }

    private static void runChecksRequiredForOptionsFileArtifactOptions(ArtifactOptionsSet artifactOptionsSet, Tool tool, TypeOfOptions typeOfOptions) {
        if (TypeOfOptions.OPTIONS_FILE_ARTIFACT_OPTIONS != typeOfOptions) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{typeOfOptions}), null, 10796);
        }
        if (tool == Tool.CONFIGURE && !artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.ROOT_PKG_NAME)) {
            artifactOptionsSet.addErrorMessage(Messages.getText("ERR_ROOTPKGNAME_REQUIRED", PossibleArgs.ROOT_PKG_NAME.externalOptionName()), true, false);
        }
        if (null != artifactOptionsSet.getArtifactStatementSet() && (Tool.BINDER != tool || PossibleArgs.PUREQUERY_XML_FILE != artifactOptionsSet.getArtifactType())) {
            artifactOptionsSet.addErrorMessage(Messages.getText("ERR_STATEMENT_SET_NAME_NOT_ALLOWED_IN_OPTIONS_FILE_LINE", artifactOptionsSet.getArtifactNameAndStatementSetNameAsProvidedByUser(), artifactOptionsSet.getArtifactStatementSet(), artifactOptionsSet.getArtifactName()), true, false);
        }
        for (PossibleArgs possibleArgs : PossibleArgs.values()) {
            if (possibleArgs.isAllowedForAnArtifactInOptionsFile(tool) && !possibleArgs.isArtifact(tool) && PossibleArgs.OPTIONS_FILE != possibleArgs || !artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(possibleArgs)) continue;
            String string = null;
            if (possibleArgs.isArtifact(tool)) {
                switch (possibleArgs) {
                    case INTERFACE: {
                        string = Messages.getText("ERR_ARTIFACTS_AS_OPTIONS_IN_ARTIFACT_OPTIONS_FILE_INTERFACE", PossibleArgs.INTERFACE.externalOptionName());
                        break;
                    }
                    case INTERFACE_IMPL: 
                    case DEPRECATED_INTERFACE_IMPL: {
                        string = Messages.getText("ERR_ARTIFACTS_AS_OPTIONS_IN_ARTIFACT_OPTIONS_FILE_IMPL", PossibleArgs.INTERFACE_IMPL.externalOptionName());
                        break;
                    }
                    case PUREQUERY_XML_FILE: {
                        string = Messages.getText("ERR_ARTIFACTS_AS_OPTIONS_IN_ARTIFACT_OPTIONS_FILE_PDQXML", PossibleArgs.PUREQUERY_XML_FILE.externalOptionName());
                        break;
                    }
                    case OUTPUT_PUREQUERY_XML: {
                        string = Messages.getText("ERR_OUTPUTPUREQUERYXML_AS_OPTIONS_IN_ARTIFACT_OPTIONS_FILE", PossibleArgs.OUTPUT_PUREQUERY_XML.externalOptionName());
                    }
                }
            }
            if (null == string) {
                string = Messages.getText("ERR_OPTION_NOT_ALLOWED_FOR_ARTIFACT", possibleArgs.externalOptionName(), false);
            }
            artifactOptionsSet.addErrorMessage(string, true, false);
        }
    }

    private static void runChecksForRequiredOptionsAndOptionCombinations(ArtifactOptionsSet artifactOptionsSet, Tool tool) {
        for (PossibleArgs possibleArgs : PossibleArgs.values()) {
            if (!(!possibleArgs.isRequiredOption(tool) || PossibleArgs.DATA == possibleArgs || artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(possibleArgs) || possibleArgs.isArtifact(tool) && possibleArgs.isAllowedForTool(tool))) {
                artifactOptionsSet.addErrorMessage(Messages.getText("ERR_OPTION_REQURIED", possibleArgs.externalOptionName()), true, false);
            }
            String string = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.LOCATION_MAP);
            String string2 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.SCHEMA_MAP);
            if (tool != Tool.METADATAREPLACER || string != null || string2 != null) continue;
            artifactOptionsSet.addErrorMessage(Messages.getText("ERR_BOTH_OPTIONS_EMPTY", new Object[]{PossibleArgs.LOCATION_MAP, PossibleArgs.SCHEMA_MAP}), true, false);
        }
        OptionsProcessor.checkJCCLevel(artifactOptionsSet);
        PossibleArgs[] possibleArgsArray = new PossibleArgs[]{PossibleArgs.CREATE, PossibleArgs.UPDATE, PossibleArgs.DELETE, PossibleArgs.EXTRACT, PossibleArgs.EXPORT, PossibleArgs.IMPORT, PossibleArgs.ACTIVATE, PossibleArgs.DEACTIVATE, PossibleArgs.COPY, PossibleArgs.LIST, PossibleArgs.REPORT, PossibleArgs.BIND, PossibleArgs.VERIFY};
        OptionsProcessor.checkForMutuallyExclusiveOptions(artifactOptionsSet, possibleArgsArray);
        possibleArgsArray = new PossibleArgs[]{PossibleArgs.GRANT_OPTIONS, PossibleArgs.REVOKE};
        OptionsProcessor.checkForMutuallyExclusiveOptions(artifactOptionsSet, possibleArgsArray);
        possibleArgsArray = new PossibleArgs[]{PossibleArgs.GRANT_OPTIONS, PossibleArgs.GENERATE_DBRM};
        OptionsProcessor.checkForMutuallyExclusiveOptions(artifactOptionsSet, possibleArgsArray);
        OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.EXPORT, null, PossibleArgs.FILE);
        OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.IMPORT, null, PossibleArgs.FILE);
        OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.CREATE, PossibleArgs.PredefinedOptionValues.REPOSITORY, PossibleArgs.REPOSITORY_TYPE);
        possibleArgsArray = new PossibleArgs[]{PossibleArgs.INTERFACE, PossibleArgs.STATEMENT_BIND_ERROR};
        OptionsProcessor.checkForMutuallyExclusiveOptions(artifactOptionsSet, possibleArgsArray);
        if (artifactOptionsSet.getOptionValueBoolean(PossibleArgs.REMOVE_INVALID_SQL) && artifactOptionsSet.getOptionValueBoolean(PossibleArgs.RESTORE_INVALID_SQL_FORCE)) {
            artifactOptionsSet.addErrorMessage(Messages.getText("MSG_CONF_BOTH_OPTIONS_TRUE", PossibleArgs.REMOVE_INVALID_SQL.externalOptionName(), PossibleArgs.RESTORE_INVALID_SQL_FORCE.externalOptionName()), true, false);
        }
        if (Tool.MANAGE_REPOSITORY == tool) {
            OptionsProcessor.checkForMutuallyExclusiveOptions(artifactOptionsSet, new PossibleArgs[]{PossibleArgs.CREATE, PossibleArgs.UPGRADE});
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.GRANT_OPTIONS, null, PossibleArgs.ACCESS_LEVEL);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.GRANT_OPTIONS, null, PossibleArgs.PRIVILEGE);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.REVOKE, null, PossibleArgs.PRIVILEGE);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.REPORT, PossibleArgs.PredefinedOptionValues.PUREQUERY_XML_CHANGES, PossibleArgs.NEW_PUREQUERY_XML);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.REPORT, PossibleArgs.PredefinedOptionValues.PUREQUERY_XML_CHANGES, PossibleArgs.OLD_PUREQUERY_XML);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.REPORT_LENGTH, PossibleArgs.PredefinedOptionValues.SHORT, PossibleArgs.REPORT);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.REPORT_LENGTH, PossibleArgs.PredefinedOptionValues.LONG, PossibleArgs.REPORT);
            if (!artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(PossibleArgs.RUNTIME_GROUP_ID)) {
                for (PossibleArgs possibleArgs : PossibleArgs.getValues(Tool.MANAGE_REPOSITORY)) {
                    OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, possibleArgs, PossibleArgs.PredefinedOptionValues.RUNTIME_GROUP, PossibleArgs.RUNTIME_GROUP_ID);
                }
            }
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.CREATE, PossibleArgs.PredefinedOptionValues.RUNTIME_GROUP, PossibleArgs.RUNTIME_GROUP_VERSION);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.UPDATE, PossibleArgs.PredefinedOptionValues.RUNTIME_GROUP, PossibleArgs.RUNTIME_GROUP_VERSION);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.ACTIVATE, PossibleArgs.PredefinedOptionValues.RUNTIME_GROUP, PossibleArgs.RUNTIME_GROUP_VERSION);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.COPY, PossibleArgs.PredefinedOptionValues.RUNTIME_GROUP, PossibleArgs.TARGET_VERSION);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.EXPORT, PossibleArgs.PredefinedOptionValues.RUNTIME_GROUP, PossibleArgs.RUNTIME_GROUP_VERSION);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.EXPORT, PossibleArgs.PredefinedOptionValues.REPOSITORY, PossibleArgs.RUNTIME_GROUP_VERSION);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.EXPORT, PossibleArgs.PredefinedOptionValues.REPOSITORY, PossibleArgs.RUNTIME_GROUP_ID);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.EXPORT, PossibleArgs.PredefinedOptionValues.IMPORT_OR_EXPORT_DATA, PossibleArgs.RUNTIME_GROUP_VERSION);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.EXPORT, PossibleArgs.PredefinedOptionValues.IMPORT_OR_EXPORT_DATA, PossibleArgs.RUNTIME_GROUP_ID);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.IMPORT, PossibleArgs.PredefinedOptionValues.RUNTIME_GROUP, PossibleArgs.RUNTIME_GROUP_VERSION);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.IMPORT, PossibleArgs.PredefinedOptionValues.REPOSITORY, PossibleArgs.RUNTIME_GROUP_VERSION);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.IMPORT, PossibleArgs.PredefinedOptionValues.REPOSITORY, PossibleArgs.RUNTIME_GROUP_ID);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.IMPORT, PossibleArgs.PredefinedOptionValues.IMPORT_OR_EXPORT_DATA, PossibleArgs.RUNTIME_GROUP_VERSION);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.IMPORT, PossibleArgs.PredefinedOptionValues.IMPORT_OR_EXPORT_DATA, PossibleArgs.RUNTIME_GROUP_ID);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.EXTRACT, PossibleArgs.PredefinedOptionValues.RUNTIME_GROUP, PossibleArgs.RUNTIME_GROUP_VERSION);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.DELETE, PossibleArgs.PredefinedOptionValues.INCREMENTAL, PossibleArgs.RUNTIME_GROUP_ID);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.DELETE, PossibleArgs.PredefinedOptionValues.INCREMENTAL, PossibleArgs.INPUT_DIRECTORY);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.DELETE, PossibleArgs.PredefinedOptionValues.INCREMENTAL, PossibleArgs.INCREMENTAL_CAPTURE);
            possibleArgsArray = new PossibleArgs[]{PossibleArgs.ROOT_PKG_NAME, PossibleArgs.ROOT_PKG_PATTERN};
            OptionsProcessor.checkForMutuallyExclusiveOptions(artifactOptionsSet, possibleArgsArray);
            OptionsProcessor.checkForRequiredOptionCombination(artifactOptionsSet, PossibleArgs.ROOT_PKG_EXCLUSION, null, PossibleArgs.ROOT_PKG_PATTERN);
        }
    }

    private static void checkForMutuallyExclusiveOptions(ArtifactOptionsSet artifactOptionsSet, PossibleArgs[] possibleArgsArray) {
        for (int i10 = 0; i10 < possibleArgsArray.length; ++i10) {
            for (int i11 = i10 + 1; i11 < possibleArgsArray.length; ++i11) {
                PossibleArgs possibleArgs = possibleArgsArray[i10];
                PossibleArgs possibleArgs2 = possibleArgsArray[i11];
                if (possibleArgs == possibleArgs2 || !artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(possibleArgs) || !artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(possibleArgs2)) continue;
                artifactOptionsSet.addErrorMessage(Messages.getText("ERR_VERIFY_INVALID_COMBINATION", possibleArgs.externalOptionName(), possibleArgs2.externalOptionName()), true, false);
            }
        }
    }

    private static void checkIfInputFileExists(ArtifactOptionsSet artifactOptionsSet, PossibleArgs possibleArgs, String string) {
        String string2;
        if (!(null == string || null != (string2 = OptionsProcessor.getArtifactNameAndStatementSetName(string)[0]) && new File(string2).exists())) {
            artifactOptionsSet.addErrorMessage(Messages.getText("ERR_FILE_NOTFND", string2, possibleArgs.externalOptionName()), true, false);
        }
    }

    private static void checkForRequiredOptionCombination(ArtifactOptionsSet artifactOptionsSet, PossibleArgs possibleArgs, PossibleArgs.PredefinedOptionValues predefinedOptionValues, PossibleArgs possibleArgs2) {
        if (artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(possibleArgs) && !artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(possibleArgs2) && (null == predefinedOptionValues || predefinedOptionValues == artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(possibleArgs))) {
            artifactOptionsSet.addErrorMessage(Messages.getText("ERR_OPTION_REQUIRES_ANOTHER_OPTION", new Object[]{possibleArgs, possibleArgs2}), true, false);
        }
    }

    private static void checkJCCLevel(ArtifactOptionsSet artifactOptionsSet) {
        if (!Configuration.isJCCAtPrerequisiteLevel__ && Tool.GENERATOR != artifactOptionsSet.getTool() && !DataProperties.getProperty("pdq.disableJDBCPrerequisiteEnforcement").equalsIgnoreCase("true")) {
            boolean bl2 = false;
            PossibleArgs possibleArgs = null;
            Tool tool = artifactOptionsSet.getTool();
            if (Tool.BINDER == tool) {
                bl2 = true;
            } else {
                for (PossibleArgs[] possibleArgsArray : PossibleArgs.connectionOptions) {
                    String string;
                    PossibleArgs possibleArgs2 = possibleArgsArray[0];
                    if (!possibleArgs2.isAllowedForTool(tool)) continue;
                    if (artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(possibleArgs2)) {
                        string = artifactOptionsSet.getOptionOrArtifactSingleValueForErrorChecking(possibleArgs2);
                        if (null == possibleArgs) {
                            possibleArgs = possibleArgs2;
                        }
                    } else {
                        string = artifactOptionsSet.isOptionOrArtifactSpecifiedForErrorChecking(possibleArgsArray[1]) ? possibleArgs2.defaultValueString() : null;
                    }
                    if (null != string) {
                        bl2 |= "com.ibm.db2.jcc.DB2Driver".equals(string);
                    }
                    if (bl2) break;
                }
            }
            if (bl2) {
                String string;
                boolean bl3 = null != possibleArgs;
                String string2 = string = bl3 ? Messages.getText("MSG_OPTION_SPECIFIES_JCC", new Object[]{possibleArgs, artifactOptionsSet.getOptionOrArtifactSingleValue(possibleArgs), "IBM Data Server Driver for JDBC and SQLJ"}) + "  " : "";
                if (Configuration.isJCCPresent__) {
                    artifactOptionsSet.addErrorMessage(string + Configuration.getJCCVersionNotSupportedMessage(), bl3, false);
                } else {
                    artifactOptionsSet.addErrorMessage(string + Messages.getText("MSG_DRIVER_NOT_PRESENT", "IBM Data Server Driver for JDBC and SQLJ", "IBM InfoSphere Optim pureQuery Runtime", "3.57", "4.7"), bl3, false);
                }
            }
        }
    }

    private static boolean isArgAValue(String string, PossibleArgs possibleArgs) {
        boolean bl2 = null != possibleArgs && possibleArgs.isValueAllowedToStartWithDash();
        return null != string && (bl2 || 0 == string.length() || '-' != string.charAt(0)) && null == PossibleArgs.getValue(string);
    }

    public static boolean isPureQueryXmlFileExtensionValid(String string) {
        int n2 = string.length() - maximumSuffixLength;
        if (0 > n2) {
            n2 = 0;
        }
        String string2 = string.substring(n2).toLowerCase();
        for (String string3 : pureQueryXmlSuffixes) {
            if (!string2.endsWith(string3)) continue;
            return true;
        }
        return false;
    }

    public static PossibleArgs getArtifactTypeForOptionsFileLine(String string) {
        if (OptionsProcessor.isPureQueryXmlFileExtensionValid(string)) {
            return PossibleArgs.PUREQUERY_XML_FILE;
        }
        return PossibleArgs.INTERFACE;
    }

    public static String[] getArtifactNameAndStatementSetName(String string) {
        String[] stringArray = new String[2];
        if (null != string) {
            Matcher matcher = pdqxmlStatementSetPat.matcher(string);
            int n2 = -1;
            while (matcher.find()) {
                n2 = matcher.start(2);
            }
            if (0 <= n2) {
                stringArray[0] = string.substring(0, n2);
                stringArray[1] = string.substring(n2 + 1);
            } else {
                stringArray[0] = string;
                stringArray[1] = null;
            }
            if (null != stringArray[0]) {
                stringArray[0] = stringArray[0].trim();
            }
            if (null != stringArray[1]) {
                stringArray[1] = stringArray[1].trim();
            }
        }
        return stringArray;
    }

    private static BufferedInputStream getResourceOrFileAsBufferedInputStream(String string) throws Exception {
        return OptionsProcessor.getResourceOrFileAsBufferedInputStreamNonPriv(string);
    }

    private static BufferedInputStream getResourceOrFileAsBufferedInputStreamNonPriv(String string) throws FileNotFoundException {
        InputStream inputStream;
        ClassLoader classLoader = FileLoader.binderClassLoader.get();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (null == (inputStream = classLoader.getResourceAsStream(string))) {
            inputStream = new FileInputStream(string);
        }
        return new BufferedInputStream(inputStream);
    }

    public static void replaceOptionsFileValueInCommandLineArtifactOptionsSet(ArtifactOptionsSet artifactOptionsSet, String string) {
        artifactOptionsSet.replaceOptionOrArtifact(PossibleArgs.OPTIONS_FILE, string);
    }

    public static ArtifactOptionsSet getToolingArtifactOptionsSet(Tool tool, PossibleArgs possibleArgs, String string, String string2, String string3, String string4, String string5, List<String> list, boolean bl2) {
        String[] stringArray = OptionsProcessor.getArtifactNameAndStatementSetName(string);
        if (null != stringArray[1]) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_STATEMENT_SET_NAME_NOT_ALLOWED_IN_TOOLING_METHOD_INVOCATION", "getToolingArtifactOptionsSet", string, stringArray[1]), null, 10798);
        }
        if (null != string2) {
            string = string + ":" + string2;
        }
        ArtifactOptionsSet artifactOptionsSet = new ArtifactOptionsSet(tool, TypeOfOptions.COMMAND_LINE);
        if (null != string3) {
            artifactOptionsSet.addOptionOrArtifact(PossibleArgs.USERNAME, string3);
        }
        if (null != string4) {
            artifactOptionsSet.addOptionOrArtifact(PossibleArgs.PASSWORD, string4);
        }
        if (null != string5) {
            artifactOptionsSet.addOptionOrArtifact(PossibleArgs.URL, string5);
        }
        if (null != possibleArgs || null != string) {
            artifactOptionsSet.addOptionOrArtifact(possibleArgs, string);
        }
        if (Tool.MERGE == tool) {
            int n2 = 0;
            if (bl2) {
                n2 = 1;
                artifactOptionsSet.addOptionOrArtifact(PossibleArgs.BASE_FILE, list.get(0));
            }
            for (int i10 = n2; i10 < list.size(); ++i10) {
                artifactOptionsSet.addOptionOrArtifact(PossibleArgs.INPUT_PUREQUERY_XML, list.get(i10));
            }
        }
        return artifactOptionsSet;
    }

    public static ArtifactOptionsSet getMDMArtifactOptionsSetForGenerator(Properties properties, String string) {
        Tool tool = Tool.GENERATOR;
        HashMap<String, PossibleArgs> hashMap = new HashMap<String, PossibleArgs>();
        for (Object object : PossibleArgs.values()) {
            hashMap.put(object.externalOptionNameWithoutDash(), (PossibleArgs)((Object)object));
        }
        hashMap.put("url", PossibleArgs.URL);
        hashMap.put("user", PossibleArgs.USERNAME);
        hashMap.put("password", PossibleArgs.PASSWORD);
        hashMap.put("driverName", PossibleArgs.DRIVER_NAME);
        hashMap.put("rootPath", PossibleArgs.ROOT_PATH);
        hashMap.put("collection", PossibleArgs.COLLECTION);
        hashMap.put("noCleanup", PossibleArgs.NO_CLEANUP);
        hashMap.put("rootPkgName", PossibleArgs.ROOT_PKG_NAME);
        hashMap.put("userClasspath", PossibleArgs.USER_CLASSPATH);
        hashMap.put("xmlFile", PossibleArgs.XML_FILE_GENERATOR);
        hashMap.put("allowGetterSetterMethodWithPublicField", PossibleArgs.ALLOW_GETTER_SETTER_METHOD_WITH_PUBLIC_FIELD);
        hashMap.put("ignoreOrphanGetterSetterMethods", PossibleArgs.IGNORE_ORPHAN_GETTER_SETTER_METHODS);
        hashMap.put("allowMDMBeanRules", PossibleArgs.ALLOW_MDM_BEAN_RULES);
        hashMap.put("offlineGenerationMetadata", PossibleArgs.OFFLINE_GENERATION_METADATA);
        ArtifactOptionsSet artifactOptionsSet = new ArtifactOptionsSet(tool, TypeOfOptions.COMMAND_LINE);
        artifactOptionsSet.setArtifactToProcess(string, PossibleArgs.INTERFACE);
        block4: for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object object;
            object = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            PossibleArgs possibleArgs = (PossibleArgs)((Object)hashMap.get(object));
            if (null == possibleArgs || possibleArgs.isArtifact(tool)) continue;
            switch (possibleArgs) {
                case NO_CLEANUP: 
                case ALLOW_GETTER_SETTER_METHOD_WITH_PUBLIC_FIELD: 
                case IGNORE_ORPHAN_GETTER_SETTER_METHODS: 
                case ALLOW_MDM_BEAN_RULES: {
                    if ("true".equals(string2)) {
                        artifactOptionsSet.addOptionOrArtifact(possibleArgs, PossibleArgs.PredefinedOptionValues.TRUE);
                        continue block4;
                    }
                    artifactOptionsSet.addOptionOrArtifact(possibleArgs, PossibleArgs.PredefinedOptionValues.FALSE);
                    continue block4;
                }
            }
            artifactOptionsSet.addOptionOrArtifact(possibleArgs, string2);
        }
        return artifactOptionsSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean utilityHasArtifacts(Tool tool) {
        EnumMap<Tool, Boolean> enumMap = utilitiesHaveArtifacts_;
        synchronized (enumMap) {
            Boolean bl2 = utilitiesHaveArtifacts_.get((Object)tool);
            if (null == bl2) {
                bl2 = false;
                for (PossibleArgs possibleArgs : PossibleArgs.getValues(tool)) {
                    if (!possibleArgs.isArtifact(tool)) continue;
                    bl2 = true;
                    break;
                }
                utilitiesHaveArtifacts_.put(tool, bl2);
            }
            return bl2;
        }
    }

    private static class PdqXmlEntry {
        public int length_;
        public byte[] md5_;

        private PdqXmlEntry() {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof PdqXmlEntry)) {
                return false;
            }
            if (((PdqXmlEntry)object).length_ != this.length_) {
                return false;
            }
            byte[] byArray = ((PdqXmlEntry)object).md5_;
            if (byArray == null && this.md5_ != null) {
                return false;
            }
            if (byArray.length != this.md5_.length) {
                return false;
            }
            for (int i10 = 0; i10 < this.md5_.length; ++i10) {
                if (byArray[i10] == this.md5_[i10]) continue;
                return false;
            }
            return true;
        }
    }

    public static enum TypeOfOptions {
        COMMAND_LINE,
        OPTIONS_FILE_DEFAULT_OPTIONS,
        OPTIONS_FILE_GROUP_OPTIONS,
        OPTIONS_FILE_ARTIFACT_OPTIONS,
        MERGED_OPTIONS;

    }
}

