/*
 * Decompiled with CFR 0.152.
 */
package com.hotels.beeju;

import com.hotels.beeju.BeejuJUnitRule;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;

public class HiveMetaStoreJUnitRule
extends BeejuJUnitRule {
    private HiveMetaStoreClient client;

    public HiveMetaStoreJUnitRule() {
        this("test_database");
    }

    public HiveMetaStoreJUnitRule(String databaseName) {
        this(databaseName, null);
    }

    public HiveMetaStoreJUnitRule(String databaseName, Map<String, String> configuration) {
        super(databaseName, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeTest() throws Throwable {
        HiveConf hiveConf = new HiveConf((Configuration)this.conf, HiveMetaStoreClient.class);
        ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
        try {
            this.client = singleThreadExecutor.submit(new CallableHiveClient(hiveConf)).get();
        }
        finally {
            singleThreadExecutor.shutdown();
        }
    }

    @Override
    protected void afterTest() {
        this.client.close();
    }

    public HiveMetaStoreClient client() {
        return this.client;
    }

    private static class CallableHiveClient
    implements Callable<HiveMetaStoreClient> {
        private final HiveConf hiveConf;

        public CallableHiveClient(HiveConf hiveConf) {
            this.hiveConf = hiveConf;
        }

        @Override
        public HiveMetaStoreClient call() throws Exception {
            return new HiveMetaStoreClient(this.hiveConf);
        }
    }
}

