/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view.test;

import com.hortonworks.registries.cache.view.DataStoreBackedCache;
import com.hortonworks.registries.cache.view.service.CacheService;
import com.hortonworks.registries.cache.view.service.CacheServiceId;
import com.hortonworks.registries.cache.view.service.RedisCacheService;
import com.hortonworks.registries.cache.view.service.registry.CacheServiceLocalRegistry;
import com.hortonworks.registries.cache.view.service.registry.CacheServiceRegistry;
import java.util.HashMap;
import java.util.Map;

public class CacheClientMain {
    private static final CacheServiceRegistry cacheRegistry = CacheServiceLocalRegistry.INSTANCE;

    public static void main(String[] args) {
        CacheClientMain instance = new CacheClientMain();
        instance.registerCache(new CacheServiceId("id1"));
        instance.registerCache(new CacheServiceId("id2"));
        CacheService id1 = cacheRegistry.getCacheService(new CacheServiceId("id1"));
    }

    public void method() {
        CacheService cacheService = cacheRegistry.getCacheService(this.getDefaultRedisId());
        Object cache = cacheService.getCache("namespace");
        String val = (String)cache.get((String)"key");
        cache.put((String)"key", (String)"val");
        cache.putAll((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("key", "val");
                this.put("key1", "val1");
            }
        });
    }

    public void method1() {
        RedisCacheService cacheService = (RedisCacheService)cacheRegistry.getCacheService(this.getDefaultRedisId());
        DataStoreBackedCache cache = (DataStoreBackedCache)cacheService.getCache("");
        String val = (String)cache.get("key");
        cache.put("key", "val");
        cache.putAll(new HashMap<String, String>(){
            {
                this.put("key", "val");
                this.put("key1", "val1");
            }
        });
    }

    private CacheServiceId getDefaultRedisId() {
        return this.getRedisId("localhost", 6379);
    }

    private CacheServiceId getRedisId(String host, int port) {
        return CacheServiceId.redis(host, port);
    }

    public <K, V> void registerCache(CacheServiceId id) {
        cacheRegistry.register(id, new RedisCacheService.Builder(null, null, null).build());
    }
}

