/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view.service.registry;

import com.hortonworks.registries.cache.view.service.CacheService;
import com.hortonworks.registries.cache.view.service.CacheServiceId;
import com.hortonworks.registries.cache.view.service.registry.CacheServiceRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CacheServiceLocalRegistry implements CacheServiceRegistry
{
    INSTANCE;

    private static final Logger LOG;
    private final ConcurrentMap<CacheServiceId, CacheService<?, ?>> serviceIdToService = new ConcurrentHashMap();

    @Override
    public <K, V> void register(CacheServiceId cacheServiceId, CacheService<K, V> cacheService) {
        this.serviceIdToService.putIfAbsent(cacheServiceId, cacheService);
        LOG.info("Registered cache service [{}] with id [{}].", cacheService, (Object)cacheServiceId);
    }

    @Override
    public <K, V> CacheService<K, V> getCacheService(CacheServiceId cacheServiceId) {
        return (CacheService)this.serviceIdToService.get(cacheServiceId);
    }

    static {
        LOG = LoggerFactory.getLogger(CacheServiceLocalRegistry.class);
    }
}

