/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view.service;

import com.hortonworks.registries.cache.Cache;
import com.hortonworks.registries.cache.view.DataStoreBackedCache;
import com.hortonworks.registries.cache.view.config.TypeConfig;
import com.hortonworks.registries.cache.view.datastore.DataStoreReader;
import com.hortonworks.registries.cache.view.datastore.DataStoreWriter;
import com.hortonworks.registries.cache.view.io.loader.CacheLoader;
import com.hortonworks.registries.cache.view.io.loader.CacheLoaderFactory;
import com.hortonworks.registries.cache.view.io.writer.CacheWriter;
import com.hortonworks.registries.cache.view.service.CacheService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DataStoreBackedCacheService<K, V>
extends CacheService<K, V> {
    protected final CacheLoaderFactory<K, V> cacheLoaderFactory;
    protected final CacheWriter<K, V> cacheWriter;
    protected final DataStoreReader<K, V> dataStoreReader;
    protected final ConcurrentMap<String, CacheLoader<K, V>> cacheLoaders = new ConcurrentHashMap<String, CacheLoader<K, V>>();

    protected DataStoreBackedCacheService(Builder<K, V> builder) {
        super(builder);
        this.cacheLoaderFactory = ((Builder)builder).cacheLoaderFactory;
        this.cacheWriter = ((Builder)builder).cacheWriter;
        this.dataStoreReader = ((Builder)builder).dataStoreReader;
    }

    @Override
    public void registerCache(String id, Cache<K, V> cache) {
        if (this.isDataStoreBacked()) {
            this.caches.putIfAbsent(this.id, this.createDataStoreBackedCache(id, cache));
        } else {
            super.registerCache(id, cache);
        }
    }

    private DataStoreBackedCache<K, V> createDataStoreBackedCache(String id, Cache<K, V> cache) {
        CacheLoader<K, V> cacheLoader;
        CacheLoader<K, V> cacheLoader2 = cacheLoader = this.cacheLoaderFactory == null ? null : this.cacheLoaderFactory.create(cache, this.dataStoreReader);
        if (cacheLoader != null) {
            this.cacheLoaders.putIfAbsent(id, cacheLoader);
        }
        return new DataStoreBackedCache<K, V>(cache, cacheLoader, this.dataStoreReader, this.cacheWriter);
    }

    public CacheLoader<K, V> getCacheLoader(String cacheId) {
        return (CacheLoader)this.cacheLoaders.get(cacheId);
    }

    public DataStoreWriter<K, V> getCacheWriter() {
        return this.cacheWriter;
    }

    public DataStoreReader<K, V> getDataStoreReader() {
        return this.dataStoreReader;
    }

    public boolean isDataStoreBacked() {
        return this.dataStoreReader != null || this.cacheWriter != null || this.cacheLoaderFactory != null;
    }

    public static class Builder<K, V>
    extends CacheService.Builder<K, V> {
        private CacheLoaderFactory<K, V> cacheLoaderFactory;
        private CacheWriter<K, V> cacheWriter;
        private DataStoreReader<K, V> dataStoreReader;

        public Builder(String id, TypeConfig.Cache cacheType) {
            super(id, cacheType);
        }

        public Builder<K, V> setCacheLoaderFactory(CacheLoaderFactory<K, V> cacheLoaderFactory) {
            this.cacheLoaderFactory = cacheLoaderFactory;
            return this;
        }

        public Builder<K, V> setCacheWriter(CacheWriter<K, V> cacheWriter) {
            this.cacheWriter = cacheWriter;
            return this;
        }

        public Builder<K, V> setDataStoreReader(DataStoreReader<K, V> dataStoreReader) {
            this.dataStoreReader = dataStoreReader;
            return this;
        }

        @Override
        public DataStoreBackedCacheService<K, V> build() {
            return new DataStoreBackedCacheService(this);
        }
    }
}

