/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view.service;

import com.hortonworks.registries.cache.Cache;
import com.hortonworks.registries.cache.view.config.ExpiryPolicy;
import com.hortonworks.registries.cache.view.config.TypeConfig;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CacheService<K, V> {
    protected final ConcurrentMap<String, Cache<K, V>> caches = new ConcurrentHashMap<String, Cache<K, V>>();
    protected final String id;
    protected final TypeConfig.Cache cacheType;
    protected ExpiryPolicy expiryPolicy;

    public CacheService(String id, TypeConfig.Cache cacheType) {
        this.id = id;
        this.cacheType = cacheType;
    }

    protected CacheService(Builder<K, V> builder) {
        this.id = ((Builder)builder).id;
        this.cacheType = ((Builder)builder).cacheType;
        this.expiryPolicy = ((Builder)builder).expiryPolicy;
    }

    public <T extends Cache<K, V>> T getCache(String namespace) {
        return (T)((Cache)this.caches.get(namespace));
    }

    public void registerCache(String id, Cache<K, V> cache) {
        this.caches.putIfAbsent(id, cache);
    }

    public String getServiceId() {
        return this.id;
    }

    public TypeConfig.Cache getCacheType() {
        return this.cacheType;
    }

    public Set<String> getCacheIds() {
        return this.caches.keySet();
    }

    public ExpiryPolicy getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public static class Builder<K, V> {
        private final String id;
        private final TypeConfig.Cache cacheType;
        private ExpiryPolicy expiryPolicy;

        public Builder(String id, TypeConfig.Cache cacheType) {
            this.id = id;
            this.cacheType = cacheType;
        }

        public Builder<K, V> setExpiryPolicy(ExpiryPolicy expiryPolicy) {
            this.expiryPolicy = expiryPolicy;
            return this;
        }

        public CacheService<K, V> build() {
            return new CacheService(this);
        }
    }
}

