/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view.io.writer;

import com.hortonworks.registries.cache.view.datastore.DataStoreWriter;
import com.hortonworks.registries.cache.view.io.writer.CacheWriter;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CacheWriterAsync<K, V>
implements CacheWriter<K, V> {
    private static final int DEFAULT_NUM_THREADS = 5;
    private final DataStoreWriter<K, V> dataStoreWriter;
    private final ExecutorService executorService;

    public CacheWriterAsync(DataStoreWriter<K, V> dataStoreWriter) {
        this(dataStoreWriter, Executors.newFixedThreadPool(5));
    }

    public CacheWriterAsync(DataStoreWriter<K, V> dataStoreWriter, ExecutorService executorService) {
        this.dataStoreWriter = dataStoreWriter;
        this.executorService = executorService;
    }

    @Override
    public void write(K key, V val) {
        this.executorService.submit(new DataStoreWriteRunnable(key, val));
    }

    @Override
    public void writeAll(Map<? extends K, ? extends V> entries) {
        this.executorService.submit(new DataStoreWriteRunnable(entries));
    }

    @Override
    public void delete(K key) {
        this.executorService.submit(new DataStoreDeleteRunnable(key));
    }

    @Override
    public void deleteAll(Collection<? extends K> keys) {
        this.executorService.submit(new DataStoreDeleteRunnable(keys));
    }

    private class DataStoreDeleteRunnable
    implements Runnable {
        private Collection<? extends K> keys;
        private K key;

        public DataStoreDeleteRunnable(K key) {
            this.key = key;
        }

        public DataStoreDeleteRunnable(Collection<? extends K> keys) {
            this.keys = keys;
        }

        @Override
        public void run() {
            if (this.keys != null) {
                CacheWriterAsync.this.dataStoreWriter.deleteAll(this.keys);
            } else {
                CacheWriterAsync.this.dataStoreWriter.delete(this.key);
            }
        }
    }

    private class DataStoreWriteRunnable
    implements Runnable {
        private Map<? extends K, ? extends V> entries;
        private K key;
        private V val;

        public DataStoreWriteRunnable(K key, V val) {
            this.key = key;
            this.val = val;
        }

        public DataStoreWriteRunnable(Map<? extends K, ? extends V> entries) {
            this.entries = entries;
        }

        @Override
        public void run() {
            if (this.entries != null) {
                CacheWriterAsync.this.dataStoreWriter.writeAll(this.entries);
            } else {
                CacheWriterAsync.this.dataStoreWriter.write(this.key, this.val);
            }
        }
    }
}

