/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view.impl.redis;

import com.hortonworks.registries.cache.AbstractCache;
import com.hortonworks.registries.cache.Cache;
import com.hortonworks.registries.cache.view.config.ExpiryPolicy;
import com.lambdaworks.redis.RedisConnection;
import java.util.Collection;

public abstract class RedisAbstractCache<K, V>
extends AbstractCache<K, V>
implements Cache<K, V> {
    public static final String REDIS_MAX_MEMORY = "maxmemory";
    public static final String REDIS_MAX_MEMORY_POLICY = "maxmemory-policy";
    public static final String REDIS_MAX_MEMORY_POLICY_ALL_KEYS_LRU = "allkeys-lru";
    protected final RedisConnection<K, V> redisConnection;

    public RedisAbstractCache(RedisConnection<K, V> redisConnection) {
        this(redisConnection, null);
    }

    public RedisAbstractCache(RedisConnection<K, V> redisConnection, ExpiryPolicy expiryPolicy) {
        super(expiryPolicy);
        this.redisConnection = redisConnection;
        this.setMaxSize();
    }

    protected void setMaxSize() {
        if (this.expiryPolicy.isSize()) {
            this.redisConnection.configSet(REDIS_MAX_MEMORY, String.valueOf(this.expiryPolicy.getSize().getBytes()));
            this.redisConnection.configSet(REDIS_MAX_MEMORY_POLICY, REDIS_MAX_MEMORY_POLICY_ALL_KEYS_LRU);
        }
    }

    protected void setExpiryPolicy(K key) {
        if (this.expiryPolicy.isTtl()) {
            this.redisConnection.expire(key, this.expiryPolicy.getTtl().getTtlSeconds());
        }
    }

    protected void setExpiryPolicy(Collection<? extends K> keys) {
        if (this.expiryPolicy.isTtl()) {
            for (K key : keys) {
                this.redisConnection.expire(key, this.expiryPolicy.getTtl().getTtlSeconds());
            }
        }
    }
}

