/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.cache.view;

import com.hortonworks.registries.cache.AbstractCache;
import com.hortonworks.registries.cache.Cache;
import com.hortonworks.registries.cache.LoadableCache;
import com.hortonworks.registries.cache.exception.CacheException;
import com.hortonworks.registries.cache.stats.CacheStats;
import com.hortonworks.registries.cache.view.datastore.DataStoreReader;
import com.hortonworks.registries.cache.view.datastore.DataStoreWriter;
import com.hortonworks.registries.cache.view.io.loader.CacheLoader;
import com.hortonworks.registries.cache.view.io.loader.CacheLoaderCallback;
import com.hortonworks.registries.cache.view.io.writer.CacheWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreBackedCache<K, V>
extends AbstractCache<K, V>
implements LoadableCache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(DataStoreBackedCache.class);
    private final Cache<K, V> cache;
    private final CacheLoader<K, V> cacheLoader;
    private final CacheWriter<K, V> cacheWriter;
    private final DataStoreReader<K, V> dataStoreReader;

    public DataStoreBackedCache(Cache<K, V> cache, CacheLoader<K, V> cacheLoader, DataStoreReader<K, V> dataStoreReader, CacheWriter<K, V> cacheWriter) {
        this.validateArguments(cache, dataStoreReader, cacheLoader, cacheWriter);
        this.cache = cache;
        this.dataStoreReader = dataStoreReader;
        this.cacheLoader = cacheLoader;
        this.cacheWriter = cacheWriter;
    }

    @Override
    public void loadAll(Collection<? extends K> keys, CacheLoaderCallback<K, V> callback) {
        if (this.cacheLoader != null) {
            this.cacheLoader.loadAll(keys, callback);
        }
    }

    @Override
    public V get(K key) throws CacheException {
        V val = this.cache.get(key);
        if (val == null && this.dataStoreReader != null) {
            val = this.dataStoreReader.read(key);
        }
        return val;
    }

    @Override
    public void put(K key, V val) {
        this.cache.put(key, val);
        if (this.cacheWriter != null) {
            this.cacheWriter.write(key, val);
        }
    }

    @Override
    public Map<K, V> getAll(Collection<? extends K> keys) {
        Map<? extends K, V> present = this.cache.getAll(keys);
        if (this.dataStoreReader != null) {
            if (present == null || present.isEmpty()) {
                present = this.dataStoreReader.readAll(keys);
            } else if (present.size() < keys.size()) {
                HashSet<K> notPresent = new HashSet<K>(keys);
                notPresent.removeAll(present.keySet());
                Map<? extends K, V> loaded = this.dataStoreReader.readAll(notPresent);
                present.putAll(loaded);
            }
        }
        return present;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> entries) {
        this.cache.putAll(entries);
        if (this.cacheWriter != null) {
            this.cacheWriter.writeAll(entries);
        }
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
        if (this.cacheWriter != null) {
            this.cacheWriter.delete(key);
        }
    }

    @Override
    public void removeAll(Collection<? extends K> keys) {
        this.cache.removeAll(keys);
        if (this.cacheWriter != null) {
            this.cacheWriter.deleteAll(keys);
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
        LOG.info("Cache cleared. Entries only removed from cache but not from backing data store");
    }

    @Override
    public long size() {
        return this.cache.size();
    }

    @Override
    public CacheStats stats() {
        return this.cache.stats();
    }

    @Override
    public String toString() {
        return "DataStoreBackedCache{cache=" + this.cache + ", cacheLoader=" + this.cacheLoader + ", cacheWriter=" + this.cacheWriter + ", dataStore=" + this.dataStoreReader + "} " + super.toString();
    }

    private void validateArguments(Cache<K, V> cache, DataStoreReader<K, V> dataStore, CacheLoader<K, V> cacheLoader, DataStoreWriter<K, V> dataStoreWriter) {
        if (cache == null) {
            throw new IllegalArgumentException("Cache reference cannot be null");
        }
        if (dataStore == null && cacheLoader == null && dataStoreWriter == null) {
            throw new IllegalArgumentException(String.format("At least one non null implementation of %s,  %s, or  %s is required. If no backing data store is required consider using a non backed implementation of %s", this.getSimpleName(DataStoreReader.class), this.getSimpleName(DataStoreWriter.class), this.getSimpleName(CacheLoader.class), this.getSimpleName(Cache.class)));
        }
        LOG.info("Created {}", (Object)this);
    }

    private String getSimpleName(Class<?> clazz) {
        return clazz.getSimpleName();
    }
}

