/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.download.maven.plugin.internal.cache;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.client.cache.Resource;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class FileIndexResource
implements Resource {
    private final Path path;
    private final Path cacheDir;

    public FileIndexResource(Path path, Path cacheDir) {
        this.path = path;
        this.cacheDir = cacheDir;
    }

    public Path getPath() {
        return this.path;
    }

    public Path getFullPath() {
        return this.cacheDir.resolve(this.path);
    }

    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.getFullPath(), new OpenOption[0]);
    }

    public long length() {
        try {
            return Files.size(this.getFullPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void dispose() {
    }
}

