/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.api.DockerClient;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.BuildManifestListOrSingleManifestStep;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.builder.steps.CheckManifestStep;
import com.google.cloud.tools.jib.builder.steps.LoadDockerStep;
import com.google.cloud.tools.jib.builder.steps.LocalBaseImageSteps;
import com.google.cloud.tools.jib.builder.steps.ObtainBaseImageLayerStep;
import com.google.cloud.tools.jib.builder.steps.PreparedLayer;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.builder.steps.PushContainerConfigurationStep;
import com.google.cloud.tools.jib.builder.steps.PushImageStep;
import com.google.cloud.tools.jib.builder.steps.PushLayerStep;
import com.google.cloud.tools.jib.builder.steps.WriteTarFileStep;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.filesystem.TempDirectoryProvider;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.registry.ManifestAndDigest;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class StepsRunner {
    private final StepResults results = new StepResults();
    private final ExecutorService executorService;
    private final BuildContext buildContext;
    private final TempDirectoryProvider tempDirectoryProvider = new TempDirectoryProvider();
    private final List<Consumer<ProgressEventDispatcher.Factory>> stepsToRun = new ArrayList<Consumer<ProgressEventDispatcher.Factory>>();
    @Nullable
    private String rootProgressDescription;

    public static StepsRunner begin(BuildContext buildContext) {
        Object executorService = JibSystemProperties.serializeExecution() ? MoreExecutors.newDirectExecutorService() : buildContext.getExecutorService();
        return new StepsRunner(MoreExecutors.listeningDecorator((ExecutorService)executorService), buildContext);
    }

    private static <E> List<E> realizeFutures(Collection<Future<E>> futures) throws InterruptedException, ExecutionException {
        ArrayList<E> values = new ArrayList<E>();
        for (Future<E> future : futures) {
            values.add(future.get());
        }
        return values;
    }

    @VisibleForTesting
    StepsRunner(ListeningExecutorService executorService, BuildContext buildContext) {
        this.executorService = executorService;
        this.buildContext = buildContext;
    }

    public StepsRunner dockerLoadSteps(DockerClient dockerClient) {
        this.rootProgressDescription = "building image to Docker daemon";
        this.addRetrievalSteps(true);
        this.stepsToRun.add(this::buildAndCacheApplicationLayers);
        this.stepsToRun.add(this::buildImages);
        this.stepsToRun.add(progressDispatcherFactory -> this.loadDocker(dockerClient, (ProgressEventDispatcher.Factory)progressDispatcherFactory));
        return this;
    }

    public StepsRunner tarBuildSteps(Path outputPath) {
        this.rootProgressDescription = "building image to tar file";
        this.addRetrievalSteps(true);
        this.stepsToRun.add(this::buildAndCacheApplicationLayers);
        this.stepsToRun.add(this::buildImages);
        this.stepsToRun.add(progressDispatcherFactory -> this.writeTarFile(outputPath, (ProgressEventDispatcher.Factory)progressDispatcherFactory));
        return this;
    }

    public StepsRunner registryPushSteps() {
        this.rootProgressDescription = "building images to registry";
        boolean layersRequiredLocally = this.buildContext.getAlwaysCacheBaseImage();
        this.stepsToRun.add(this::authenticateBearerPush);
        this.addRetrievalSteps(layersRequiredLocally);
        this.stepsToRun.add(this::buildAndCacheApplicationLayers);
        this.stepsToRun.add(this::buildImages);
        this.stepsToRun.add(this::buildManifestListOrSingleManifest);
        this.stepsToRun.add(this::pushBaseImagesLayers);
        this.stepsToRun.add(this::pushApplicationLayers);
        this.stepsToRun.add(this::pushContainerConfigurations);
        this.stepsToRun.add(this::checkManifestInTargetRegistry);
        this.stepsToRun.add(this::pushImages);
        this.stepsToRun.add(this::pushManifestList);
        return this;
    }

    /*
     * Exception decompiling
     */
    public BuildResult run() throws ExecutionException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addRetrievalSteps(boolean layersRequiredLocally) {
        ImageConfiguration baseImageConfiguration = this.buildContext.getBaseImageConfiguration();
        if (baseImageConfiguration.getTarPath().isPresent()) {
            this.stepsToRun.add(this::extractTar);
        } else if (baseImageConfiguration.getDockerClient().isPresent()) {
            this.stepsToRun.add(this::saveDocker);
        } else {
            this.stepsToRun.add(this::pullBaseImages);
            this.stepsToRun.add(progressDispatcherFactory -> this.obtainBaseImagesLayers(layersRequiredLocally, (ProgressEventDispatcher.Factory)progressDispatcherFactory));
        }
    }

    private void authenticateBearerPush(ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.targetRegistryClient = this.executorService.submit(new AuthenticatePushStep(this.buildContext, progressDispatcherFactory));
    }

    private void saveDocker(ProgressEventDispatcher.Factory progressDispatcherFactory) {
        Optional<DockerClient> dockerClient = this.buildContext.getBaseImageConfiguration().getDockerClient();
        Preconditions.checkArgument((boolean)dockerClient.isPresent());
        this.assignLocalImageResult(this.executorService.submit(LocalBaseImageSteps.retrieveDockerDaemonLayersStep(this.buildContext, progressDispatcherFactory, dockerClient.get(), this.tempDirectoryProvider)));
    }

    private void extractTar(ProgressEventDispatcher.Factory progressDispatcherFactory) {
        Optional<Path> tarPath = this.buildContext.getBaseImageConfiguration().getTarPath();
        Preconditions.checkArgument((boolean)tarPath.isPresent());
        this.assignLocalImageResult(this.executorService.submit(LocalBaseImageSteps.retrieveTarLayersStep(this.buildContext, progressDispatcherFactory, tarPath.get(), this.tempDirectoryProvider)));
    }

    private void assignLocalImageResult(Future<LocalBaseImageSteps.LocalImage> localImage) {
        this.results.baseImagesAndRegistryClient = this.executorService.submit(() -> LocalBaseImageSteps.returnImageAndRegistryClientStep(StepsRunner.realizeFutures(((LocalBaseImageSteps.LocalImage)localImage.get()).layers), ((LocalBaseImageSteps.LocalImage)localImage.get()).configurationTemplate).call());
        this.results.baseImagesAndLayers = this.executorService.submit(() -> Collections.singletonMap(((PullBaseImageStep.ImagesAndRegistryClient)((StepResults)this.results).baseImagesAndRegistryClient.get()).images.get(0), ((LocalBaseImageSteps.LocalImage)localImage.get()).layers));
    }

    @VisibleForTesting
    void pullBaseImages(ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.baseImagesAndRegistryClient = this.executorService.submit(new PullBaseImageStep(this.buildContext, progressDispatcherFactory));
    }

    private void obtainBaseImagesLayers(boolean layersRequiredLocally, ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.baseImagesAndLayers = this.executorService.submit(() -> {
            ProgressEventDispatcher progressDispatcher = progressDispatcherFactory.create("scheduling obtaining base images layers", ((PullBaseImageStep.ImagesAndRegistryClient)((StepResults)this.results).baseImagesAndRegistryClient.get()).images.size());
            Throwable throwable = null;
            try {
                HashMap<DescriptorDigest, Future<PreparedLayer>> preparedLayersCache = new HashMap<DescriptorDigest, Future<PreparedLayer>>();
                LinkedHashMap<Image, List<Future<PreparedLayer>>> baseImagesAndLayers = new LinkedHashMap<Image, List<Future<PreparedLayer>>>();
                for (Image baseImage : ((PullBaseImageStep.ImagesAndRegistryClient)((StepResults)this.results).baseImagesAndRegistryClient.get()).images) {
                    List<Future<PreparedLayer>> layers = this.obtainBaseImageLayers(baseImage, layersRequiredLocally, preparedLayersCache, progressDispatcher.newChildProducer());
                    baseImagesAndLayers.put(baseImage, layers);
                }
                LinkedHashMap<Image, List<Future<PreparedLayer>>> linkedHashMap = baseImagesAndLayers;
                return linkedHashMap;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (progressDispatcher != null) {
                    StepsRunner.$closeResource(throwable, progressDispatcher);
                }
            }
        });
    }

    @VisibleForTesting
    List<Future<PreparedLayer>> obtainBaseImageLayers(Image baseImage, boolean layersRequiredLocally, Map<DescriptorDigest, Future<PreparedLayer>> preparedLayersCache, ProgressEventDispatcher.Factory progressDispatcherFactory) throws InterruptedException, ExecutionException {
        ArrayList<Future<PreparedLayer>> preparedLayers = new ArrayList<Future<PreparedLayer>>();
        try (ProgressEventDispatcher progressDispatcher = progressDispatcherFactory.create("launching base image layer pullers", baseImage.getLayers().size());){
            for (Layer layer : baseImage.getLayers()) {
                DescriptorDigest digest = layer.getBlobDescriptor().getDigest();
                Future<PreparedLayer> preparedLayer = preparedLayersCache.get(digest);
                if (preparedLayer != null) {
                    progressDispatcher.dispatchProgress(1L);
                } else {
                    preparedLayer = this.executorService.submit(layersRequiredLocally ? ObtainBaseImageLayerStep.forForcedDownload(this.buildContext, progressDispatcher.newChildProducer(), layer, ((PullBaseImageStep.ImagesAndRegistryClient)((StepResults)this.results).baseImagesAndRegistryClient.get()).registryClient) : ObtainBaseImageLayerStep.forSelectiveDownload(this.buildContext, progressDispatcher.newChildProducer(), layer, ((PullBaseImageStep.ImagesAndRegistryClient)((StepResults)this.results).baseImagesAndRegistryClient.get()).registryClient, (RegistryClient)this.results.targetRegistryClient.get()));
                    preparedLayersCache.put(digest, preparedLayer);
                }
                preparedLayers.add(preparedLayer);
            }
            Object object = preparedLayers;
            return object;
        }
    }

    private void pushBaseImagesLayers(ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.baseImagesAndLayerPushResults = this.executorService.submit(() -> {
            ProgressEventDispatcher progressDispatcher = progressDispatcherFactory.create("scheduling pushing base images layers", ((Map)this.results.baseImagesAndLayers.get()).size());
            Throwable throwable = null;
            try {
                LinkedHashMap<Image, List<Future<BlobDescriptor>>> layerPushResults = new LinkedHashMap<Image, List<Future<BlobDescriptor>>>();
                for (Map.Entry entry : ((Map)this.results.baseImagesAndLayers.get()).entrySet()) {
                    Image baseImage = (Image)entry.getKey();
                    List baseLayers = (List)entry.getValue();
                    List<Future<BlobDescriptor>> pushResults = this.pushBaseImageLayers(baseLayers, progressDispatcher.newChildProducer());
                    layerPushResults.put(baseImage, pushResults);
                }
                LinkedHashMap<Image, List<Future<BlobDescriptor>>> linkedHashMap = layerPushResults;
                return linkedHashMap;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (progressDispatcher != null) {
                    StepsRunner.$closeResource(throwable, progressDispatcher);
                }
            }
        });
    }

    private List<Future<BlobDescriptor>> pushBaseImageLayers(List<Future<PreparedLayer>> baseLayers, ProgressEventDispatcher.Factory progressDispatcherFactory) throws InterruptedException, ExecutionException {
        return this.scheduleCallables(PushLayerStep.makeList(this.buildContext, progressDispatcherFactory, (RegistryClient)this.results.targetRegistryClient.get(), baseLayers));
    }

    private void buildAndCacheApplicationLayers(ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.applicationLayers = this.scheduleCallables(BuildAndCacheApplicationLayerStep.makeList(this.buildContext, progressDispatcherFactory));
    }

    private void buildImages(ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.baseImagesAndBuiltImages = this.executorService.submit(() -> {
            ProgressEventDispatcher progressDispatcher = progressDispatcherFactory.create("scheduling building manifests", ((Map)this.results.baseImagesAndLayers.get()).size());
            Throwable throwable = null;
            try {
                LinkedHashMap<Image, Future<Image>> baseImagesAndBuiltImages = new LinkedHashMap<Image, Future<Image>>();
                for (Map.Entry entry : ((Map)this.results.baseImagesAndLayers.get()).entrySet()) {
                    Image baseImage = (Image)entry.getKey();
                    List baseLayers = (List)entry.getValue();
                    Future<Image> builtImage = this.buildImage(baseImage, baseLayers, progressDispatcher.newChildProducer());
                    baseImagesAndBuiltImages.put(baseImage, builtImage);
                }
                LinkedHashMap<Image, Future<Image>> linkedHashMap = baseImagesAndBuiltImages;
                return linkedHashMap;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (progressDispatcher != null) {
                    StepsRunner.$closeResource(throwable, progressDispatcher);
                }
            }
        });
    }

    private Future<Image> buildImage(Image baseImage, List<Future<PreparedLayer>> baseLayers, ProgressEventDispatcher.Factory progressDispatcherFactory) {
        return this.executorService.submit(() -> new BuildImageStep(this.buildContext, progressDispatcherFactory, baseImage, StepsRunner.realizeFutures(baseLayers), StepsRunner.realizeFutures((Collection)Verify.verifyNotNull((Object)this.results.applicationLayers))).call());
    }

    private void buildManifestListOrSingleManifest(ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.manifestListOrSingleManifest = this.executorService.submit(() -> new BuildManifestListOrSingleManifestStep(this.buildContext, progressDispatcherFactory, StepsRunner.realizeFutures(((Map)this.results.baseImagesAndBuiltImages.get()).values())).call());
    }

    private void pushContainerConfigurations(ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.baseImagesAndContainerConfigPushResults = this.executorService.submit(() -> {
            ProgressEventDispatcher progressDispatcher = progressDispatcherFactory.create("scheduling pushing container configurations", ((Map)this.results.baseImagesAndBuiltImages.get()).size());
            Throwable throwable = null;
            try {
                LinkedHashMap<Image, Future<BlobDescriptor>> configPushResults = new LinkedHashMap<Image, Future<BlobDescriptor>>();
                for (Map.Entry entry : ((Map)this.results.baseImagesAndBuiltImages.get()).entrySet()) {
                    Image baseImage = (Image)entry.getKey();
                    Future builtImage = (Future)entry.getValue();
                    Future<BlobDescriptor> pushResult = this.pushContainerConfiguration(builtImage, progressDispatcher.newChildProducer());
                    configPushResults.put(baseImage, pushResult);
                }
                LinkedHashMap<Image, Future<BlobDescriptor>> linkedHashMap = configPushResults;
                return linkedHashMap;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (progressDispatcher != null) {
                    StepsRunner.$closeResource(throwable, progressDispatcher);
                }
            }
        });
    }

    private Future<BlobDescriptor> pushContainerConfiguration(Future<Image> builtImage, ProgressEventDispatcher.Factory progressDispatcherFactory) {
        return this.executorService.submit(() -> new PushContainerConfigurationStep(this.buildContext, progressDispatcherFactory, (RegistryClient)this.results.targetRegistryClient.get(), (Image)builtImage.get()).call());
    }

    private void pushApplicationLayers(ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.applicationLayerPushResults = this.executorService.submit(() -> this.scheduleCallables(PushLayerStep.makeList(this.buildContext, progressDispatcherFactory, (RegistryClient)this.results.targetRegistryClient.get(), (List)Verify.verifyNotNull((Object)this.results.applicationLayers))));
    }

    private void checkManifestInTargetRegistry(ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.manifestCheckResult = this.executorService.submit(() -> new CheckManifestStep(this.buildContext, progressDispatcherFactory, (RegistryClient)this.results.targetRegistryClient.get(), (ManifestTemplate)this.results.manifestListOrSingleManifest.get()).call());
    }

    private void pushImages(ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.imagePushResults = this.executorService.submit(() -> {
            ProgressEventDispatcher progressDispatcher = progressDispatcherFactory.create("scheduling pushing manifests", ((Map)this.results.baseImagesAndBuiltImages.get()).size());
            Throwable throwable = null;
            try {
                StepsRunner.realizeFutures((Collection)this.results.applicationLayerPushResults.get());
                ArrayList<Future<BuildResult>> buildResults = new ArrayList<Future<BuildResult>>();
                for (Map.Entry entry : ((Map)this.results.baseImagesAndBuiltImages.get()).entrySet()) {
                    Image baseImage = (Image)entry.getKey();
                    Future builtImage = (Future)entry.getValue();
                    buildResults.add(this.pushImage(baseImage, builtImage, progressDispatcher.newChildProducer()));
                }
                ArrayList<Future<BuildResult>> arrayList = buildResults;
                return arrayList;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (progressDispatcher != null) {
                    StepsRunner.$closeResource(throwable, progressDispatcher);
                }
            }
        });
    }

    private Future<BuildResult> pushImage(Image baseImage, Future<Image> builtImage, ProgressEventDispatcher.Factory progressDispatcherFactory) {
        return this.executorService.submit(() -> {
            StepsRunner.realizeFutures((Collection)Verify.verifyNotNull((Object)((List)((Map)this.results.baseImagesAndLayerPushResults.get()).get(baseImage))));
            Future containerConfigPushResult = (Future)((Map)this.results.baseImagesAndContainerConfigPushResults.get()).get(baseImage);
            List manifestPushResults = this.scheduleCallables(PushImageStep.makeList(this.buildContext, progressDispatcherFactory, (RegistryClient)this.results.targetRegistryClient.get(), (BlobDescriptor)((Future)Verify.verifyNotNull((Object)containerConfigPushResult)).get(), (Image)builtImage.get(), ((Optional)this.results.manifestCheckResult.get()).isPresent()));
            StepsRunner.realizeFutures(manifestPushResults);
            return manifestPushResults.isEmpty() ? new BuildResult(((ManifestAndDigest)((Optional)this.results.manifestCheckResult.get()).get()).getDigest(), ((BlobDescriptor)((Future)Verify.verifyNotNull((Object)containerConfigPushResult)).get()).getDigest(), this.isImagePushed((Optional)this.results.manifestCheckResult.get())) : (BuildResult)manifestPushResults.get(0).get();
        });
    }

    @VisibleForTesting
    boolean isImagePushed(Optional<ManifestAndDigest<ManifestTemplate>> manifestResult) {
        return !JibSystemProperties.skipExistingImages() || !manifestResult.isPresent();
    }

    private void pushManifestList(ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.buildResult = this.executorService.submit(() -> {
            StepsRunner.realizeFutures((Collection)this.results.imagePushResults.get());
            List manifestListPushResults = this.scheduleCallables(PushImageStep.makeListForManifestList(this.buildContext, progressDispatcherFactory, (RegistryClient)this.results.targetRegistryClient.get(), (ManifestTemplate)this.results.manifestListOrSingleManifest.get(), ((Optional)this.results.manifestCheckResult.get()).isPresent()));
            StepsRunner.realizeFutures(manifestListPushResults);
            return manifestListPushResults.isEmpty() ? (BuildResult)((Future)((List)this.results.imagePushResults.get()).get(0)).get() : (BuildResult)manifestListPushResults.get(0).get();
        });
    }

    private void loadDocker(DockerClient dockerClient, ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.buildResult = this.executorService.submit(() -> {
            Verify.verify((((Map)this.results.baseImagesAndBuiltImages.get()).size() == 1 ? 1 : 0) != 0, (String)"multi-platform image building not supported when pushing to Docker engine", (Object[])new Object[0]);
            Image builtImage = (Image)((Future)((Map)this.results.baseImagesAndBuiltImages.get()).values().iterator().next()).get();
            return new LoadDockerStep(this.buildContext, progressDispatcherFactory, dockerClient, builtImage).call();
        });
    }

    private void writeTarFile(Path outputPath, ProgressEventDispatcher.Factory progressDispatcherFactory) {
        this.results.buildResult = this.executorService.submit(() -> {
            Verify.verify((((Map)this.results.baseImagesAndBuiltImages.get()).size() == 1 ? 1 : 0) != 0, (String)"multi-platform image building not supported when building a local tar image", (Object[])new Object[0]);
            Image builtImage = (Image)((Future)((Map)this.results.baseImagesAndBuiltImages.get()).values().iterator().next()).get();
            return new WriteTarFileStep(this.buildContext, progressDispatcherFactory, outputPath, builtImage).call();
        });
    }

    private <E> List<Future<E>> scheduleCallables(ImmutableList<? extends Callable<E>> callables) {
        return callables.stream().map(this.executorService::submit).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$run$2(ProgressEventDispatcher progressEventDispatcher, Consumer step) {
        step.accept(progressEventDispatcher.newChildProducer());
    }

    private static class StepResults {
        @Nullable
        private List<Future<PreparedLayer>> applicationLayers;
        private Future<ManifestTemplate> manifestListOrSingleManifest = StepResults.failedFuture();
        private Future<RegistryClient> targetRegistryClient = StepResults.failedFuture();
        private Future<List<Future<BlobDescriptor>>> applicationLayerPushResults = StepResults.failedFuture();
        private Future<Optional<ManifestAndDigest<ManifestTemplate>>> manifestCheckResult = StepResults.failedFuture();
        private Future<List<Future<BuildResult>>> imagePushResults = StepResults.failedFuture();
        private Future<BuildResult> buildResult = StepResults.failedFuture();
        private Future<PullBaseImageStep.ImagesAndRegistryClient> baseImagesAndRegistryClient = StepResults.failedFuture();
        private Future<Map<Image, List<Future<PreparedLayer>>>> baseImagesAndLayers = StepResults.failedFuture();
        private Future<Map<Image, List<Future<BlobDescriptor>>>> baseImagesAndLayerPushResults = StepResults.failedFuture();
        private Future<Map<Image, Future<BlobDescriptor>>> baseImagesAndContainerConfigPushResults = StepResults.failedFuture();
        private Future<Map<Image, Future<Image>>> baseImagesAndBuiltImages = StepResults.failedFuture();

        private StepResults() {
        }

        private static <E> Future<E> failedFuture() {
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("invalid usage; required step not configured"));
        }

        static /* synthetic */ Future access$100(StepResults x0) {
            return x0.buildResult;
        }
    }
}

