/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.values;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.HashMultiset;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Multiset;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.io.Serializable;
import java.util.Map;
import java.util.Random;

public class TupleTag<V>
implements Serializable {
    static final Random RANDOM = new Random(0L);
    private static final Multiset<String> staticInits = HashMultiset.create();
    final String id;
    final boolean generated;

    public TupleTag() {
        this(TupleTag.genId(), true);
    }

    public TupleTag(String id) {
        this(id, false);
    }

    public String getId() {
        return this.id;
    }

    public String getOutName(int outIndex) {
        if (this.generated) {
            return "out" + outIndex;
        }
        return this.id;
    }

    public TypeDescriptor<V> getTypeDescriptor() {
        return new TypeDescriptor<V>(this.getClass()){};
    }

    static synchronized String genId() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement frame : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!frame.getMethodName().equals("<clinit>")) continue;
            int counter = staticInits.add(frame.getClassName(), 1);
            return frame.getClassName() + "#" + counter;
        }
        String nonce = Long.toHexString(RANDOM.nextLong());
        String caller = stackTrace.length >= 4 ? stackTrace[3].getClassName() + "." + stackTrace[3].getMethodName() + ":" + stackTrace[3].getLineNumber() : "unknown";
        return caller + "#" + nonce;
    }

    @JsonCreator
    private static TupleTag<?> fromJson(@JsonProperty(value="value") String id, @JsonProperty(value="is_generated") boolean generated) {
        return new TupleTag(id, generated);
    }

    private TupleTag(String id, boolean generated) {
        this.id = id;
        this.generated = generated;
    }

    public CloudObject asCloudObject() {
        CloudObject result = CloudObject.forClass(this.getClass());
        Structs.addString((Map<String, Object>)((Object)result), "value", this.id);
        Structs.addBoolean((Map<String, Object>)((Object)result), "is_generated", this.generated);
        return result;
    }

    public boolean equals(Object that) {
        if (that instanceof TupleTag) {
            return this.id.equals(((TupleTag)that).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Tag<" + this.id + ">";
    }
}

