/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.values;

import com.google.cloud.dataflow.sdk.Pipeline;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.transforms.AppliedPTransform;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.values.PCollection;
import com.google.cloud.dataflow.sdk.values.PInput;
import com.google.cloud.dataflow.sdk.values.POutput;
import com.google.cloud.dataflow.sdk.values.PValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PCollectionList<T>
implements PInput,
POutput {
    final Pipeline pipeline;
    final List<PCollection<T>> pcollections;

    public static <T> PCollectionList<T> empty(Pipeline pipeline) {
        return new PCollectionList<T>(pipeline);
    }

    public static <T> PCollectionList<T> of(PCollection<T> pc) {
        return new PCollectionList<T>(pc.getPipeline()).and(pc);
    }

    public static <T> PCollectionList<T> of(Iterable<PCollection<T>> pcs) {
        Iterator<PCollection<T>> pcsIter = pcs.iterator();
        if (!pcsIter.hasNext()) {
            throw new IllegalArgumentException("must either have a non-empty list of PCollections, or must first call empty(Pipeline)");
        }
        return new PCollectionList<T>(pcsIter.next().getPipeline()).and(pcs);
    }

    public PCollectionList<T> and(PCollection<T> pc) {
        if (pc.getPipeline() != this.pipeline) {
            throw new IllegalArgumentException("PCollections come from different Pipelines");
        }
        return new PCollectionList<T>(this.pipeline, ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.pcollections)).add(pc)).build());
    }

    public PCollectionList<T> and(Iterable<PCollection<T>> pcs) {
        ArrayList<PCollection<T>> copy = new ArrayList<PCollection<T>>(this.pcollections);
        for (PCollection<T> pc : pcs) {
            if (pc.getPipeline() != this.pipeline) {
                throw new IllegalArgumentException("PCollections come from different Pipelines");
            }
            copy.add(pc);
        }
        return new PCollectionList<T>(this.pipeline, copy);
    }

    public int size() {
        return this.pcollections.size();
    }

    public PCollection<T> get(int index) {
        return this.pcollections.get(index);
    }

    public List<PCollection<T>> getAll() {
        return this.pcollections;
    }

    public <OutputT extends POutput> OutputT apply(PTransform<PCollectionList<T>, OutputT> t) {
        return Pipeline.applyTransform(this, t);
    }

    public <OutputT extends POutput> OutputT apply(String name, PTransform<PCollectionList<T>, OutputT> t) {
        return Pipeline.applyTransform(name, this, t);
    }

    PCollectionList(Pipeline pipeline) {
        this(pipeline, new ArrayList<PCollection<T>>());
    }

    PCollectionList(Pipeline pipeline, List<PCollection<T>> pcollections) {
        this.pipeline = pipeline;
        this.pcollections = Collections.unmodifiableList(pcollections);
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public Collection<? extends PValue> expand() {
        return this.pcollections;
    }

    @Override
    public void recordAsOutput(AppliedPTransform<?, ?, ?> transform) {
        int i = 0;
        for (PCollection<T> pc : this.pcollections) {
            pc.recordAsOutput(transform, "out" + i);
            ++i;
        }
    }

    @Override
    public void finishSpecifying() {
        for (PCollection<T> pc : this.pcollections) {
            pc.finishSpecifying();
        }
    }

    @Override
    public void finishSpecifyingOutput() {
        for (PCollection<T> pc : this.pcollections) {
            pc.finishSpecifyingOutput();
        }
    }
}

