/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.state;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.HashBasedTable;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Table;
import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.StateContext;
import com.google.cloud.dataflow.sdk.util.state.StateNamespace;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import java.util.Map;
import java.util.Set;

public abstract class StateTable<K> {
    private final Table<StateNamespace, StateTag<? super K, ?>, State> stateTable = HashBasedTable.create();

    public <StateT extends State> StateT get(StateNamespace namespace, StateTag<? super K, StateT> tag, StateContext<?> c) {
        State storage = this.stateTable.get(namespace, tag);
        if (storage != null) {
            State typedStorage = storage;
            return (StateT)typedStorage;
        }
        StateT typedStorage = tag.bind(this.binderForNamespace(namespace, c));
        this.stateTable.put(namespace, tag, (State)typedStorage);
        return typedStorage;
    }

    public void clearNamespace(StateNamespace namespace) {
        this.stateTable.rowKeySet().remove(namespace);
    }

    public void clear() {
        this.stateTable.clear();
    }

    public Iterable<State> values() {
        return this.stateTable.values();
    }

    public boolean isNamespaceInUse(StateNamespace namespace) {
        return this.stateTable.containsRow(namespace);
    }

    public Map<StateTag<? super K, ?>, State> getTagsInUse(StateNamespace namespace) {
        return this.stateTable.row(namespace);
    }

    public Set<StateNamespace> getNamespacesInUse() {
        return this.stateTable.rowKeySet();
    }

    protected abstract StateTag.StateBinder<K> binderForNamespace(StateNamespace var1, StateContext<?> var2);
}

