/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common.worker;

import com.google.api.client.util.NanoClock;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.cloud.dataflow.sdk.util.common.Counter;
import com.google.cloud.dataflow.sdk.util.common.CounterSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StateSampler
implements Closeable {
    public static final SampleScheduler NOOP_SCHEDULER = new SampleScheduler(){

        @Override
        public Closeable scheduleSampling(StateSampler sampler) {
            return new Closeable(){

                @Override
                public void close() throws IOException {
                }
            };
        }
    };
    public static final long DEFAULT_SAMPLING_PERIOD_MS = 200L;
    private final String prefix;
    private final CounterSet.AddCounterMutator counterSetMutator;
    private ArrayList<Counter<Long>> countersByState = new ArrayList();
    private Map<String, Integer> statesByName = new HashMap<String, Integer>();
    private Map<Integer, StateKind> kindsByState = new HashMap<Integer, StateKind>();
    private volatile int currentState;
    public static final int DO_NOT_SAMPLE = -1;
    private volatile long stateTransitionCount;
    private long stateTimestampNs = 0L;
    private List<SamplingCallback> callbacks = new ArrayList<SamplingCallback>();
    private final Closeable sampleSchedule;
    private final NanoClock nanoClock;

    public StateSampler(String prefix, CounterSet.AddCounterMutator counterSetMutator, SampleScheduler scheduler, NanoClock nanoClock) {
        this.prefix = prefix;
        this.counterSetMutator = counterSetMutator;
        this.nanoClock = nanoClock;
        this.currentState = -1;
        this.stateTimestampNs = nanoClock.nanoTime();
        this.sampleSchedule = scheduler.scheduleSampling(this);
    }

    public StateSampler(String prefix, CounterSet.AddCounterMutator counterSetMutator, long samplingPeriodMs) {
        this(prefix, counterSetMutator, new DefaultScheduler(samplingPeriodMs), NanoClock.SYSTEM);
    }

    public StateSampler(String prefix, CounterSet.AddCounterMutator counterSetMutator) {
        this(prefix, counterSetMutator, 200L);
    }

    public synchronized void run() {
        long startTimestampNs = this.nanoClock.nanoTime();
        int state = this.currentState;
        if (state != -1) {
            StateKind kind = null;
            long elapsedMs = TimeUnit.NANOSECONDS.toMillis(startTimestampNs - this.stateTimestampNs);
            kind = this.kindsByState.get(state);
            this.countersByState.get(state).addValue(elapsedMs);
            for (SamplingCallback c : this.callbacks) {
                c.run(state, kind, elapsedMs);
            }
        }
        this.stateTimestampNs = startTimestampNs;
    }

    @Override
    public synchronized void close() throws IOException {
        this.currentState = -1;
        this.sampleSchedule.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stateForName(String name, StateKind kind) {
        if (name.isEmpty()) {
            return -1;
        }
        StateSampler stateSampler = this;
        synchronized (stateSampler) {
            StateKind originalKind;
            Integer state = this.statesByName.get(name);
            if (state == null) {
                String counterName = this.prefix + name + "-msecs";
                Counter<Long> counter = this.counterSetMutator.addCounter(Counter.longs(counterName, Counter.AggregationKind.SUM));
                state = this.countersByState.size();
                this.statesByName.put(name, state);
                this.countersByState.add(counter);
                this.kindsByState.put(state, kind);
            }
            if ((originalKind = this.kindsByState.get(state)) != kind) {
                throw new IllegalArgumentException("for state named " + name + ", requested kind " + (Object)((Object)kind) + " different from the original kind " + (Object)((Object)originalKind));
            }
            return state;
        }
    }

    public synchronized StateSamplerInfo getInfo() {
        return this.currentState == -1 ? null : new StateSamplerInfo(this.countersByState.get(this.currentState).getName(), this.stateTransitionCount, null);
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public int setState(int state) {
        long previousStateTransitionCount = this.stateTransitionCount;
        this.stateTransitionCount = previousStateTransitionCount + 1L;
        int previousState = this.currentState;
        this.currentState = state;
        return previousState;
    }

    public int setState(String name, StateKind kind) {
        return this.setState(this.stateForName(name, kind));
    }

    public ScopedState scopedState(int state) {
        return new ScopedState(this, this.setState(state));
    }

    public synchronized void addSamplingCallback(SamplingCallback callback) {
        this.callbacks.add(callback);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static interface SamplingCallback {
        public void run(int var1, StateKind var2, long var3);
    }

    public class ScopedState
    implements Closeable {
        private final StateSampler sampler;
        private final int previousState;
        private boolean closed = false;

        private ScopedState(StateSampler sampler, int previousState) {
            this.sampler = sampler;
            this.previousState = previousState;
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.closed = true;
                this.sampler.setState(this.previousState);
            }
        }
    }

    public static class StateSamplerInfo {
        public final String state;
        public final Long transitionCount;
        public final Long stateDurationMillis;

        public StateSamplerInfo(String state, Long transitionCount, Long stateDurationMillis) {
            this.state = state;
            this.transitionCount = transitionCount;
            this.stateDurationMillis = stateDurationMillis;
        }
    }

    public static enum StateKind {
        USER,
        FRAMEWORK;

    }

    @VisibleForTesting
    static final class DefaultScheduler
    implements SampleScheduler {
        private static final int NUM_EXECUTOR_THREADS = 16;
        private static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newScheduledThreadPool(16, new ThreadFactoryBuilder().setDaemon(true).build());
        private final long samplingPeriodMs;

        @VisibleForTesting
        DefaultScheduler(long samplingPeriodMs) {
            this.samplingPeriodMs = samplingPeriodMs;
        }

        @Override
        public Closeable scheduleSampling(final StateSampler sampler) {
            return new Closeable(){
                private ScheduledFuture<?> invocationFuture = null;
                private ScheduledFuture<?> invocationTriggerFuture = DefaultScheduler.access$200().scheduleAtFixedRate(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        long delay = ThreadLocalRandom.current().nextInt((int)DefaultScheduler.this.samplingPeriodMs);
                        StateSampler stateSampler = sampler;
                        synchronized (stateSampler) {
                            if (invocationFuture != null) {
                                invocationFuture.cancel(false);
                            }
                            invocationFuture = EXECUTOR_SERVICE.schedule(new Runnable(){

                                @Override
                                public void run() {
                                    sampler.run();
                                }
                            }, delay, TimeUnit.MILLISECONDS);
                        }
                    }
                }, 0L, DefaultScheduler.access$000(DefaultScheduler.this), TimeUnit.MILLISECONDS);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    StateSampler stateSampler = sampler;
                    synchronized (stateSampler) {
                        if (this.invocationTriggerFuture != null) {
                            this.invocationTriggerFuture.cancel(false);
                            this.invocationTriggerFuture = null;
                        }
                        if (this.invocationFuture != null) {
                            this.invocationFuture.cancel(false);
                            this.invocationFuture = null;
                        }
                    }
                }
            };
        }
    }

    public static interface SampleScheduler {
        public Closeable scheduleSampling(StateSampler var1);
    }
}

