/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Function;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Joiner;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.FluentIterable;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableSet;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Queues;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;

public class ReflectHelpers {
    private static final Joiner COMMA_SEPARATOR = Joiner.on(", ");
    public static final Function<Method, String> METHOD_FORMATTER = new Function<Method, String>(){

        @Override
        public String apply(Method input) {
            String parameterTypes = FluentIterable.from(Arrays.asList(input.getParameterTypes())).transform(CLASS_SIMPLE_NAME).join(COMMA_SEPARATOR);
            return String.format("%s(%s)", input.getName(), parameterTypes);
        }
    };
    public static final Function<Method, String> CLASS_AND_METHOD_FORMATTER = new Function<Method, String>(){

        @Override
        public String apply(Method input) {
            return String.format("%s#%s", CLASS_NAME.apply(input.getDeclaringClass()), METHOD_FORMATTER.apply(input));
        }
    };
    public static final Function<Class<?>, String> CLASS_NAME = new Function<Class<?>, String>(){

        @Override
        public String apply(Class<?> input) {
            return input.getName();
        }
    };
    public static final Function<Class<?>, String> CLASS_SIMPLE_NAME = new Function<Class<?>, String>(){

        @Override
        public String apply(Class<?> input) {
            return input.getSimpleName();
        }
    };
    public static final Function<Type, String> TYPE_SIMPLE_DESCRIPTION = new Function<Type, String>(){

        @Override
        @Nullable
        public String apply(@Nullable Type input) {
            StringBuilder builder = new StringBuilder();
            this.format(builder, input);
            return builder.toString();
        }

        private void format(StringBuilder builder, Type t) {
            if (t instanceof Class) {
                this.formatClass(builder, (Class)t);
            } else if (t instanceof TypeVariable) {
                this.formatTypeVariable(builder, (TypeVariable)t);
            } else if (t instanceof WildcardType) {
                this.formatWildcardType(builder, (WildcardType)t);
            } else if (t instanceof ParameterizedType) {
                this.formatParameterizedType(builder, (ParameterizedType)t);
            } else if (t instanceof GenericArrayType) {
                this.formatGenericArrayType(builder, (GenericArrayType)t);
            } else {
                builder.append(t.toString());
            }
        }

        private void formatClass(StringBuilder builder, Class<?> clazz) {
            builder.append(clazz.getSimpleName());
        }

        private void formatTypeVariable(StringBuilder builder, TypeVariable<?> t) {
            builder.append(t.getName());
        }

        private void formatWildcardType(StringBuilder builder, WildcardType t) {
            builder.append("?");
            for (Type lowerBound : t.getLowerBounds()) {
                builder.append(" super ");
                this.format(builder, lowerBound);
            }
            for (Type upperBound : t.getUpperBounds()) {
                if (Object.class.equals((Object)upperBound)) continue;
                builder.append(" extends ");
                this.format(builder, upperBound);
            }
        }

        private void formatParameterizedType(StringBuilder builder, ParameterizedType t) {
            this.format(builder, t.getRawType());
            builder.append('<');
            COMMA_SEPARATOR.appendTo(builder, (Iterable<?>)FluentIterable.from(Arrays.asList(t.getActualTypeArguments())).transform(TYPE_SIMPLE_DESCRIPTION));
            builder.append('>');
        }

        private void formatGenericArrayType(StringBuilder builder, GenericArrayType t) {
            this.format(builder, t.getGenericComponentType());
            builder.append("[]");
        }
    };

    public static FluentIterable<Class<?>> getClosureOfInterfaces(Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        ArrayDeque interfacesToProcess = Queues.newArrayDeque();
        Collections.addAll(interfacesToProcess, clazz.getInterfaces());
        LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
        while (!interfacesToProcess.isEmpty()) {
            Class current = (Class)interfacesToProcess.remove();
            if (!interfaces.add(current)) continue;
            Collections.addAll(interfacesToProcess, current.getInterfaces());
        }
        return FluentIterable.from(interfaces);
    }

    public static Iterable<Method> getClosureOfMethodsOnInterfaces(Iterable<? extends Class<?>> interfaces) {
        return FluentIterable.from(interfaces).transformAndConcat(new Function<Class<?>, Iterable<Method>>(){

            @Override
            public Iterable<Method> apply(Class<?> input) {
                return ReflectHelpers.getClosureOfMethodsOnInterface(input);
            }
        });
    }

    public static Iterable<Method> getClosureOfMethodsOnInterface(Class<?> iface) {
        Preconditions.checkNotNull(iface);
        Preconditions.checkArgument(iface.isInterface());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        ArrayDeque<Class<?>> interfacesToProcess = Queues.newArrayDeque();
        interfacesToProcess.add(iface);
        while (!interfacesToProcess.isEmpty()) {
            Class current = (Class)interfacesToProcess.remove();
            builder.add(current.getMethods());
            interfacesToProcess.addAll(Arrays.asList(current.getInterfaces()));
        }
        return builder.build();
    }
}

