/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util.common;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.util.concurrent.AtomicDouble;
import com.google.cloud.dataflow.sdk.util.common.AutoValue_Counter_Name;
import com.google.cloud.dataflow.sdk.util.common.NameContext;
import com.google.cloud.dataflow.sdk.values.TypeDescriptor;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public abstract class Counter<T> {
    protected final AggregationKind kind;
    protected final AtomicReference<CommitState> commitState;
    protected final Name name;

    public static Counter<Integer> ints(String name, AggregationKind kind) {
        return new IntegerCounter(Name.withoutStructure(name), kind);
    }

    public static Counter<Integer> ints(Name name, AggregationKind kind) {
        return new IntegerCounter(name, kind);
    }

    public static Counter<Long> longs(String name, AggregationKind kind) {
        return new LongCounter(Name.withoutStructure(name), kind);
    }

    public static Counter<Long> longs(Name name, AggregationKind kind) {
        return new LongCounter(name, kind);
    }

    public static Counter<Double> doubles(String name, AggregationKind kind) {
        return new DoubleCounter(Name.withoutStructure(name), kind);
    }

    public static Counter<Double> doubles(Name name, AggregationKind kind) {
        return new DoubleCounter(name, kind);
    }

    public static Counter<Boolean> booleans(String name, AggregationKind kind) {
        return new BooleanCounter(Name.withoutStructure(name), kind);
    }

    public static Counter<Boolean> booleans(Name name, AggregationKind kind) {
        return new BooleanCounter(name, kind);
    }

    private static Counter<String> strings(String name, AggregationKind kind) {
        return new StringCounter(Name.withoutStructure(name), kind);
    }

    private static Counter<String> strings(Name name, AggregationKind kind) {
        return new StringCounter(name, kind);
    }

    public abstract Counter<T> addValue(T var1);

    public abstract Counter<T> resetToValue(T var1);

    public abstract Counter<T> resetMeanToValue(long var1, T var3);

    public abstract T getAndResetDelta();

    public abstract CounterMean<T> getAndResetMeanDelta();

    public String getName() {
        return this.name.counterName();
    }

    public Name getUniqueName() {
        return this.name;
    }

    public AggregationKind getKind() {
        return this.kind;
    }

    public Class<?> getType() {
        return new TypeDescriptor<T>(this.getClass()){}.getRawType();
    }

    public abstract T getAggregate();

    @Nullable
    public abstract CounterMean<T> getMean();

    public boolean isDirty() {
        return this.commitState.get() != CommitState.COMMITTED;
    }

    public boolean committing() {
        return this.commitState.compareAndSet(CommitState.DIRTY, CommitState.COMMITTING);
    }

    public boolean committed() {
        return this.commitState.compareAndSet(CommitState.COMMITTING, CommitState.COMMITTED);
    }

    protected void setDirty() {
        this.commitState.set(CommitState.DIRTY);
    }

    public String toString() {
        String valueString;
        switch (this.kind) {
            case SUM: 
            case MAX: 
            case MIN: 
            case AND: 
            case OR: {
                valueString = this.getAggregate().toString();
                break;
            }
            case MEAN: {
                valueString = this.getMean().toString();
                break;
            }
            default: {
                throw this.illegalArgumentException();
            }
        }
        return MoreObjects.toStringHelper(this).add("Name", this.name).add("Kind", (Object)this.getKind()).add("Value", valueString).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Counter) {
            Counter that = (Counter)o;
            if (this.name.equals(that.name) && this.kind == that.kind && this.getClass().equals(that.getClass())) {
                if (this.kind == AggregationKind.MEAN) {
                    CounterMean<T> thatMean;
                    CounterMean<T> thisMean = this.getMean();
                    return thisMean == (thatMean = that.getMean()) || Objects.equals(thisMean.getAggregate(), thatMean.getAggregate()) && thisMean.getCount() == thatMean.getCount();
                }
                return Objects.equals(this.getAggregate(), that.getAggregate());
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.kind == AggregationKind.MEAN) {
            CounterMean<T> mean = this.getMean();
            return Objects.hash(new Object[]{this.getClass(), this.name, this.kind, mean.getAggregate(), mean.getCount()});
        }
        return Objects.hash(new Object[]{this.getClass(), this.name, this.kind, this.getAggregate()});
    }

    public boolean isCompatibleWith(Counter<?> that) {
        return this.name.equals(that.name) && this.kind == that.kind && this.getClass().equals(that.getClass());
    }

    public abstract Counter<T> merge(Counter<T> var1);

    protected Counter(String name, AggregationKind kind) {
        this.name = Name.withoutStructure(name);
        this.kind = kind;
        this.commitState = new AtomicReference<CommitState>(CommitState.COMMITTED);
    }

    protected Counter(Name name, AggregationKind kind) {
        this.name = Preconditions.checkNotNull(name);
        this.kind = kind;
        this.commitState = new AtomicReference<CommitState>(CommitState.COMMITTED);
    }

    protected IllegalArgumentException illegalArgumentException() {
        return new IllegalArgumentException("Cannot compute " + (Object)((Object)this.kind) + " aggregation over " + this.getType().getSimpleName() + " values.");
    }

    private static class IntegerCounter
    extends Counter<Integer> {
        private final AtomicInteger aggregate;
        private final AtomicInteger deltaAggregate;
        private final AtomicReference<IntegerCounterMean> mean;
        private final AtomicReference<IntegerCounterMean> deltaMean;

        private IntegerCounter(Name name, AggregationKind kind) {
            super(name, kind);
            switch (kind) {
                case MEAN: {
                    this.deltaAggregate = null;
                    this.aggregate = null;
                    this.mean = new AtomicReference();
                    this.deltaMean = new AtomicReference();
                    this.getAndResetMeanDelta();
                    this.mean.set(this.deltaMean.get());
                    break;
                }
                case SUM: 
                case MAX: 
                case MIN: {
                    this.deltaMean = null;
                    this.mean = null;
                    this.aggregate = new AtomicInteger();
                    this.deltaAggregate = new AtomicInteger();
                    this.getAndResetDelta();
                    this.aggregate.set(this.deltaAggregate.get());
                    break;
                }
                default: {
                    throw this.illegalArgumentException();
                }
            }
        }

        public IntegerCounter addValue(Integer value) {
            try {
                switch (this.kind) {
                    case SUM: {
                        this.aggregate.getAndAdd(value);
                        this.deltaAggregate.getAndAdd(value);
                        break;
                    }
                    case MEAN: {
                        this.addToMeanAndSet(value, this.mean);
                        this.addToMeanAndSet(value, this.deltaMean);
                        break;
                    }
                    case MAX: {
                        this.maxAndSet(value, this.aggregate);
                        this.maxAndSet(value, this.deltaAggregate);
                        break;
                    }
                    case MIN: {
                        this.minAndSet(value, this.aggregate);
                        this.minAndSet(value, this.deltaAggregate);
                        break;
                    }
                    default: {
                        throw this.illegalArgumentException();
                    }
                }
                IntegerCounter integerCounter = this;
                return integerCounter;
            }
            finally {
                this.setDirty();
            }
        }

        private void addToMeanAndSet(int value, AtomicReference<IntegerCounterMean> target) {
            IntegerCounterMean update;
            IntegerCounterMean current;
            while (!target.compareAndSet(current = target.get(), update = new IntegerCounterMean(current.getAggregate() + value, current.getCount() + 1L))) {
            }
        }

        private void maxAndSet(int value, AtomicInteger target) {
            int current;
            int update;
            while ((update = Math.max(value, current = target.get())) > current && !target.compareAndSet(current, update)) {
            }
        }

        private void minAndSet(int value, AtomicInteger target) {
            int current;
            int update;
            while ((update = Math.min(value, current = target.get())) < current && !target.compareAndSet(current, update)) {
            }
        }

        @Override
        public Integer getAndResetDelta() {
            switch (this.kind) {
                case SUM: {
                    return this.deltaAggregate.getAndSet(0);
                }
                case MAX: {
                    return this.deltaAggregate.getAndSet(Integer.MIN_VALUE);
                }
                case MIN: {
                    return this.deltaAggregate.getAndSet(Integer.MAX_VALUE);
                }
            }
            throw this.illegalArgumentException();
        }

        @Override
        public Counter<Integer> resetToValue(Integer value) {
            try {
                if (this.kind == AggregationKind.MEAN) {
                    throw this.illegalArgumentException();
                }
                this.aggregate.set(value);
                this.deltaAggregate.set(value);
                IntegerCounter integerCounter = this;
                return integerCounter;
            }
            finally {
                this.setDirty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Counter<Integer> resetMeanToValue(long elementCount, Integer value) {
            try {
                if (this.kind != AggregationKind.MEAN) {
                    throw this.illegalArgumentException();
                }
                if (elementCount < 0L) {
                    throw new IllegalArgumentException("elementCount must be non-negative");
                }
                IntegerCounterMean counterMean = new IntegerCounterMean(value, elementCount);
                this.mean.set(counterMean);
                this.deltaMean.set(counterMean);
                IntegerCounter integerCounter = this;
                return integerCounter;
            }
            finally {
                this.setDirty();
            }
        }

        @Override
        public CounterMean<Integer> getAndResetMeanDelta() {
            if (this.kind != AggregationKind.MEAN) {
                throw this.illegalArgumentException();
            }
            return this.deltaMean.getAndSet(new IntegerCounterMean(0, 0L));
        }

        @Override
        public Integer getAggregate() {
            if (this.kind != AggregationKind.MEAN) {
                return this.aggregate.get();
            }
            return this.getMean().getAggregate();
        }

        @Override
        @Nullable
        public CounterMean<Integer> getMean() {
            if (this.kind != AggregationKind.MEAN) {
                throw this.illegalArgumentException();
            }
            return this.mean.get();
        }

        @Override
        public Counter<Integer> merge(Counter<Integer> that) {
            try {
                Preconditions.checkArgument(this.isCompatibleWith(that), "Counters %s and %s are incompatible", this, that);
                switch (this.kind) {
                    case SUM: 
                    case MAX: 
                    case MIN: {
                        IntegerCounter integerCounter = this.addValue(that.getAggregate());
                        return integerCounter;
                    }
                    case MEAN: {
                        CounterMean<Integer> thisCounterMean = this.getMean();
                        CounterMean<Integer> thatCounterMean = that.getMean();
                        Counter<Integer> counter = this.resetMeanToValue(thisCounterMean.getCount() + thatCounterMean.getCount(), thisCounterMean.getAggregate() + thatCounterMean.getAggregate());
                        return counter;
                    }
                }
                throw this.illegalArgumentException();
            }
            finally {
                this.setDirty();
            }
        }

        private static class IntegerCounterMean
        implements CounterMean<Integer> {
            private final int aggregate;
            private final long count;

            public IntegerCounterMean(int aggregate, long count) {
                this.aggregate = aggregate;
                this.count = count;
            }

            @Override
            public Integer getAggregate() {
                return this.aggregate;
            }

            @Override
            public long getCount() {
                return this.count;
            }

            public String toString() {
                return this.aggregate + "/" + this.count;
            }
        }
    }

    private static class StringCounter
    extends Counter<String> {
        private StringCounter(Name name, AggregationKind kind) {
            super(name, kind);
            throw this.illegalArgumentException();
        }

        public StringCounter addValue(String value) {
            switch (this.kind) {
                default: 
            }
            throw this.illegalArgumentException();
        }

        @Override
        public Counter<String> resetToValue(String value) {
            switch (this.kind) {
                default: 
            }
            throw this.illegalArgumentException();
        }

        @Override
        public Counter<String> resetMeanToValue(long elementCount, String value) {
            switch (this.kind) {
                default: 
            }
            throw this.illegalArgumentException();
        }

        @Override
        public String getAndResetDelta() {
            switch (this.kind) {
                default: 
            }
            throw this.illegalArgumentException();
        }

        @Override
        public CounterMean<String> getAndResetMeanDelta() {
            switch (this.kind) {
                default: 
            }
            throw this.illegalArgumentException();
        }

        @Override
        public String getAggregate() {
            switch (this.kind) {
                default: 
            }
            throw this.illegalArgumentException();
        }

        @Override
        @Nullable
        public CounterMean<String> getMean() {
            switch (this.kind) {
                default: 
            }
            throw this.illegalArgumentException();
        }

        @Override
        public Counter<String> merge(Counter<String> that) {
            Preconditions.checkArgument(this.isCompatibleWith(that), "Counters %s and %s are incompatible", this, that);
            switch (this.kind) {
                default: 
            }
            throw this.illegalArgumentException();
        }
    }

    private static class BooleanCounter
    extends Counter<Boolean> {
        private final AtomicBoolean aggregate = new AtomicBoolean();
        private final AtomicBoolean deltaAggregate = new AtomicBoolean();

        private BooleanCounter(Name name, AggregationKind kind) {
            super(name, kind);
            this.getAndResetDelta();
            this.aggregate.set(this.deltaAggregate.get());
        }

        public BooleanCounter addValue(Boolean value) {
            try {
                if (this.kind.equals((Object)AggregationKind.AND) && !value.booleanValue()) {
                    this.aggregate.set(value);
                    this.deltaAggregate.set(value);
                } else if (this.kind.equals((Object)AggregationKind.OR) && value.booleanValue()) {
                    this.aggregate.set(value);
                    this.deltaAggregate.set(value);
                }
                BooleanCounter booleanCounter = this;
                return booleanCounter;
            }
            finally {
                this.setDirty();
            }
        }

        @Override
        public Boolean getAndResetDelta() {
            switch (this.kind) {
                case AND: {
                    return this.deltaAggregate.getAndSet(true);
                }
                case OR: {
                    return this.deltaAggregate.getAndSet(false);
                }
            }
            throw this.illegalArgumentException();
        }

        @Override
        public Counter<Boolean> resetToValue(Boolean value) {
            try {
                this.aggregate.set(value);
                this.deltaAggregate.set(value);
                BooleanCounter booleanCounter = this;
                return booleanCounter;
            }
            finally {
                this.setDirty();
            }
        }

        @Override
        public Counter<Boolean> resetMeanToValue(long elementCount, Boolean value) {
            throw this.illegalArgumentException();
        }

        @Override
        public CounterMean<Boolean> getAndResetMeanDelta() {
            throw this.illegalArgumentException();
        }

        @Override
        public Boolean getAggregate() {
            return this.aggregate.get();
        }

        @Override
        @Nullable
        public CounterMean<Boolean> getMean() {
            throw this.illegalArgumentException();
        }

        @Override
        public Counter<Boolean> merge(Counter<Boolean> that) {
            try {
                Preconditions.checkArgument(this.isCompatibleWith(that), "Counters %s and %s are incompatible", this, that);
                BooleanCounter booleanCounter = this.addValue(that.getAggregate());
                return booleanCounter;
            }
            finally {
                this.setDirty();
            }
        }
    }

    private static class DoubleCounter
    extends Counter<Double> {
        AtomicDouble aggregate;
        AtomicDouble deltaAggregate;
        AtomicReference<DoubleCounterMean> mean;
        AtomicReference<DoubleCounterMean> deltaMean;

        private DoubleCounter(Name name, AggregationKind kind) {
            super(name, kind);
            switch (kind) {
                case MEAN: {
                    this.deltaAggregate = null;
                    this.aggregate = null;
                    this.mean = new AtomicReference();
                    this.deltaMean = new AtomicReference();
                    this.getAndResetMeanDelta();
                    this.mean.set(this.deltaMean.get());
                    break;
                }
                case SUM: 
                case MAX: 
                case MIN: {
                    this.deltaMean = null;
                    this.mean = null;
                    this.aggregate = new AtomicDouble();
                    this.deltaAggregate = new AtomicDouble();
                    this.getAndResetDelta();
                    this.aggregate.set(this.deltaAggregate.get());
                    break;
                }
                default: {
                    throw this.illegalArgumentException();
                }
            }
        }

        public DoubleCounter addValue(Double value) {
            try {
                switch (this.kind) {
                    case SUM: {
                        this.aggregate.addAndGet(value);
                        this.deltaAggregate.addAndGet(value);
                        break;
                    }
                    case MEAN: {
                        this.addToMeanAndSet(value, this.mean);
                        this.addToMeanAndSet(value, this.deltaMean);
                        break;
                    }
                    case MAX: {
                        this.maxAndSet(value, this.aggregate);
                        this.maxAndSet(value, this.deltaAggregate);
                        break;
                    }
                    case MIN: {
                        this.minAndSet(value, this.aggregate);
                        this.minAndSet(value, this.deltaAggregate);
                        break;
                    }
                    default: {
                        throw this.illegalArgumentException();
                    }
                }
                DoubleCounter doubleCounter = this;
                return doubleCounter;
            }
            finally {
                this.setDirty();
            }
        }

        private void addToMeanAndSet(Double value, AtomicReference<DoubleCounterMean> target) {
            DoubleCounterMean update;
            DoubleCounterMean current;
            while (!target.compareAndSet(current = target.get(), update = new DoubleCounterMean(current.getAggregate() + value, current.getCount() + 1L))) {
            }
        }

        private void maxAndSet(Double value, AtomicDouble target) {
            double current;
            double update;
            while ((update = Math.max(current = target.get(), value)) > current && !target.compareAndSet(current, update)) {
            }
        }

        private void minAndSet(Double value, AtomicDouble target) {
            double current;
            double update;
            while ((update = Math.min(current = target.get(), value)) < current && !target.compareAndSet(current, update)) {
            }
        }

        @Override
        public Double getAndResetDelta() {
            switch (this.kind) {
                case SUM: {
                    return this.deltaAggregate.getAndSet(0.0);
                }
                case MAX: {
                    return this.deltaAggregate.getAndSet(Double.NEGATIVE_INFINITY);
                }
                case MIN: {
                    return this.deltaAggregate.getAndSet(Double.POSITIVE_INFINITY);
                }
            }
            throw this.illegalArgumentException();
        }

        @Override
        public Counter<Double> resetToValue(Double value) {
            try {
                if (this.kind == AggregationKind.MEAN) {
                    throw this.illegalArgumentException();
                }
                this.aggregate.set(value);
                this.deltaAggregate.set(value);
                DoubleCounter doubleCounter = this;
                return doubleCounter;
            }
            finally {
                this.setDirty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Counter<Double> resetMeanToValue(long elementCount, Double value) {
            try {
                if (this.kind != AggregationKind.MEAN) {
                    throw this.illegalArgumentException();
                }
                if (elementCount < 0L) {
                    throw new IllegalArgumentException("elementCount must be non-negative");
                }
                DoubleCounterMean counterMean = new DoubleCounterMean(value, elementCount);
                this.mean.set(counterMean);
                this.deltaMean.set(counterMean);
                DoubleCounter doubleCounter = this;
                return doubleCounter;
            }
            finally {
                this.setDirty();
            }
        }

        @Override
        public CounterMean<Double> getAndResetMeanDelta() {
            if (this.kind != AggregationKind.MEAN) {
                throw this.illegalArgumentException();
            }
            return this.deltaMean.getAndSet(new DoubleCounterMean(0.0, 0L));
        }

        @Override
        public Double getAggregate() {
            if (this.kind != AggregationKind.MEAN) {
                return this.aggregate.get();
            }
            return this.getMean().getAggregate();
        }

        @Override
        @Nullable
        public CounterMean<Double> getMean() {
            if (this.kind != AggregationKind.MEAN) {
                throw this.illegalArgumentException();
            }
            return this.mean.get();
        }

        @Override
        public Counter<Double> merge(Counter<Double> that) {
            try {
                Preconditions.checkArgument(this.isCompatibleWith(that), "Counters %s and %s are incompatible", this, that);
                switch (this.kind) {
                    case SUM: 
                    case MAX: 
                    case MIN: {
                        DoubleCounter doubleCounter = this.addValue(that.getAggregate());
                        return doubleCounter;
                    }
                    case MEAN: {
                        CounterMean<Double> thisCounterMean = this.getMean();
                        CounterMean<Double> thatCounterMean = that.getMean();
                        Counter<Double> counter = this.resetMeanToValue(thisCounterMean.getCount() + thatCounterMean.getCount(), thisCounterMean.getAggregate() + thatCounterMean.getAggregate());
                        return counter;
                    }
                }
                throw this.illegalArgumentException();
            }
            finally {
                this.setDirty();
            }
        }

        private static class DoubleCounterMean
        implements CounterMean<Double> {
            private final double aggregate;
            private final long count;

            public DoubleCounterMean(double aggregate, long count) {
                this.aggregate = aggregate;
                this.count = count;
            }

            @Override
            public Double getAggregate() {
                return this.aggregate;
            }

            @Override
            public long getCount() {
                return this.count;
            }

            public String toString() {
                return this.aggregate + "/" + this.count;
            }
        }
    }

    private static class LongCounter
    extends Counter<Long> {
        private final AtomicLong aggregate;
        private final AtomicLong deltaAggregate;
        private final AtomicReference<LongCounterMean> mean;
        private final AtomicReference<LongCounterMean> deltaMean;

        private LongCounter(Name name, AggregationKind kind) {
            super(name, kind);
            switch (kind) {
                case MEAN: {
                    this.mean = new AtomicReference();
                    this.deltaMean = new AtomicReference();
                    this.getAndResetMeanDelta();
                    this.mean.set(this.deltaMean.get());
                    this.deltaAggregate = null;
                    this.aggregate = null;
                    break;
                }
                case SUM: 
                case MAX: 
                case MIN: {
                    this.aggregate = new AtomicLong();
                    this.deltaAggregate = new AtomicLong();
                    this.getAndResetDelta();
                    this.aggregate.set(this.deltaAggregate.get());
                    this.deltaMean = null;
                    this.mean = null;
                    break;
                }
                default: {
                    throw this.illegalArgumentException();
                }
            }
        }

        public LongCounter addValue(Long value) {
            try {
                switch (this.kind) {
                    case SUM: {
                        this.aggregate.addAndGet(value);
                        this.deltaAggregate.addAndGet(value);
                        break;
                    }
                    case MEAN: {
                        this.addToMeanAndSet(value, this.mean);
                        this.addToMeanAndSet(value, this.deltaMean);
                        break;
                    }
                    case MAX: {
                        this.maxAndSet(value, this.aggregate);
                        this.maxAndSet(value, this.deltaAggregate);
                        break;
                    }
                    case MIN: {
                        this.minAndSet(value, this.aggregate);
                        this.minAndSet(value, this.deltaAggregate);
                        break;
                    }
                    default: {
                        throw this.illegalArgumentException();
                    }
                }
                LongCounter longCounter = this;
                return longCounter;
            }
            finally {
                this.setDirty();
            }
        }

        private void minAndSet(Long value, AtomicLong target) {
            long current;
            long update;
            do {
                current = target.get();
            } while ((update = Math.min(value, current)) < current && !target.compareAndSet(current, update));
        }

        private void maxAndSet(Long value, AtomicLong target) {
            long current;
            long update;
            do {
                current = target.get();
            } while ((update = Math.max(value, current)) > current && !target.compareAndSet(current, update));
        }

        private void addToMeanAndSet(Long value, AtomicReference<LongCounterMean> target) {
            LongCounterMean update;
            LongCounterMean current;
            while (!target.compareAndSet(current = target.get(), update = new LongCounterMean(current.getAggregate() + value, current.getCount() + 1L))) {
            }
        }

        @Override
        public Long getAggregate() {
            if (this.kind != AggregationKind.MEAN) {
                return this.aggregate.get();
            }
            return this.getMean().getAggregate();
        }

        @Override
        public Long getAndResetDelta() {
            switch (this.kind) {
                case SUM: {
                    return this.deltaAggregate.getAndSet(0L);
                }
                case MAX: {
                    return this.deltaAggregate.getAndSet(Long.MIN_VALUE);
                }
                case MIN: {
                    return this.deltaAggregate.getAndSet(Long.MAX_VALUE);
                }
            }
            throw this.illegalArgumentException();
        }

        @Override
        public Counter<Long> resetToValue(Long value) {
            try {
                if (this.kind == AggregationKind.MEAN) {
                    throw this.illegalArgumentException();
                }
                this.aggregate.set(value);
                this.deltaAggregate.set(value);
                LongCounter longCounter = this;
                return longCounter;
            }
            finally {
                this.setDirty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Counter<Long> resetMeanToValue(long elementCount, Long value) {
            try {
                if (this.kind != AggregationKind.MEAN) {
                    throw this.illegalArgumentException();
                }
                if (elementCount < 0L) {
                    throw new IllegalArgumentException("elementCount must be non-negative");
                }
                LongCounterMean counterMean = new LongCounterMean(value, elementCount);
                this.mean.set(counterMean);
                this.deltaMean.set(counterMean);
                LongCounter longCounter = this;
                return longCounter;
            }
            finally {
                this.setDirty();
            }
        }

        @Override
        public CounterMean<Long> getAndResetMeanDelta() {
            if (this.kind != AggregationKind.MEAN) {
                throw this.illegalArgumentException();
            }
            return this.deltaMean.getAndSet(new LongCounterMean(0L, 0L));
        }

        @Override
        @Nullable
        public CounterMean<Long> getMean() {
            if (this.kind != AggregationKind.MEAN) {
                throw this.illegalArgumentException();
            }
            return this.mean.get();
        }

        @Override
        public Counter<Long> merge(Counter<Long> that) {
            try {
                Preconditions.checkArgument(this.isCompatibleWith(that), "Counters %s and %s are incompatible", this, that);
                switch (this.kind) {
                    case SUM: 
                    case MAX: 
                    case MIN: {
                        LongCounter longCounter = this.addValue(that.getAggregate());
                        return longCounter;
                    }
                    case MEAN: {
                        CounterMean<Long> thisCounterMean = this.getMean();
                        CounterMean<Long> thatCounterMean = that.getMean();
                        Counter<Long> counter = this.resetMeanToValue(thisCounterMean.getCount() + thatCounterMean.getCount(), thisCounterMean.getAggregate() + thatCounterMean.getAggregate());
                        return counter;
                    }
                }
                throw this.illegalArgumentException();
            }
            finally {
                this.setDirty();
            }
        }

        private static class LongCounterMean
        implements CounterMean<Long> {
            private final long aggregate;
            private final long count;

            public LongCounterMean(long aggregate, long count) {
                this.aggregate = aggregate;
                this.count = count;
            }

            @Override
            public Long getAggregate() {
                return this.aggregate;
            }

            @Override
            public long getCount() {
                return this.count;
            }

            public String toString() {
                return this.aggregate + "/" + this.count;
            }
        }
    }

    public static abstract class Name {
        public static Name withOriginalName(String name, NameContext context) {
            return new AutoValue_Counter_Name(name, null, Preconditions.checkNotNull(context.originalName(), "Expected original name in context %s", context));
        }

        public static Name withSystemName(String name, NameContext context) {
            return new AutoValue_Counter_Name(name, Preconditions.checkNotNull(context.systemName(), "Expected system name in context %s", context), null);
        }

        public static Name withoutStructure(String name) {
            return new AutoValue_Counter_Name(name, null, null);
        }

        public abstract String counterName();

        @Nullable
        public abstract String contextSystemName();

        @Nullable
        public abstract String contextOriginalName();
    }

    @VisibleForTesting
    static enum CommitState {
        COMMITTED,
        DIRTY,
        COMMITTING;

    }

    public static interface CounterMean<T> {
        public T getAggregate();

        public long getCount();
    }

    public static enum AggregationKind {
        SUM,
        MAX,
        MIN,
        MEAN,
        AND,
        OR;

    }
}

