/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.annotations.Experimental;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.DefaultTrigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindows;
import com.google.cloud.dataflow.sdk.transforms.windowing.OutputTimeFn;
import com.google.cloud.dataflow.sdk.transforms.windowing.Trigger;
import com.google.cloud.dataflow.sdk.transforms.windowing.Window;
import com.google.cloud.dataflow.sdk.transforms.windowing.WindowFn;
import com.google.cloud.dataflow.sdk.util.ExecutableTrigger;
import java.io.Serializable;
import java.util.Objects;
import org.joda.time.Duration;

public class WindowingStrategy<T, W extends BoundedWindow>
implements Serializable {
    private static final Duration DEFAULT_ALLOWED_LATENESS = Duration.ZERO;
    private static final WindowingStrategy<Object, GlobalWindow> DEFAULT = WindowingStrategy.of(new GlobalWindows());
    private final WindowFn<T, W> windowFn;
    private final OutputTimeFn<? super W> outputTimeFn;
    private final ExecutableTrigger<W> trigger;
    private final AccumulationMode mode;
    private final Duration allowedLateness;
    private final Window.ClosingBehavior closingBehavior;
    private final boolean triggerSpecified;
    private final boolean modeSpecified;
    private final boolean allowedLatenessSpecified;
    private final boolean outputTimeFnSpecified;

    private WindowingStrategy(WindowFn<T, W> windowFn, ExecutableTrigger<W> trigger, boolean triggerSpecified, AccumulationMode mode, boolean modeSpecified, Duration allowedLateness, boolean allowedLatenessSpecified, OutputTimeFn<? super W> outputTimeFn, boolean outputTimeFnSpecified, Window.ClosingBehavior closingBehavior) {
        this.windowFn = windowFn;
        this.trigger = trigger;
        this.triggerSpecified = triggerSpecified;
        this.mode = mode;
        this.modeSpecified = modeSpecified;
        this.allowedLateness = allowedLateness;
        this.allowedLatenessSpecified = allowedLatenessSpecified;
        this.closingBehavior = closingBehavior;
        this.outputTimeFn = outputTimeFn;
        this.outputTimeFnSpecified = outputTimeFnSpecified;
    }

    public static WindowingStrategy<Object, GlobalWindow> globalDefault() {
        return DEFAULT;
    }

    public static <T, W extends BoundedWindow> WindowingStrategy<T, W> of(WindowFn<T, W> windowFn) {
        return new WindowingStrategy<T, W>(windowFn, ExecutableTrigger.create(DefaultTrigger.of()), false, AccumulationMode.DISCARDING_FIRED_PANES, false, DEFAULT_ALLOWED_LATENESS, false, windowFn.getOutputTimeFn(), false, Window.ClosingBehavior.FIRE_IF_NON_EMPTY);
    }

    public WindowFn<T, W> getWindowFn() {
        return this.windowFn;
    }

    public ExecutableTrigger<W> getTrigger() {
        return this.trigger;
    }

    public boolean isTriggerSpecified() {
        return this.triggerSpecified;
    }

    public Duration getAllowedLateness() {
        return this.allowedLateness;
    }

    public boolean isAllowedLatenessSpecified() {
        return this.allowedLatenessSpecified;
    }

    public AccumulationMode getMode() {
        return this.mode;
    }

    public boolean isModeSpecified() {
        return this.modeSpecified;
    }

    public Window.ClosingBehavior getClosingBehavior() {
        return this.closingBehavior;
    }

    public OutputTimeFn<? super W> getOutputTimeFn() {
        return this.outputTimeFn;
    }

    public boolean isOutputTimeFnSpecified() {
        return this.outputTimeFnSpecified;
    }

    public WindowingStrategy<T, W> withTrigger(Trigger<?> wildcardTrigger) {
        Trigger<?> typedTrigger = wildcardTrigger;
        return new WindowingStrategy<T, W>(this.windowFn, ExecutableTrigger.create(typedTrigger), true, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.outputTimeFn, this.outputTimeFnSpecified, this.closingBehavior);
    }

    public WindowingStrategy<T, W> withMode(AccumulationMode mode) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, mode, true, this.allowedLateness, this.allowedLatenessSpecified, this.outputTimeFn, this.outputTimeFnSpecified, this.closingBehavior);
    }

    public WindowingStrategy<T, W> withWindowFn(WindowFn<?, ?> wildcardWindowFn) {
        WindowFn<?, ?> typedWindowFn = wildcardWindowFn;
        OutputTimeFn<Object> newOutputTimeFn = this.outputTimeFnSpecified ? this.outputTimeFn : typedWindowFn.getOutputTimeFn();
        return new WindowingStrategy(typedWindowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, newOutputTimeFn, this.outputTimeFnSpecified, this.closingBehavior);
    }

    public WindowingStrategy<T, W> withAllowedLateness(Duration allowedLateness) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, allowedLateness, true, this.outputTimeFn, this.outputTimeFnSpecified, this.closingBehavior);
    }

    public WindowingStrategy<T, W> withClosingBehavior(Window.ClosingBehavior closingBehavior) {
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, this.outputTimeFn, this.outputTimeFnSpecified, closingBehavior);
    }

    @Experimental(value=Experimental.Kind.OUTPUT_TIME)
    public WindowingStrategy<T, W> withOutputTimeFn(OutputTimeFn<?> outputTimeFn) {
        OutputTimeFn<?> typedOutputTimeFn = outputTimeFn;
        return new WindowingStrategy<T, W>(this.windowFn, this.trigger, this.triggerSpecified, this.mode, this.modeSpecified, this.allowedLateness, this.allowedLatenessSpecified, typedOutputTimeFn, true, this.closingBehavior);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("windowFn", this.windowFn).add("allowedLateness", this.allowedLateness).add("trigger", this.trigger).add("accumulationMode", (Object)this.mode).add("outputTimeFn", this.outputTimeFn).toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof WindowingStrategy)) {
            return false;
        }
        WindowingStrategy other = (WindowingStrategy)object;
        return this.isTriggerSpecified() == other.isTriggerSpecified() && this.isAllowedLatenessSpecified() == other.isAllowedLatenessSpecified() && this.isModeSpecified() == other.isModeSpecified() && this.getMode().equals((Object)other.getMode()) && this.getAllowedLateness().equals((Object)other.getAllowedLateness()) && this.getClosingBehavior().equals((Object)other.getClosingBehavior()) && this.getTrigger().equals(other.getTrigger()) && this.getWindowFn().equals(other.getWindowFn());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.triggerSpecified, this.allowedLatenessSpecified, this.modeSpecified, this.windowFn, this.trigger, this.mode, this.allowedLateness, this.closingBehavior});
    }

    public static enum AccumulationMode {
        DISCARDING_FIRED_PANES,
        ACCUMULATING_FIRED_PANES;

    }
}

