/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.coders.CoderException;
import com.google.cloud.dataflow.sdk.coders.CollectionCoder;
import com.google.cloud.dataflow.sdk.coders.InstantCoder;
import com.google.cloud.dataflow.sdk.coders.StandardCoder;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.GlobalWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.PaneInfo;
import com.google.cloud.dataflow.sdk.util.CloudObject;
import com.google.cloud.dataflow.sdk.util.Structs;
import com.google.cloud.dataflow.sdk.util.common.ElementByteSizeObserver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public abstract class WindowedValue<T> {
    protected final T value;
    protected final PaneInfo pane;
    private static final Collection<? extends BoundedWindow> GLOBAL_WINDOWS = Collections.singletonList(GlobalWindow.INSTANCE);

    public static <T> WindowedValue<T> of(T value, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
        Preconditions.checkNotNull(pane);
        if (windows.size() == 0 && BoundedWindow.TIMESTAMP_MIN_VALUE.equals((Object)timestamp)) {
            return WindowedValue.valueInEmptyWindows(value, pane);
        }
        if (windows.size() == 1) {
            return WindowedValue.of(value, timestamp, windows.iterator().next(), pane);
        }
        return new TimestampedValueInMultipleWindows<T>(value, timestamp, windows, pane);
    }

    public static <T> WindowedValue<T> of(T value, Instant timestamp, BoundedWindow window, PaneInfo pane) {
        Preconditions.checkNotNull(pane);
        boolean isGlobal = GlobalWindow.INSTANCE.equals(window);
        if (isGlobal && BoundedWindow.TIMESTAMP_MIN_VALUE.equals((Object)timestamp)) {
            return WindowedValue.valueInGlobalWindow(value, pane);
        }
        if (isGlobal) {
            return new TimestampedValueInGlobalWindow<T>(value, timestamp, pane);
        }
        return new TimestampedValueInSingleWindow<T>(value, timestamp, window, pane);
    }

    public static <T> WindowedValue<T> valueInGlobalWindow(T value) {
        return new ValueInGlobalWindow<T>(value, PaneInfo.NO_FIRING);
    }

    public static <T> WindowedValue<T> valueInGlobalWindow(T value, PaneInfo pane) {
        return new ValueInGlobalWindow<T>(value, pane);
    }

    public static <T> WindowedValue<T> timestampedValueInGlobalWindow(T value, Instant timestamp) {
        if (BoundedWindow.TIMESTAMP_MIN_VALUE.equals((Object)timestamp)) {
            return WindowedValue.valueInGlobalWindow(value);
        }
        return new TimestampedValueInGlobalWindow<T>(value, timestamp, PaneInfo.NO_FIRING);
    }

    public static <T> WindowedValue<T> valueInEmptyWindows(T value) {
        return new ValueInEmptyWindows<T>(value, PaneInfo.NO_FIRING);
    }

    public static <T> WindowedValue<T> valueInEmptyWindows(T value, PaneInfo pane) {
        return new ValueInEmptyWindows<T>(value, pane);
    }

    private WindowedValue(T value, PaneInfo pane) {
        this.value = value;
        this.pane = Preconditions.checkNotNull(pane);
    }

    public abstract <NewT> WindowedValue<NewT> withValue(NewT var1);

    public T getValue() {
        return this.value;
    }

    public abstract Instant getTimestamp();

    public abstract Collection<? extends BoundedWindow> getWindows();

    public Iterable<WindowedValue<T>> explodeWindows() {
        ImmutableList.Builder windowedValues = ImmutableList.builder();
        for (BoundedWindow w : this.getWindows()) {
            windowedValues.add(WindowedValue.of(this.getValue(), this.getTimestamp(), w, this.getPane()));
        }
        return windowedValues.build();
    }

    public PaneInfo getPane() {
        return this.pane;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public static <T> FullWindowedValueCoder<T> getFullCoder(Coder<T> valueCoder, Coder<? extends BoundedWindow> windowCoder) {
        return FullWindowedValueCoder.of(valueCoder, windowCoder);
    }

    public static <T> ValueOnlyWindowedValueCoder<T> getValueOnlyCoder(Coder<T> valueCoder) {
        return ValueOnlyWindowedValueCoder.of(valueCoder);
    }

    public static class ValueOnlyWindowedValueCoder<T>
    extends WindowedValueCoder<T> {
        public static <T> ValueOnlyWindowedValueCoder<T> of(Coder<T> valueCoder) {
            return new ValueOnlyWindowedValueCoder<T>(valueCoder);
        }

        @JsonCreator
        public static ValueOnlyWindowedValueCoder<?> of(@JsonProperty(value="component_encodings") List<Coder<?>> components) {
            Preconditions.checkArgument(components.size() == 1, "Expecting 1 component, got " + components.size());
            return ValueOnlyWindowedValueCoder.of(components.get(0));
        }

        ValueOnlyWindowedValueCoder(Coder<T> valueCoder) {
            super(valueCoder);
        }

        @Override
        public <NewT> WindowedValueCoder<NewT> withValueCoder(Coder<NewT> valueCoder) {
            return new ValueOnlyWindowedValueCoder<NewT>(valueCoder);
        }

        @Override
        public void encode(WindowedValue<T> windowedElem, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            this.valueCoder.encode(windowedElem.getValue(), outStream, context);
        }

        @Override
        public WindowedValue<T> decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            Object value = this.valueCoder.decode(inStream, context);
            return WindowedValue.valueInGlobalWindow(value);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.verifyDeterministic("ValueOnlyWindowedValueCoder requires a deterministic valueCoder", this.valueCoder);
        }

        @Override
        public void registerByteSizeObserver(WindowedValue<T> value, ElementByteSizeObserver observer, Coder.Context context) throws Exception {
            this.valueCoder.registerByteSizeObserver(value.getValue(), observer, context);
        }

        @Override
        public CloudObject asCloudObject() {
            CloudObject result = super.asCloudObject();
            Structs.addBoolean((Map<String, Object>)((Object)result), "is_wrapper", true);
            return result;
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.valueCoder);
        }
    }

    public static class FullWindowedValueCoder<T>
    extends WindowedValueCoder<T> {
        private final Coder<? extends BoundedWindow> windowCoder;
        private final Coder<Collection<? extends BoundedWindow>> windowsCoder;

        public static <T> FullWindowedValueCoder<T> of(Coder<T> valueCoder, Coder<? extends BoundedWindow> windowCoder) {
            return new FullWindowedValueCoder<T>(valueCoder, windowCoder);
        }

        @JsonCreator
        public static FullWindowedValueCoder<?> of(@JsonProperty(value="component_encodings") List<Coder<?>> components) {
            Preconditions.checkArgument(components.size() == 2, "Expecting 2 components, got " + components.size());
            Coder<?> window = components.get(1);
            return FullWindowedValueCoder.of(components.get(0), window);
        }

        FullWindowedValueCoder(Coder<T> valueCoder, Coder<? extends BoundedWindow> windowCoder) {
            super(valueCoder);
            this.windowCoder = Preconditions.checkNotNull(windowCoder);
            CollectionCoder<? extends BoundedWindow> collectionCoder = CollectionCoder.of(this.windowCoder);
            this.windowsCoder = collectionCoder;
        }

        public Coder<? extends BoundedWindow> getWindowCoder() {
            return this.windowCoder;
        }

        public Coder<Collection<? extends BoundedWindow>> getWindowsCoder() {
            return this.windowsCoder;
        }

        @Override
        public <NewT> WindowedValueCoder<NewT> withValueCoder(Coder<NewT> valueCoder) {
            return new FullWindowedValueCoder<NewT>(valueCoder, this.windowCoder);
        }

        @Override
        public void encode(WindowedValue<T> windowedElem, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            Coder.Context nestedContext = context.nested();
            this.valueCoder.encode(windowedElem.getValue(), outStream, nestedContext);
            InstantCoder.of().encode(windowedElem.getTimestamp(), outStream, nestedContext);
            this.windowsCoder.encode(windowedElem.getWindows(), outStream, nestedContext);
            PaneInfo.PaneInfoCoder.INSTANCE.encode(windowedElem.getPane(), outStream, context);
        }

        @Override
        public WindowedValue<T> decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            Coder.Context nestedContext = context.nested();
            Object value = this.valueCoder.decode(inStream, nestedContext);
            Instant timestamp = InstantCoder.of().decode(inStream, nestedContext);
            Collection<? extends BoundedWindow> windows = this.windowsCoder.decode(inStream, nestedContext);
            PaneInfo pane = PaneInfo.PaneInfoCoder.INSTANCE.decode(inStream, nestedContext);
            return WindowedValue.of(value, timestamp, windows, pane);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            this.verifyDeterministic("FullWindowedValueCoder requires a deterministic valueCoder", this.valueCoder);
            this.verifyDeterministic("FullWindowedValueCoder requires a deterministic windowCoder", this.windowCoder);
        }

        @Override
        public void registerByteSizeObserver(WindowedValue<T> value, ElementByteSizeObserver observer, Coder.Context context) throws Exception {
            this.valueCoder.registerByteSizeObserver(value.getValue(), observer, context);
            InstantCoder.of().registerByteSizeObserver(value.getTimestamp(), observer, context);
            this.windowsCoder.registerByteSizeObserver(value.getWindows(), observer, context);
        }

        @Override
        public CloudObject asCloudObject() {
            CloudObject result = super.asCloudObject();
            Structs.addBoolean((Map<String, Object>)((Object)result), "is_wrapper", true);
            return result;
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return null;
        }

        @Override
        public List<? extends Coder<?>> getComponents() {
            return Arrays.asList(this.valueCoder, this.windowCoder);
        }
    }

    public static abstract class WindowedValueCoder<T>
    extends StandardCoder<WindowedValue<T>> {
        final Coder<T> valueCoder;

        WindowedValueCoder(Coder<T> valueCoder) {
            this.valueCoder = Preconditions.checkNotNull(valueCoder);
        }

        public Coder<T> getValueCoder() {
            return this.valueCoder;
        }

        public abstract <NewT> WindowedValueCoder<NewT> withValueCoder(Coder<NewT> var1);
    }

    private static class TimestampedValueInMultipleWindows<T>
    extends TimestampedWindowedValue<T> {
        private Collection<? extends BoundedWindow> windows;

        public TimestampedValueInMultipleWindows(T value, Instant timestamp, Collection<? extends BoundedWindow> windows, PaneInfo pane) {
            super(value, timestamp, pane);
            this.windows = Preconditions.checkNotNull(windows);
        }

        @Override
        public <NewT> WindowedValue<NewT> withValue(NewT value) {
            return new TimestampedValueInMultipleWindows<NewT>(value, this.timestamp, this.windows, this.pane);
        }

        @Override
        public Collection<? extends BoundedWindow> getWindows() {
            return this.windows;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof TimestampedValueInMultipleWindows) {
                TimestampedValueInMultipleWindows that = (TimestampedValueInMultipleWindows)o;
                if (this.timestamp.isEqual((ReadableInstant)that.timestamp) && Objects.equals(that.value, this.value) && Objects.equals(that.pane, this.pane)) {
                    this.ensureWindowsAreASet();
                    that.ensureWindowsAreASet();
                    return that.windows.equals(this.windows);
                }
            }
            return false;
        }

        @Override
        public int hashCode() {
            this.ensureWindowsAreASet();
            return Objects.hash(this.value, this.timestamp.getMillis(), this.pane, this.windows);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.value).add("timestamp", this.timestamp).add("windows", this.windows).add("pane", this.pane).toString();
        }

        private void ensureWindowsAreASet() {
            if (!(this.windows instanceof Set)) {
                this.windows = new LinkedHashSet<BoundedWindow>(this.windows);
            }
        }
    }

    private static class TimestampedValueInSingleWindow<T>
    extends TimestampedWindowedValue<T> {
        private final BoundedWindow window;

        public TimestampedValueInSingleWindow(T value, Instant timestamp, BoundedWindow window, PaneInfo pane) {
            super(value, timestamp, pane);
            this.window = Preconditions.checkNotNull(window);
        }

        @Override
        public <NewT> WindowedValue<NewT> withValue(NewT value) {
            return new TimestampedValueInSingleWindow<NewT>(value, this.timestamp, this.window, this.pane);
        }

        @Override
        public Collection<? extends BoundedWindow> getWindows() {
            return Collections.singletonList(this.window);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof TimestampedValueInSingleWindow) {
                TimestampedValueInSingleWindow that = (TimestampedValueInSingleWindow)o;
                return Objects.equals(that.value, this.value) && this.timestamp.isEqual((ReadableInstant)that.timestamp) && Objects.equals(that.pane, this.pane) && Objects.equals(that.window, this.window);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value, this.timestamp.getMillis(), this.pane, this.window);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.value).add("timestamp", this.timestamp).add("window", this.window).add("pane", this.pane).toString();
        }
    }

    private static class TimestampedValueInGlobalWindow<T>
    extends TimestampedWindowedValue<T> {
        public TimestampedValueInGlobalWindow(T value, Instant timestamp, PaneInfo pane) {
            super(value, timestamp, pane);
        }

        @Override
        public <NewT> WindowedValue<NewT> withValue(NewT value) {
            return new TimestampedValueInGlobalWindow<NewT>(value, this.timestamp, this.pane);
        }

        @Override
        public Collection<? extends BoundedWindow> getWindows() {
            return GLOBAL_WINDOWS;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof TimestampedValueInGlobalWindow) {
                TimestampedValueInGlobalWindow that = (TimestampedValueInGlobalWindow)o;
                return this.timestamp.isEqual((ReadableInstant)that.timestamp) && Objects.equals(that.pane, this.pane) && Objects.equals(that.value, this.value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value, this.pane, this.timestamp.getMillis());
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.value).add("timestamp", this.timestamp).add("pane", this.pane).toString();
        }
    }

    private static abstract class TimestampedWindowedValue<T>
    extends WindowedValue<T> {
        protected final Instant timestamp;

        public TimestampedWindowedValue(T value, Instant timestamp, PaneInfo pane) {
            super(value, pane);
            this.timestamp = Preconditions.checkNotNull(timestamp);
        }

        @Override
        public Instant getTimestamp() {
            return this.timestamp;
        }
    }

    private static class ValueInEmptyWindows<T>
    extends MinTimestampWindowedValue<T> {
        public ValueInEmptyWindows(T value, PaneInfo pane) {
            super(value, pane);
        }

        @Override
        public <NewT> WindowedValue<NewT> withValue(NewT value) {
            return new ValueInEmptyWindows<NewT>(value, this.pane);
        }

        @Override
        public Collection<? extends BoundedWindow> getWindows() {
            return Collections.emptyList();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ValueInEmptyWindows) {
                ValueInEmptyWindows that = (ValueInEmptyWindows)o;
                return Objects.equals(that.pane, this.pane) && Objects.equals(that.value, this.value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value, this.pane);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.value).add("pane", this.pane).toString();
        }
    }

    private static class ValueInGlobalWindow<T>
    extends MinTimestampWindowedValue<T> {
        public ValueInGlobalWindow(T value, PaneInfo pane) {
            super(value, pane);
        }

        @Override
        public <NewT> WindowedValue<NewT> withValue(NewT value) {
            return new ValueInGlobalWindow<NewT>(value, this.pane);
        }

        @Override
        public Collection<? extends BoundedWindow> getWindows() {
            return GLOBAL_WINDOWS;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof ValueInGlobalWindow) {
                ValueInGlobalWindow that = (ValueInGlobalWindow)o;
                return Objects.equals(that.pane, this.pane) && Objects.equals(that.value, this.value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value, this.pane);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("value", this.value).add("pane", this.pane).toString();
        }
    }

    private static abstract class MinTimestampWindowedValue<T>
    extends WindowedValue<T> {
        public MinTimestampWindowedValue(T value, PaneInfo pane) {
            super(value, pane);
        }

        @Override
        public Instant getTimestamp() {
            return BoundedWindow.TIMESTAMP_MIN_VALUE;
        }
    }
}

