/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.transforms.DoFn;
import com.google.cloud.dataflow.sdk.transforms.GroupByKey;
import com.google.cloud.dataflow.sdk.transforms.PTransform;
import com.google.cloud.dataflow.sdk.transforms.ParDo;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.Window;
import com.google.cloud.dataflow.sdk.util.IdentityWindowFn;
import com.google.cloud.dataflow.sdk.util.ReshuffleTrigger;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.values.KV;
import com.google.cloud.dataflow.sdk.values.PCollection;
import org.joda.time.Duration;

public class Reshuffle<K, V>
extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, V>>> {
    private Reshuffle() {
    }

    public static <K, V> Reshuffle<K, V> of() {
        return new Reshuffle<K, V>();
    }

    @Override
    public PCollection<KV<K, V>> apply(PCollection<KV<K, V>> input) {
        WindowingStrategy<?, ?> originalStrategy = input.getWindowingStrategy();
        Window.Bound rewindow = Window.into(new IdentityWindowFn(originalStrategy.getWindowFn().windowCoder(), originalStrategy.getWindowFn().assignsToSingleWindow())).triggering(new ReshuffleTrigger()).discardingFiredPanes().withAllowedLateness(Duration.millis((long)BoundedWindow.TIMESTAMP_MAX_VALUE.getMillis()));
        return (PCollection)((PCollection)((PCollection)input.apply(rewindow)).apply(GroupByKey.create())).setWindowingStrategyInternal(originalStrategy).apply(ParDo.named("ExpandIterable").of(new DoFn<KV<K, Iterable<V>>, KV<K, V>>(){

            @Override
            public void processElement(DoFn.ProcessContext c) {
                Object key = ((KV)c.element()).getKey();
                for (Object value : (Iterable)((KV)c.element()).getValue()) {
                    c.output(KV.of(key, value));
                }
            }
        }));
    }
}

