/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.coders.Coder;
import com.google.cloud.dataflow.sdk.options.PipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.transforms.windowing.PaneInfo;
import com.google.cloud.dataflow.sdk.util.ActiveWindowSet;
import com.google.cloud.dataflow.sdk.util.ReduceFn;
import com.google.cloud.dataflow.sdk.util.TimeDomain;
import com.google.cloud.dataflow.sdk.util.TimerInternals;
import com.google.cloud.dataflow.sdk.util.Timers;
import com.google.cloud.dataflow.sdk.util.WindowingInternals;
import com.google.cloud.dataflow.sdk.util.WindowingStrategy;
import com.google.cloud.dataflow.sdk.util.state.MergingStateAccessor;
import com.google.cloud.dataflow.sdk.util.state.ReadableState;
import com.google.cloud.dataflow.sdk.util.state.State;
import com.google.cloud.dataflow.sdk.util.state.StateAccessor;
import com.google.cloud.dataflow.sdk.util.state.StateContext;
import com.google.cloud.dataflow.sdk.util.state.StateContexts;
import com.google.cloud.dataflow.sdk.util.state.StateInternals;
import com.google.cloud.dataflow.sdk.util.state.StateNamespace;
import com.google.cloud.dataflow.sdk.util.state.StateNamespaces;
import com.google.cloud.dataflow.sdk.util.state.StateTag;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.Instant;

class ReduceFnContextFactory<K, InputT, OutputT, W extends BoundedWindow> {
    private final K key;
    private final ReduceFn<K, InputT, OutputT, W> reduceFn;
    private final WindowingStrategy<?, W> windowingStrategy;
    private final StateInternals<K> stateInternals;
    private final ActiveWindowSet<W> activeWindows;
    private final TimerInternals timerInternals;
    private final WindowingInternals<?, ?> windowingInternals;
    private final PipelineOptions options;

    ReduceFnContextFactory(K key, ReduceFn<K, InputT, OutputT, W> reduceFn, WindowingStrategy<?, W> windowingStrategy, StateInternals<K> stateInternals, ActiveWindowSet<W> activeWindows, TimerInternals timerInternals, WindowingInternals<?, ?> windowingInternals, PipelineOptions options) {
        this.key = key;
        this.reduceFn = reduceFn;
        this.windowingStrategy = windowingStrategy;
        this.stateInternals = stateInternals;
        this.activeWindows = activeWindows;
        this.timerInternals = timerInternals;
        this.windowingInternals = windowingInternals;
        this.options = options;
    }

    private StateAccessorImpl<K, W> stateAccessor(W window, StateStyle style) {
        return new StateAccessorImpl<K, W>(this.activeWindows, this.windowingStrategy.getWindowFn().windowCoder(), this.stateInternals, StateContexts.createFromComponents(this.options, this.windowingInternals, window), style);
    }

    public ReduceFn.Context base(W window, StateStyle style) {
        return new ContextImpl(this.stateAccessor(window, style));
    }

    public ReduceFn.ProcessValueContext forValue(W window, InputT value, Instant timestamp, StateStyle style) {
        return new ProcessValueContextImpl(this.stateAccessor(window, style), value, timestamp);
    }

    public ReduceFn.OnTriggerContext forTrigger(W window, ReadableState<PaneInfo> pane, StateStyle style, OnTriggerCallbacks<OutputT> callbacks) {
        return new OnTriggerContextImpl(this.stateAccessor(window, style), pane, callbacks);
    }

    public ReduceFn.OnMergeContext forMerge(Collection<W> activeToBeMerged, W mergeResult, StateStyle style) {
        return new OnMergeContextImpl(new MergingStateAccessorImpl<K, W>(this.activeWindows, this.windowingStrategy.getWindowFn().windowCoder(), this.stateInternals, style, activeToBeMerged, mergeResult));
    }

    public ReduceFn.OnMergeContext forPremerge(W window) {
        return new OnPremergeContextImpl(new PremergingStateAccessorImpl<K, W>(this.activeWindows, this.windowingStrategy.getWindowFn().windowCoder(), this.stateInternals, window));
    }

    private class OnPremergeContextImpl
    extends ReduceFn.OnMergeContext {
        private final PremergingStateAccessorImpl<K, W> state;
        private final TimersImpl timers;

        private OnPremergeContextImpl(PremergingStateAccessorImpl<K, W> state) {
            super(ReduceFnContextFactory.this.reduceFn);
            this.state = state;
            this.timers = new TimersImpl(state.namespace());
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public WindowingStrategy<?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public MergingStateAccessor<K, W> state() {
            return this.state;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public Timers timers() {
            return this.timers;
        }
    }

    private class OnMergeContextImpl
    extends ReduceFn.OnMergeContext {
        private final MergingStateAccessorImpl<K, W> state;
        private final TimersImpl timers;

        private OnMergeContextImpl(MergingStateAccessorImpl<K, W> state) {
            super(ReduceFnContextFactory.this.reduceFn);
            this.state = state;
            this.timers = new TimersImpl(state.namespace());
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public WindowingStrategy<?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public MergingStateAccessor<K, W> state() {
            return this.state;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public Timers timers() {
            return this.timers;
        }
    }

    private class OnTriggerContextImpl
    extends ReduceFn.OnTriggerContext {
        private final StateAccessorImpl<K, W> state;
        private final ReadableState<PaneInfo> pane;
        private final OnTriggerCallbacks<OutputT> callbacks;
        private final TimersImpl timers;

        private OnTriggerContextImpl(StateAccessorImpl<K, W> state, ReadableState<PaneInfo> pane, OnTriggerCallbacks<OutputT> callbacks) {
            super(ReduceFnContextFactory.this.reduceFn);
            this.state = state;
            this.pane = pane;
            this.callbacks = callbacks;
            this.timers = new TimersImpl(state.namespace());
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public WindowingStrategy<?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public StateAccessor<K> state() {
            return this.state;
        }

        @Override
        public PaneInfo paneInfo() {
            return this.pane.read();
        }

        @Override
        public void output(OutputT value) {
            this.callbacks.output(value);
        }

        @Override
        public Timers timers() {
            return this.timers;
        }
    }

    private class ProcessValueContextImpl
    extends ReduceFn.ProcessValueContext {
        private final InputT value;
        private final Instant timestamp;
        private final StateAccessorImpl<K, W> state;
        private final TimersImpl timers;

        private ProcessValueContextImpl(StateAccessorImpl<K, W> state, InputT value, Instant timestamp) {
            super(ReduceFnContextFactory.this.reduceFn);
            this.state = state;
            this.value = value;
            this.timestamp = timestamp;
            this.timers = new TimersImpl(state.namespace());
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public WindowingStrategy<?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public StateAccessor<K> state() {
            return this.state;
        }

        @Override
        public InputT value() {
            return this.value;
        }

        @Override
        public Instant timestamp() {
            return this.timestamp;
        }

        @Override
        public Timers timers() {
            return this.timers;
        }
    }

    private class ContextImpl
    extends ReduceFn.Context {
        private final StateAccessorImpl<K, W> state;
        private final TimersImpl timers;

        private ContextImpl(StateAccessorImpl<K, W> state) {
            super(ReduceFnContextFactory.this.reduceFn);
            this.state = state;
            this.timers = new TimersImpl(state.namespace());
        }

        @Override
        public K key() {
            return ReduceFnContextFactory.this.key;
        }

        @Override
        public W window() {
            return this.state.window();
        }

        @Override
        public WindowingStrategy<?, W> windowingStrategy() {
            return ReduceFnContextFactory.this.windowingStrategy;
        }

        @Override
        public StateAccessor<K> state() {
            return this.state;
        }

        @Override
        public Timers timers() {
            return this.timers;
        }
    }

    static class PremergingStateAccessorImpl<K, W extends BoundedWindow>
    extends StateAccessorImpl<K, W>
    implements MergingStateAccessor<K, W> {
        public PremergingStateAccessorImpl(ActiveWindowSet<W> activeWindows, Coder<W> windowCoder, StateInternals<K> stateInternals, W window) {
            super(activeWindows, windowCoder, stateInternals, StateContexts.windowOnly(window), StateStyle.RENAMED);
        }

        Collection<W> mergingWindows() {
            return this.activeWindows.readStateAddresses(this.context.window());
        }

        @Override
        public <StateT extends State> Map<W, StateT> accessInEachMergingWindow(StateTag<? super K, StateT> address) {
            ImmutableMap.Builder<BoundedWindow, StateT> builder = ImmutableMap.builder();
            for (BoundedWindow stateAddressWindow : this.activeWindows.readStateAddresses(this.context.window())) {
                StateT stateForWindow = this.stateInternals.state(this.namespaceFor(stateAddressWindow), address, this.context);
                builder.put(stateAddressWindow, stateForWindow);
            }
            return builder.build();
        }
    }

    static class MergingStateAccessorImpl<K, W extends BoundedWindow>
    extends StateAccessorImpl<K, W>
    implements MergingStateAccessor<K, W> {
        private final Collection<W> activeToBeMerged;

        public MergingStateAccessorImpl(ActiveWindowSet<W> activeWindows, Coder<W> windowCoder, StateInternals<K> stateInternals, StateStyle style, Collection<W> activeToBeMerged, W mergeResult) {
            super(activeWindows, windowCoder, stateInternals, StateContexts.windowOnly(mergeResult), style);
            this.activeToBeMerged = activeToBeMerged;
        }

        @Override
        public <StateT extends State> StateT access(StateTag<? super K, StateT> address) {
            switch (this.style) {
                case DIRECT: {
                    return this.stateInternals.state(this.windowNamespace(), address, this.context);
                }
                case RENAMED: {
                    return this.stateInternals.state(this.namespaceFor(this.activeWindows.mergedWriteStateAddress(this.activeToBeMerged, this.context.window())), address, this.context);
                }
            }
            throw new RuntimeException();
        }

        @Override
        public <StateT extends State> Map<W, StateT> accessInEachMergingWindow(StateTag<? super K, StateT> address) {
            ImmutableMap.Builder<BoundedWindow, StateT> builder = ImmutableMap.builder();
            for (BoundedWindow mergingWindow : this.activeToBeMerged) {
                StateNamespace namespace = null;
                switch (this.style) {
                    case DIRECT: {
                        namespace = this.namespaceFor(mergingWindow);
                        break;
                    }
                    case RENAMED: {
                        namespace = this.namespaceFor(this.activeWindows.writeStateAddress(mergingWindow));
                    }
                }
                Preconditions.checkNotNull(namespace);
                builder.put(mergingWindow, this.stateInternals.state(namespace, address, this.context));
            }
            return builder.build();
        }
    }

    static class StateAccessorImpl<K, W extends BoundedWindow>
    implements StateAccessor<K> {
        protected final ActiveWindowSet<W> activeWindows;
        protected final StateContext<W> context;
        protected final StateNamespace windowNamespace;
        protected final Coder<W> windowCoder;
        protected final StateInternals<K> stateInternals;
        protected final StateStyle style;

        public StateAccessorImpl(ActiveWindowSet<W> activeWindows, Coder<W> windowCoder, StateInternals<K> stateInternals, StateContext<W> context, StateStyle style) {
            this.activeWindows = activeWindows;
            this.windowCoder = windowCoder;
            this.stateInternals = stateInternals;
            this.context = Preconditions.checkNotNull(context);
            this.windowNamespace = this.namespaceFor(context.window());
            this.style = style;
        }

        protected StateNamespace namespaceFor(W window) {
            return StateNamespaces.window(this.windowCoder, window);
        }

        protected StateNamespace windowNamespace() {
            return this.windowNamespace;
        }

        W window() {
            return this.context.window();
        }

        StateNamespace namespace() {
            return this.windowNamespace();
        }

        @Override
        public <StateT extends State> StateT access(StateTag<? super K, StateT> address) {
            switch (this.style) {
                case DIRECT: {
                    return this.stateInternals.state(this.windowNamespace(), address, this.context);
                }
                case RENAMED: {
                    return this.stateInternals.state(this.namespaceFor(this.activeWindows.writeStateAddress(this.context.window())), address, this.context);
                }
            }
            throw new RuntimeException();
        }
    }

    private class TimersImpl
    implements Timers {
        private final StateNamespace namespace;

        public TimersImpl(StateNamespace namespace) {
            Preconditions.checkArgument(namespace instanceof StateNamespaces.WindowNamespace);
            this.namespace = namespace;
        }

        @Override
        public void setTimer(Instant timestamp, TimeDomain timeDomain) {
            ReduceFnContextFactory.this.timerInternals.setTimer(TimerInternals.TimerData.of(this.namespace, timestamp, timeDomain));
        }

        @Override
        public void deleteTimer(Instant timestamp, TimeDomain timeDomain) {
            ReduceFnContextFactory.this.timerInternals.deleteTimer(TimerInternals.TimerData.of(this.namespace, timestamp, timeDomain));
        }

        @Override
        public Instant currentProcessingTime() {
            return ReduceFnContextFactory.this.timerInternals.currentProcessingTime();
        }

        @Override
        @Nullable
        public Instant currentSynchronizedProcessingTime() {
            return ReduceFnContextFactory.this.timerInternals.currentSynchronizedProcessingTime();
        }

        @Override
        public Instant currentEventTime() {
            return ReduceFnContextFactory.this.timerInternals.currentInputWatermarkTime();
        }
    }

    public static enum StateStyle {
        DIRECT,
        RENAMED;

    }

    public static interface OnTriggerCallbacks<OutputT> {
        public void output(OutputT var1);
    }
}

