/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.Iterables;
import com.google.cloud.dataflow.sdk.transforms.windowing.BoundedWindow;
import com.google.cloud.dataflow.sdk.util.DoFnRunner;
import com.google.cloud.dataflow.sdk.util.ReadyCheckingSideInputReader;
import com.google.cloud.dataflow.sdk.util.WindowedValue;
import com.google.cloud.dataflow.sdk.values.PCollectionView;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class PushbackSideInputDoFnRunner<InputT, OutputT>
implements DoFnRunner<InputT, OutputT> {
    private final DoFnRunner<InputT, OutputT> underlying;
    private final Collection<PCollectionView<?>> views;
    private final ReadyCheckingSideInputReader sideInputReader;
    private Set<BoundedWindow> notReadyWindows;

    public static <InputT, OutputT> PushbackSideInputDoFnRunner<InputT, OutputT> create(DoFnRunner<InputT, OutputT> underlying, Collection<PCollectionView<?>> views, ReadyCheckingSideInputReader sideInputReader) {
        return new PushbackSideInputDoFnRunner<InputT, OutputT>(underlying, views, sideInputReader);
    }

    private PushbackSideInputDoFnRunner(DoFnRunner<InputT, OutputT> underlying, Collection<PCollectionView<?>> views, ReadyCheckingSideInputReader sideInputReader) {
        this.underlying = underlying;
        this.views = views;
        this.sideInputReader = sideInputReader;
    }

    @Override
    public void startBundle() {
        this.notReadyWindows = new HashSet<BoundedWindow>();
        this.underlying.startBundle();
    }

    public Iterable<WindowedValue<InputT>> processElementInReadyWindows(WindowedValue<InputT> elem) {
        if (this.views.isEmpty()) {
            this.processElement(elem);
            return Collections.emptyList();
        }
        ImmutableList.Builder pushedBack = ImmutableList.builder();
        for (WindowedValue<InputT> windowElem : elem.explodeWindows()) {
            BoundedWindow mainInputWindow = Iterables.getOnlyElement(windowElem.getWindows());
            boolean isReady = !this.notReadyWindows.contains(mainInputWindow);
            for (PCollectionView<?> view : this.views) {
                Object sideInputWindow;
                if (this.sideInputReader.isReady(view, (BoundedWindow)(sideInputWindow = view.getWindowingStrategyInternal().getWindowFn().getSideInputWindow(mainInputWindow)))) continue;
                isReady = false;
                break;
            }
            if (isReady) {
                this.processElement(windowElem);
                continue;
            }
            this.notReadyWindows.add(mainInputWindow);
            pushedBack.add(windowElem);
        }
        return pushedBack.build();
    }

    @Override
    public void processElement(WindowedValue<InputT> elem) {
        this.underlying.processElement(elem);
    }

    @Override
    public void finishBundle() {
        this.notReadyWindows = null;
        this.underlying.finishBundle();
    }
}

