/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataflow.sdk.util;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.dataflow.sdk.options.DataflowPipelineOptions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.base.Strings;
import com.google.cloud.dataflow.sdk.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.dataflow.sdk.util.PubsubClient;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.DeleteSubscriptionRequest;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetSubscriptionRequest;
import com.google.pubsub.v1.ListSubscriptionsRequest;
import com.google.pubsub.v1.ListSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.PublisherGrpc;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.ReceivedMessage;
import com.google.pubsub.v1.SubscriberGrpc;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.auth.ClientAuthInterceptor;
import io.grpc.internal.ManagedChannelImpl;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class PubsubGrpcClient
extends PubsubClient {
    private static final String PUBSUB_ADDRESS = "pubsub.googleapis.com";
    private static final int PUBSUB_PORT = 443;
    private static final List<String> PUBSUB_SCOPES = Collections.singletonList("https://www.googleapis.com/auth/pubsub");
    private static final int LIST_BATCH_SIZE = 1000;
    private static final int DEFAULT_TIMEOUT_S = 15;
    public static final PubsubClient.PubsubClientFactory FACTORY = new PubsubGrpcClientFactory();
    private final int timeoutSec;
    @Nullable
    private ManagedChannel publisherChannel;
    private final GoogleCredentials credentials;
    @Nullable
    private final String timestampLabel;
    @Nullable
    private final String idLabel;
    @Nullable
    private PublisherGrpc.PublisherBlockingStub cachedPublisherStub;
    private SubscriberGrpc.SubscriberBlockingStub cachedSubscriberStub;

    @VisibleForTesting
    PubsubGrpcClient(@Nullable String timestampLabel, @Nullable String idLabel, int timeoutSec, ManagedChannel publisherChannel, GoogleCredentials credentials, PublisherGrpc.PublisherBlockingStub cachedPublisherStub, SubscriberGrpc.SubscriberBlockingStub cachedSubscriberStub) {
        this.timestampLabel = timestampLabel;
        this.idLabel = idLabel;
        this.timeoutSec = timeoutSec;
        this.publisherChannel = publisherChannel;
        this.credentials = credentials;
        this.cachedPublisherStub = cachedPublisherStub;
        this.cachedSubscriberStub = cachedSubscriberStub;
    }

    @Override
    public void close() {
        if (this.publisherChannel == null) {
            return;
        }
        this.cachedPublisherStub = null;
        this.cachedSubscriberStub = null;
        ManagedChannel publisherChannel = this.publisherChannel;
        this.publisherChannel = null;
        publisherChannel.shutdown();
        if (this.timeoutSec > 0) {
            try {
                publisherChannel.awaitTermination((long)this.timeoutSec, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Channel newChannel() throws IOException {
        Preconditions.checkState(this.publisherChannel != null, "PubsubGrpcClient has been closed");
        ClientAuthInterceptor interceptor = new ClientAuthInterceptor((Credentials)this.credentials, (Executor)Executors.newSingleThreadExecutor());
        return ClientInterceptors.intercept((Channel)this.publisherChannel, (ClientInterceptor[])new ClientInterceptor[]{interceptor});
    }

    private PublisherGrpc.PublisherBlockingStub publisherStub() throws IOException {
        if (this.cachedPublisherStub == null) {
            this.cachedPublisherStub = PublisherGrpc.newBlockingStub((Channel)this.newChannel());
        }
        if (this.timeoutSec > 0) {
            return (PublisherGrpc.PublisherBlockingStub)this.cachedPublisherStub.withDeadlineAfter((long)this.timeoutSec, TimeUnit.SECONDS);
        }
        return this.cachedPublisherStub;
    }

    private SubscriberGrpc.SubscriberBlockingStub subscriberStub() throws IOException {
        if (this.cachedSubscriberStub == null) {
            this.cachedSubscriberStub = SubscriberGrpc.newBlockingStub((Channel)this.newChannel());
        }
        if (this.timeoutSec > 0) {
            return (SubscriberGrpc.SubscriberBlockingStub)this.cachedSubscriberStub.withDeadlineAfter((long)this.timeoutSec, TimeUnit.SECONDS);
        }
        return this.cachedSubscriberStub;
    }

    @Override
    public int publish(PubsubClient.TopicPath topic, List<PubsubClient.OutgoingMessage> outgoingMessages) throws IOException {
        PublishRequest.Builder request = PublishRequest.newBuilder().setTopic(topic.getPath());
        for (PubsubClient.OutgoingMessage outgoingMessage : outgoingMessages) {
            PubsubMessage.Builder message = PubsubMessage.newBuilder().setData(ByteString.copyFrom((byte[])outgoingMessage.elementBytes));
            if (this.timestampLabel != null) {
                message.getMutableAttributes().put(this.timestampLabel, String.valueOf(outgoingMessage.timestampMsSinceEpoch));
            }
            if (this.idLabel != null && !Strings.isNullOrEmpty(outgoingMessage.recordId)) {
                message.getMutableAttributes().put(this.idLabel, outgoingMessage.recordId);
            }
            request.addMessages(message);
        }
        PublishResponse response = this.publisherStub().publish(request.build());
        return response.getMessageIdsCount();
    }

    @Override
    public List<PubsubClient.IncomingMessage> pull(long requestTimeMsSinceEpoch, PubsubClient.SubscriptionPath subscription, int batchSize, boolean returnImmediately) throws IOException {
        PullRequest request = PullRequest.newBuilder().setSubscription(subscription.getPath()).setReturnImmediately(returnImmediately).setMaxMessages(batchSize).build();
        PullResponse response = this.subscriberStub().pull(request);
        if (response.getReceivedMessagesCount() == 0) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.IncomingMessage> incomingMessages = new ArrayList<PubsubClient.IncomingMessage>(response.getReceivedMessagesCount());
        for (ReceivedMessage message : response.getReceivedMessagesList()) {
            PubsubMessage pubsubMessage = message.getMessage();
            Map attributes = pubsubMessage.getAttributes();
            byte[] elementBytes = pubsubMessage.getData().toByteArray();
            String pubsubTimestampString = null;
            Timestamp timestampProto = pubsubMessage.getPublishTime();
            if (timestampProto != null) {
                pubsubTimestampString = String.valueOf(timestampProto.getSeconds() + (long)timestampProto.getNanos() / 1000L);
            }
            long timestampMsSinceEpoch = PubsubGrpcClient.extractTimestamp(this.timestampLabel, pubsubTimestampString, attributes);
            String ackId = message.getAckId();
            Preconditions.checkState(!Strings.isNullOrEmpty(ackId));
            String recordId = null;
            if (this.idLabel != null && attributes != null) {
                recordId = (String)attributes.get(this.idLabel);
            }
            if (Strings.isNullOrEmpty(recordId)) {
                recordId = pubsubMessage.getMessageId();
            }
            incomingMessages.add(new PubsubClient.IncomingMessage(elementBytes, timestampMsSinceEpoch, requestTimeMsSinceEpoch, ackId, recordId));
        }
        return incomingMessages;
    }

    @Override
    public void acknowledge(PubsubClient.SubscriptionPath subscription, List<String> ackIds) throws IOException {
        AcknowledgeRequest request = AcknowledgeRequest.newBuilder().setSubscription(subscription.getPath()).addAllAckIds(ackIds).build();
        this.subscriberStub().acknowledge(request);
    }

    @Override
    public void modifyAckDeadline(PubsubClient.SubscriptionPath subscription, List<String> ackIds, int deadlineSeconds) throws IOException {
        ModifyAckDeadlineRequest request = ModifyAckDeadlineRequest.newBuilder().setSubscription(subscription.getPath()).addAllAckIds(ackIds).setAckDeadlineSeconds(deadlineSeconds).build();
        this.subscriberStub().modifyAckDeadline(request);
    }

    @Override
    public void createTopic(PubsubClient.TopicPath topic) throws IOException {
        Topic request = Topic.newBuilder().setName(topic.getPath()).build();
        this.publisherStub().createTopic(request);
    }

    @Override
    public void deleteTopic(PubsubClient.TopicPath topic) throws IOException {
        DeleteTopicRequest request = DeleteTopicRequest.newBuilder().setTopic(topic.getPath()).build();
        this.publisherStub().deleteTopic(request);
    }

    @Override
    public List<PubsubClient.TopicPath> listTopics(PubsubClient.ProjectPath project) throws IOException {
        ListTopicsRequest.Builder request = ListTopicsRequest.newBuilder().setProject(project.getPath()).setPageSize(1000);
        ListTopicsResponse response = this.publisherStub().listTopics(request.build());
        if (response.getTopicsCount() == 0) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.TopicPath> topics = new ArrayList<PubsubClient.TopicPath>(response.getTopicsCount());
        while (true) {
            for (Topic topic : response.getTopicsList()) {
                topics.add(PubsubGrpcClient.topicPathFromPath(topic.getName()));
            }
            if (response.getNextPageToken().isEmpty()) break;
            request.setPageToken(response.getNextPageToken());
            response = this.publisherStub().listTopics(request.build());
        }
        return topics;
    }

    @Override
    public void createSubscription(PubsubClient.TopicPath topic, PubsubClient.SubscriptionPath subscription, int ackDeadlineSeconds) throws IOException {
        Subscription request = Subscription.newBuilder().setTopic(topic.getPath()).setName(subscription.getPath()).setAckDeadlineSeconds(ackDeadlineSeconds).build();
        this.subscriberStub().createSubscription(request);
    }

    @Override
    public void deleteSubscription(PubsubClient.SubscriptionPath subscription) throws IOException {
        DeleteSubscriptionRequest request = DeleteSubscriptionRequest.newBuilder().setSubscription(subscription.getPath()).build();
        this.subscriberStub().deleteSubscription(request);
    }

    @Override
    public List<PubsubClient.SubscriptionPath> listSubscriptions(PubsubClient.ProjectPath project, PubsubClient.TopicPath topic) throws IOException {
        ListSubscriptionsRequest.Builder request = ListSubscriptionsRequest.newBuilder().setProject(project.getPath()).setPageSize(1000);
        ListSubscriptionsResponse response = this.subscriberStub().listSubscriptions(request.build());
        if (response.getSubscriptionsCount() == 0) {
            return ImmutableList.of();
        }
        ArrayList<PubsubClient.SubscriptionPath> subscriptions = new ArrayList<PubsubClient.SubscriptionPath>(response.getSubscriptionsCount());
        while (true) {
            for (Subscription subscription : response.getSubscriptionsList()) {
                if (!subscription.getTopic().equals(topic.getPath())) continue;
                subscriptions.add(PubsubGrpcClient.subscriptionPathFromPath(subscription.getName()));
            }
            if (response.getNextPageToken().isEmpty()) break;
            request.setPageToken(response.getNextPageToken());
            response = this.subscriberStub().listSubscriptions(request.build());
        }
        return subscriptions;
    }

    @Override
    public int ackDeadlineSeconds(PubsubClient.SubscriptionPath subscription) throws IOException {
        GetSubscriptionRequest request = GetSubscriptionRequest.newBuilder().setSubscription(subscription.getPath()).build();
        Subscription response = this.subscriberStub().getSubscription(request);
        return response.getAckDeadlineSeconds();
    }

    @Override
    public boolean isEOF() {
        return false;
    }

    private static class PubsubGrpcClientFactory
    implements PubsubClient.PubsubClientFactory {
        private PubsubGrpcClientFactory() {
        }

        @Override
        public PubsubClient newClient(@Nullable String timestampLabel, @Nullable String idLabel, DataflowPipelineOptions options) throws IOException {
            ManagedChannelImpl channel = NettyChannelBuilder.forAddress((String)PubsubGrpcClient.PUBSUB_ADDRESS, (int)443).negotiationType(NegotiationType.TLS).sslContext(GrpcSslContexts.forClient().ciphers(null).build()).build();
            GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
            return new PubsubGrpcClient(timestampLabel, idLabel, 15, (ManagedChannel)channel, credentials, null, null);
        }

        @Override
        public String getKind() {
            return "Grpc";
        }
    }
}

